/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view.component;

import cn.com.voltronic.solar.view.component.ComboCheckBoxEntry;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class ComboCheckBoxUI
extends MetalComboBoxUI {
    private boolean isMultiSel = true;
    public int maxWidth = 300;

    public ComboCheckBoxUI() {
    }

    public ComboCheckBoxUI(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public static ComponentUI createUI(JComponent c) {
        return new ComboCheckBoxUI();
    }

    @Override
    protected ComboPopup createPopup() {
        ComboCheckPopUp popUp = new ComboCheckPopUp(this.comboBox, this.maxWidth);
        popUp.getAccessibleContext().setAccessibleParent(this.comboBox);
        return popUp;
    }

    public class ComboCheckPopUp
    extends BasicComboPopup {
        private static final long serialVersionUID = -37435227302289947L;
        private int width;
        private int maxWidth;

        public ComboCheckPopUp(JComboBox cBox, int maxWidth) {
            super(cBox);
            this.width = -1;
            this.maxWidth = 300;
            this.maxWidth = maxWidth;
        }

        @Override
        protected JScrollPane createScroller() {
            return new JScrollPane(this.list, 20, 30);
        }

        @Override
        protected MouseListener createListMouseListener() {
            return new CheckBoxListMouseHandler();
        }

        @Override
        protected KeyListener createKeyListener() {
            return new CheckBoxKeyHandler();
        }

        @Override
        public void show() {
            int maxWidthOfCell;
            Dimension popupSize = this.comboBox.getSize();
            Insets insets = this.getInsets();
            popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            this.width = maxWidthOfCell = this.calcPreferredWidth();
            if (this.comboBox.getItemCount() > this.comboBox.getMaximumRowCount()) {
                this.width += this.scroller.getVerticalScrollBar().getPreferredSize().width;
            }
            if (this.width > this.maxWidth) {
                this.width = this.maxWidth;
            }
            if (this.width < this.comboBox.getWidth()) {
                this.width = this.comboBox.getWidth();
            }
            if (maxWidthOfCell > this.width) {
                popupSize.height += this.scroller.getHorizontalScrollBar().getPreferredSize().height;
            }
            Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, this.width, popupSize.height);
            this.scroller.setMaximumSize(popupBounds.getSize());
            this.scroller.setPreferredSize(popupBounds.getSize());
            this.scroller.setMinimumSize(popupBounds.getSize());
            this.list.invalidate();
            this.syncListSelectionWithComboBoxSelection();
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
            this.setLightWeightPopupEnabled(this.comboBox.isLightWeightPopupEnabled());
            this.show(this.comboBox, popupBounds.x, popupBounds.y);
        }

        private int calcPreferredWidth() {
            int prefferedWidth = 0;
            ListCellRenderer renderer = this.list.getCellRenderer();
            int index = 0;
            int count = this.list.getModel().getSize();
            while (index < count) {
                Object element = this.list.getModel().getElementAt(index);
                Component comp = renderer.getListCellRendererComponent(this.list, element, index, false, false);
                Dimension dim = comp.getPreferredSize();
                if (dim.width > prefferedWidth) {
                    prefferedWidth = dim.width;
                }
                ++index;
            }
            return prefferedWidth;
        }

        void syncListSelectionWithComboBoxSelection() {
            int selectedIndex = this.comboBox.getSelectedIndex();
            if (selectedIndex == -1) {
                this.list.clearSelection();
            } else {
                this.list.setSelectedIndex(selectedIndex);
            }
        }

        public void setPopupWidth(int width) {
            this.width = width;
        }

        protected class CheckBoxKeyHandler
        extends KeyAdapter {
            protected CheckBoxKeyHandler() {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                ComboCheckBoxUI.this.isMultiSel = true;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                ComboCheckBoxUI.this.isMultiSel = true;
            }
        }

        protected class CheckBoxListMouseHandler
        extends MouseAdapter {
            protected CheckBoxListMouseHandler() {
            }

            @Override
            public void mousePressed(MouseEvent anEvent) {
                int index = ComboCheckPopUp.this.list.getSelectedIndex();
                ComboCheckBoxEntry item = (ComboCheckBoxEntry)ComboCheckPopUp.this.list.getModel().getElementAt(index);
                int size = ComboCheckPopUp.this.list.getModel().getSize();
                if (ComboCheckBoxUI.this.isMultiSel) {
                    if (item.isEnable()) {
                        boolean checked = !item.isChecked();
                        item.setChecked(checked);
                    }
                } else {
                    int i = 0;
                    while (i < size) {
                        ComboCheckBoxEntry ccbe = (ComboCheckBoxEntry)ComboCheckPopUp.this.list.getModel().getElementAt(i);
                        ccbe.setChecked(false);
                        ++i;
                    }
                    item.setChecked(true);
                }
                ComboCheckPopUp.this.updateListBoxSelectionForEvent(anEvent, false);
                Rectangle rect = ComboCheckPopUp.this.list.getCellBounds(0, size - 1);
                ComboCheckPopUp.this.list.repaint(rect);
            }

            @Override
            public void mouseReleased(MouseEvent anEvent) {
                ComboCheckBoxEntry item;
                if (!ComboCheckBoxUI.this.isMultiSel && (item = (ComboCheckBoxEntry)ComboCheckPopUp.this.list.getSelectedValue()).isChecked()) {
                    ComboCheckPopUp.this.comboBox.setSelectedIndex(ComboCheckPopUp.this.list.getSelectedIndex());
                    ComboCheckPopUp.this.comboBox.setPopupVisible(false);
                }
            }
        }
    }
}

