/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;

public class LocalGregorianCalendar
extends BaseCalendar {
    private String name;
    private Era[] eras;

    static LocalGregorianCalendar getLocalGregorianCalendar(String string) {
        Era[] eraArray;
        Object object;
        String string2;
        Properties properties = null;
        try {
            string2 = AccessController.doPrivileged(new GetPropertyAction("java.home"));
            object = string2 + File.separator + "lib" + File.separator + "calendars.properties";
            properties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object){
                final /* synthetic */ String val$fname;
                {
                    this.val$fname = string;
                }

                public Object run() throws IOException {
                    Properties properties = new Properties();
                    try (FileInputStream fileInputStream = new FileInputStream(this.val$fname);){
                        properties.load(fileInputStream);
                    }
                    return properties;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new RuntimeException(privilegedActionException.getException());
        }
        string2 = properties.getProperty("calendar." + string + ".eras");
        if (string2 == null) {
            return null;
        }
        object = new ArrayList();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            Object object2;
            eraArray = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer((String)eraArray, ",");
            String string3 = null;
            boolean bl = true;
            long l = 0L;
            String string4 = null;
            while (stringTokenizer2.hasMoreTokens()) {
                object2 = stringTokenizer2.nextToken();
                int n = ((String)object2).indexOf(61);
                if (n == -1) {
                    return null;
                }
                String string5 = ((String)object2).substring(0, n);
                String string6 = ((String)object2).substring(n + 1);
                if ("name".equals(string5)) {
                    string3 = string6;
                    continue;
                }
                if ("since".equals(string5)) {
                    if (string6.endsWith("u")) {
                        bl = false;
                        l = Long.parseLong(string6.substring(0, string6.length() - 1));
                        continue;
                    }
                    l = Long.parseLong(string6);
                    continue;
                }
                if ("abbr".equals(string5)) {
                    string4 = string6;
                    continue;
                }
                throw new RuntimeException("Unknown key word: " + string5);
            }
            object2 = new Era(string3, string4, l, bl);
            object.add(object2);
        }
        eraArray = new Era[object.size()];
        object.toArray(eraArray);
        return new LocalGregorianCalendar(string, eraArray);
    }

    private LocalGregorianCalendar(String string, Era[] eraArray) {
        this.name = string;
        this.eras = eraArray;
        this.setEras(eraArray);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Date getCalendarDate() {
        return this.getCalendarDate(System.currentTimeMillis(), this.newCalendarDate());
    }

    @Override
    public Date getCalendarDate(long l) {
        return this.getCalendarDate(l, this.newCalendarDate());
    }

    @Override
    public Date getCalendarDate(long l, TimeZone timeZone) {
        return this.getCalendarDate(l, this.newCalendarDate(timeZone));
    }

    @Override
    public Date getCalendarDate(long l, CalendarDate calendarDate) {
        Date date = (Date)super.getCalendarDate(l, calendarDate);
        return this.adjustYear(date, l, date.getZoneOffset());
    }

    private Date adjustYear(Date date, long l, int n) {
        int n2;
        for (n2 = this.eras.length - 1; n2 >= 0; --n2) {
            Era era = this.eras[n2];
            long l2 = era.getSince(null);
            if (era.isLocalTime()) {
                l2 -= (long)n;
            }
            if (l < l2) continue;
            date.setLocalEra(era);
            int n3 = date.getNormalizedYear() - era.getSinceDate().getYear() + 1;
            date.setLocalYear(n3);
            break;
        }
        if (n2 < 0) {
            date.setLocalEra(null);
            date.setLocalYear(date.getNormalizedYear());
        }
        date.setNormalized(true);
        return date;
    }

    @Override
    public Date newCalendarDate() {
        return new Date();
    }

    @Override
    public Date newCalendarDate(TimeZone timeZone) {
        return new Date(timeZone);
    }

    @Override
    public boolean validate(CalendarDate calendarDate) {
        Date date = (Date)calendarDate;
        Era era = date.getEra();
        if (era != null) {
            if (!this.validateEra(era)) {
                return false;
            }
            date.setNormalizedYear(era.getSinceDate().getYear() + date.getYear());
        } else {
            date.setNormalizedYear(date.getYear());
        }
        return super.validate(date);
    }

    private boolean validateEra(Era era) {
        for (int i = 0; i < this.eras.length; ++i) {
            if (era != this.eras[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean normalize(CalendarDate calendarDate) {
        int n;
        if (calendarDate.isNormalized()) {
            return true;
        }
        this.normalizeYear(calendarDate);
        Date date = (Date)calendarDate;
        super.normalize(date);
        boolean bl = false;
        long l = 0L;
        int n2 = date.getNormalizedYear();
        Era era = null;
        for (n = this.eras.length - 1; n >= 0; --n) {
            long l2;
            era = this.eras[n];
            if (era.isLocalTime()) {
                long l3;
                int n3;
                int n4;
                CalendarDate calendarDate2 = era.getSinceDate();
                int n5 = calendarDate2.getYear();
                if (n2 > n5) break;
                if (n2 != n5) continue;
                int n6 = date.getMonth();
                if (n6 > (n4 = calendarDate2.getMonth())) break;
                if (n6 != n4) continue;
                int n7 = date.getDayOfMonth();
                if (n7 > (n3 = calendarDate2.getDayOfMonth())) break;
                if (n7 != n3) continue;
                long l4 = date.getTimeOfDay();
                if (l4 >= (l3 = calendarDate2.getTimeOfDay())) break;
                --n;
                break;
            }
            if (!bl) {
                l = super.getTime(calendarDate);
                bl = true;
            }
            if (l >= (l2 = era.getSince(calendarDate.getZone()))) break;
        }
        if (n >= 0) {
            date.setLocalEra(era);
            int n8 = date.getNormalizedYear() - era.getSinceDate().getYear() + 1;
            date.setLocalYear(n8);
        } else {
            date.setEra(null);
            date.setLocalYear(n2);
            date.setNormalizedYear(n2);
        }
        date.setNormalized(true);
        return true;
    }

    @Override
    void normalizeMonth(CalendarDate calendarDate) {
        this.normalizeYear(calendarDate);
        super.normalizeMonth(calendarDate);
    }

    void normalizeYear(CalendarDate calendarDate) {
        Date date = (Date)calendarDate;
        Era era = date.getEra();
        if (era == null || !this.validateEra(era)) {
            date.setNormalizedYear(date.getYear());
        } else {
            date.setNormalizedYear(era.getSinceDate().getYear() + date.getYear() - 1);
        }
    }

    @Override
    public boolean isLeapYear(int n) {
        return CalendarUtils.isGregorianLeapYear(n);
    }

    public boolean isLeapYear(Era era, int n) {
        if (era == null) {
            return this.isLeapYear(n);
        }
        int n2 = era.getSinceDate().getYear() + n - 1;
        return this.isLeapYear(n2);
    }

    @Override
    public void getCalendarDateFromFixedDate(CalendarDate calendarDate, long l) {
        Date date = (Date)calendarDate;
        super.getCalendarDateFromFixedDate(date, l);
        this.adjustYear(date, (l - 719163L) * 86400000L, 0);
    }

    public static class Date
    extends BaseCalendar.Date {
        private int gregorianYear = Integer.MIN_VALUE;

        protected Date() {
        }

        protected Date(TimeZone timeZone) {
            super(timeZone);
        }

        @Override
        public Date setEra(Era era) {
            if (this.getEra() != era) {
                super.setEra(era);
                this.gregorianYear = Integer.MIN_VALUE;
            }
            return this;
        }

        @Override
        public Date addYear(int n) {
            super.addYear(n);
            this.gregorianYear += n;
            return this;
        }

        @Override
        public Date setYear(int n) {
            if (this.getYear() != n) {
                super.setYear(n);
                this.gregorianYear = Integer.MIN_VALUE;
            }
            return this;
        }

        @Override
        public int getNormalizedYear() {
            return this.gregorianYear;
        }

        @Override
        public void setNormalizedYear(int n) {
            this.gregorianYear = n;
        }

        void setLocalEra(Era era) {
            super.setEra(era);
        }

        void setLocalYear(int n) {
            super.setYear(n);
        }

        @Override
        public String toString() {
            String string;
            String string2 = super.toString();
            string2 = string2.substring(string2.indexOf(84));
            StringBuffer stringBuffer = new StringBuffer();
            Era era = this.getEra();
            if (era != null && (string = era.getAbbreviation()) != null) {
                stringBuffer.append(string);
            }
            stringBuffer.append(this.getYear()).append('.');
            CalendarUtils.sprintf0d(stringBuffer, this.getMonth(), 2).append('.');
            CalendarUtils.sprintf0d(stringBuffer, this.getDayOfMonth(), 2);
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
    }
}

