/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import org.springframework.core.style.DefaultToStringStyler;
import org.springframework.core.style.StylerUtils;
import org.springframework.core.style.ToStringStyler;
import org.springframework.core.style.ValueStyler;
import org.springframework.util.Assert;

public class ToStringCreator {
    private static final ToStringStyler DEFAULT_TO_STRING_STYLER = new DefaultToStringStyler(StylerUtils.DEFAULT_VALUE_STYLER);
    private StringBuffer buffer = new StringBuffer(512);
    private ToStringStyler styler;
    private Object object;
    private boolean styledFirstField;

    public ToStringCreator(Object object) {
        this(object, (ToStringStyler)null);
    }

    public ToStringCreator(Object object, ValueStyler valueStyler) {
        this(object, new DefaultToStringStyler(valueStyler != null ? valueStyler : StylerUtils.DEFAULT_VALUE_STYLER));
    }

    public ToStringCreator(Object object, ToStringStyler toStringStyler) {
        Assert.notNull(object, "The object to be styled must not be null");
        this.object = object;
        this.styler = toStringStyler != null ? toStringStyler : DEFAULT_TO_STRING_STYLER;
        this.styler.styleStart(this.buffer, this.object);
    }

    public ToStringCreator append(String string, byte by) {
        return this.append(string, new Byte(by));
    }

    public ToStringCreator append(String string, short s) {
        return this.append(string, new Short(s));
    }

    public ToStringCreator append(String string, int n) {
        return this.append(string, new Integer(n));
    }

    public ToStringCreator append(String string, float f) {
        return this.append(string, new Float(f));
    }

    public ToStringCreator append(String string, double d) {
        return this.append(string, new Double(d));
    }

    public ToStringCreator append(String string, long l) {
        return this.append(string, new Long(l));
    }

    public ToStringCreator append(String string, boolean bl) {
        return this.append(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public ToStringCreator append(String string, Object object) {
        this.printFieldSeparatorIfNecessary();
        this.styler.styleField(this.buffer, string, object);
        return this;
    }

    private void printFieldSeparatorIfNecessary() {
        if (this.styledFirstField) {
            this.styler.styleFieldSeparator(this.buffer);
        } else {
            this.styledFirstField = true;
        }
    }

    public ToStringCreator append(Object object) {
        this.styler.styleValue(this.buffer, object);
        return this;
    }

    public String toString() {
        this.styler.styleEnd(this.buffer, this.object);
        return this.buffer.toString();
    }
}

