/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.AlgorithmAlreadyRegisteredException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.ClassLoaderUtils;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformBase64Decode;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14N;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14N11;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14N11_WithComments;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14NExclusive;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14NExclusiveWithComments;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformC14NWithComments;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformEnvelopedSignature;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformXPath;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformXPath2Filter;
import com.sun.org.apache.xml.internal.security.transforms.implementations.TransformXSLT;
import com.sun.org.apache.xml.internal.security.utils.HelperNodeList;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    private static Logger log = Logger.getLogger(Transform.class.getName());
    private static Map<String, Class<? extends TransformSpi>> transformSpiHash = new ConcurrentHashMap<String, Class<? extends TransformSpi>>();
    private final TransformSpi transformSpi;

    public Transform(Document document, String string) throws InvalidTransformException {
        this(document, string, (NodeList)null);
    }

    public Transform(Document document, String string, Element element) throws InvalidTransformException {
        super(document);
        HelperNodeList helperNodeList = null;
        if (element != null) {
            helperNodeList = new HelperNodeList();
            XMLUtils.addReturnToElement(document, helperNodeList);
            helperNodeList.appendChild(element);
            XMLUtils.addReturnToElement(document, helperNodeList);
        }
        this.transformSpi = this.initializeTransform(string, helperNodeList);
    }

    public Transform(Document document, String string, NodeList nodeList) throws InvalidTransformException {
        super(document);
        this.transformSpi = this.initializeTransform(string, nodeList);
    }

    public Transform(Element element, String string) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        String string2 = element.getAttributeNS(null, "Algorithm");
        if (string2 == null || string2.length() == 0) {
            Object[] objectArray = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
        Class<? extends TransformSpi> clazz = transformSpiHash.get(string2);
        if (clazz == null) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        try {
            this.transformSpi = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string2};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, illegalAccessException);
        }
    }

    public static void register(String string, String string2) throws AlgorithmAlreadyRegisteredException, ClassNotFoundException, InvalidTransformException {
        JavaUtils.checkRegisterPermission();
        Class<? extends TransformSpi> clazz = transformSpiHash.get(string);
        if (clazz != null) {
            Object[] objectArray = new Object[]{string, clazz};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        Class<?> clazz2 = ClassLoaderUtils.loadClass(string2, Transform.class);
        transformSpiHash.put(string, clazz2);
    }

    public static void register(String string, Class<? extends TransformSpi> clazz) throws AlgorithmAlreadyRegisteredException {
        JavaUtils.checkRegisterPermission();
        Class<? extends TransformSpi> clazz2 = transformSpiHash.get(string);
        if (clazz2 != null) {
            Object[] objectArray = new Object[]{string, clazz2};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        transformSpiHash.put(string, clazz);
    }

    public static void registerDefaultAlgorithms() {
        transformSpiHash.put("http://www.w3.org/2000/09/xmldsig#base64", TransformBase64Decode.class);
        transformSpiHash.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", TransformC14N.class);
        transformSpiHash.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", TransformC14NWithComments.class);
        transformSpiHash.put("http://www.w3.org/2006/12/xml-c14n11", TransformC14N11.class);
        transformSpiHash.put("http://www.w3.org/2006/12/xml-c14n11#WithComments", TransformC14N11_WithComments.class);
        transformSpiHash.put("http://www.w3.org/2001/10/xml-exc-c14n#", TransformC14NExclusive.class);
        transformSpiHash.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", TransformC14NExclusiveWithComments.class);
        transformSpiHash.put("http://www.w3.org/TR/1999/REC-xpath-19991116", TransformXPath.class);
        transformSpiHash.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", TransformEnvelopedSignature.class);
        transformSpiHash.put("http://www.w3.org/TR/1999/REC-xslt-19991116", TransformXSLT.class);
        transformSpiHash.put("http://www.w3.org/2002/06/xmldsig-filter2", TransformXPath2Filter.class);
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        return this.performTransform(xMLSignatureInput, null);
    }

    public XMLSignatureInput performTransform(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput xMLSignatureInput2 = null;
        try {
            xMLSignatureInput2 = this.transformSpi.enginePerformTransform(xMLSignatureInput, outputStream, this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Object[] objectArray = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Object[] objectArray = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", objectArray, sAXException);
        }
        return xMLSignatureInput2;
    }

    @Override
    public String getBaseLocalName() {
        return "Transform";
    }

    private TransformSpi initializeTransform(String string, NodeList nodeList) throws InvalidTransformException {
        this._constructionElement.setAttributeNS(null, "Algorithm", string);
        Class<? extends TransformSpi> clazz = transformSpiHash.get(string);
        if (clazz == null) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray);
        }
        TransformSpi transformSpi = null;
        try {
            transformSpi = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Object[] objectArray = new Object[]{string};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", objectArray, illegalAccessException);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create URI \"" + string + "\" class \"" + transformSpi.getClass() + "\"");
            log.log(Level.FINE, "The NodeList is " + nodeList);
        }
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this._constructionElement.appendChild(nodeList.item(i).cloneNode(true));
            }
        }
        return transformSpi;
    }
}

