/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import sun.awt.UNIXToolkit;
import sun.awt.X11.OwnershipListener;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XDataTransferer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XSelection;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.SunClipboard;
import sun.security.action.GetIntegerAction;

public final class XClipboard
extends SunClipboard
implements OwnershipListener {
    private final XSelection selection;
    private long convertSelectionTime;
    private volatile boolean isSelectionNotifyProcessed;
    private volatile XAtom targetsPropertyAtom;
    private static final Object classLock = new Object();
    private static final int defaultPollInterval = 200;
    private static int pollInterval;
    private static Map<Long, XClipboard> targetsAtom2Clipboard;

    public XClipboard(String string, String string2) {
        super(string);
        this.selection = new XSelection(XAtom.get(string2));
        this.selection.registerOwershipListener(this);
    }

    @Override
    public void ownershipChanged(boolean bl) {
        if (bl) {
            this.checkChangeHere(this.contents);
        } else {
            this.lostOwnershipImpl();
        }
    }

    @Override
    protected synchronized void setContentsNative(Transferable transferable) {
        long[] lArray;
        SortedMap sortedMap = DataTransferer.getInstance().getFormatsForTransferable(transferable, DataTransferer.adaptFlavorMap(XClipboard.getDefaultFlavorTable()));
        if (!this.selection.setOwner(transferable, sortedMap, lArray = DataTransferer.keysToLongArray(sortedMap), XToolkit.getCurrentServerTime())) {
            this.owner = null;
            this.contents = null;
        }
    }

    @Override
    public long getID() {
        return this.selection.getSelectionAtom().getAtom();
    }

    @Override
    public synchronized Transferable getContents(Object object) {
        if (this.contents != null) {
            return this.contents;
        }
        return new ClipboardTransferable(this);
    }

    @Override
    protected void clearNativeContext() {
        this.selection.reset();
    }

    @Override
    protected long[] getClipboardFormats() {
        return this.selection.getTargets(XToolkit.getCurrentServerTime());
    }

    @Override
    protected byte[] getClipboardData(long l) throws IOException {
        return this.selection.getData(l, XToolkit.getCurrentServerTime());
    }

    private void checkChangeHere(Transferable transferable) {
        if (this.areFlavorListenersRegistered()) {
            this.checkChange(DataTransferer.getInstance().getFormatsForTransferableAsArray(transferable, XClipboard.getDefaultFlavorTable()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPollInterval() {
        Object object = classLock;
        synchronized (object) {
            if (pollInterval <= 0 && (pollInterval = AccessController.doPrivileged(new GetIntegerAction("awt.datatransfer.clipboard.poll.interval", 200)).intValue()) <= 0) {
                pollInterval = 200;
            }
            return pollInterval;
        }
    }

    private XAtom getTargetsPropertyAtom() {
        if (null == this.targetsPropertyAtom) {
            this.targetsPropertyAtom = XAtom.get("XAWT_TARGETS_OF_SELECTION:" + this.selection.getSelectionAtom().getName());
        }
        return this.targetsPropertyAtom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerClipboardViewerChecked() {
        this.isSelectionNotifyProcessed = true;
        boolean bl = false;
        Object object = classLock;
        synchronized (object) {
            if (targetsAtom2Clipboard == null) {
                targetsAtom2Clipboard = new HashMap<Long, XClipboard>(2);
            }
            bl = targetsAtom2Clipboard.isEmpty();
            targetsAtom2Clipboard.put(this.getTargetsPropertyAtom().getAtom(), this);
            if (bl) {
                XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), new SelectionNotifyHandler());
            }
        }
        if (bl) {
            XToolkit.schedule(new CheckChangeTimerTask(), XClipboard.getPollInterval());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregisterClipboardViewerChecked() {
        this.isSelectionNotifyProcessed = false;
        Object object = classLock;
        synchronized (object) {
            targetsAtom2Clipboard.remove(this.getTargetsPropertyAtom().getAtom());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTargetsDelayed() {
        XToolkit.awtLock();
        try {
            long l = System.currentTimeMillis();
            if (this.isSelectionNotifyProcessed || l >= this.convertSelectionTime + (long)UNIXToolkit.getDatatransferTimeout()) {
                this.convertSelectionTime = l;
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.selection.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), this.getTargetsPropertyAtom().getAtom(), XWindow.getXAWTRootWindow().getWindow(), 0L);
                this.isSelectionNotifyProcessed = false;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChange(XSelectionEvent xSelectionEvent) {
        long l = xSelectionEvent.get_property();
        if (l != this.getTargetsPropertyAtom().getAtom()) {
            return;
        }
        XAtom xAtom = XAtom.get(xSelectionEvent.get_selection());
        XSelection xSelection = XSelection.getSelection(xAtom);
        if (null == xSelection || xSelection != this.selection) {
            return;
        }
        this.isSelectionNotifyProcessed = true;
        if (this.selection.isOwner()) {
            return;
        }
        long[] lArray = null;
        if (l == 0L) {
            lArray = new long[]{};
        } else {
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), XAtom.get(l), 0L, 1000000L, true, 0L);
            try {
                windowPropertyGetter.execute();
                lArray = XSelection.getFormats(windowPropertyGetter);
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
        this.checkChange(lArray);
    }

    private static class CheckChangeTimerTask
    implements Runnable {
        private CheckChangeTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (XClipboard xClipboard : targetsAtom2Clipboard.values()) {
                xClipboard.getTargetsDelayed();
            }
            Object object = classLock;
            synchronized (object) {
                if (targetsAtom2Clipboard != null && !targetsAtom2Clipboard.isEmpty()) {
                    XToolkit.schedule(this, XClipboard.getPollInterval());
                }
            }
        }
    }

    private static class SelectionNotifyHandler
    implements XEventDispatcher {
        private SelectionNotifyHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchEvent(XEvent xEvent) {
            if (xEvent.get_type() == 31) {
                XSelectionEvent xSelectionEvent = xEvent.get_xselection();
                XClipboard xClipboard = null;
                Object object = classLock;
                synchronized (object) {
                    if (targetsAtom2Clipboard != null && !targetsAtom2Clipboard.isEmpty()) {
                        XToolkit.removeEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), this);
                        return;
                    }
                    long l = xSelectionEvent.get_property();
                    xClipboard = (XClipboard)targetsAtom2Clipboard.get(l);
                }
                if (null != xClipboard) {
                    xClipboard.checkChange(xSelectionEvent);
                }
            }
        }
    }
}

