/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.comusbprocessor.ParallSubProcessor;
import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P18;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.Clock;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.PageUtils;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.MainJFrame;
import cn.com.voltronic.solar.view.QueryParameterThread;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.LayoutStyle;

public class ParameterJDialogP18
extends AADialog {
    private static final long serialVersionUID = 3827137705369649804L;
    private AAButton cancelButton;
    private JPanel centerPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel lastPanel;
    private JPanel jPanel3;
    private JPanel jPanel31;
    private JPanel jPanel32;
    private JPanel jPanel33;
    private AALabel dateLabel;
    private JLabel dateLabelPanel;
    private JTextField dateTextField;
    private AAButton setDateButton;
    private JTextField timeTextField;
    private JLabel warningLabelC;
    private AALabel warningLabelV;
    private Clock clock = null;
    public ConfigData configData = null;
    public Capability cappbility = null;
    private AbstractProcessor processor = null;
    private IProtocol protocol = null;
    private Point offset = new Point();
    private JWindow window = new JWindow();

    public ParameterJDialogP18(Frame parent, boolean modal) {
        super(parent, modal);
        this.doDrag();
        this.configData = new ConfigData();
        this.cappbility = new Capability();
        this.protocol = new P18();
        try {
            this.processor = GlobalProcessors.getCurrentProcessor();
            if (this.processor != null) {
                this.protocol = this.processor.getProtocol();
                this.configData = (ConfigData)this.processor.getBeanBag().getBean("configdata");
                this.cappbility = (Capability)this.processor.getBeanBag().getBean("capability");
                if (this.processor instanceof ParallSubProcessor) {
                    this.configData.setCurrentKey(this.processor.getSerialNo());
                } else {
                    this.configData.setCurrentKey("SELF");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.protocol == null) {
            this.protocol = new P18();
        }
        this.initComponents();
        this.setTitle("message.parametersSetting");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.centerPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel31 = new JPanel();
        this.jPanel32 = new JPanel();
        this.jPanel33 = new JPanel();
        this.lastPanel = new JPanel();
        this.cancelButton = new AAButton();
        this.warningLabelV = new AALabel();
        this.warningLabelC = new JLabel();
        this.dateLabel = new AALabel();
        this.dateTextField = new JTextField();
        this.timeTextField = new JTextField();
        this.setDateButton = new AAButton();
        this.dateLabelPanel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ParameterJDialogP18.this.closeWindows();
            }
        });
        this.centerPanel.setBorder(BorderFactory.createEtchedBorder());
        this.centerPanel.setLayout(new BorderLayout());
        this.setJPanel1Layout();
        this.centerPanel.add((Component)this.jPanel1, "First");
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.setJPanel2Layout();
        this.centerPanel.add((Component)this.jPanel2, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel32.setBorder(BorderFactory.createEtchedBorder());
        this.setJPanel31Layout();
        this.setJPanel32Layout();
        this.setJPanel33Layout();
        this.jPanel3.add((Component)this.jPanel31, "First");
        this.jPanel3.add((Component)this.jPanel32, "Center");
        this.jPanel3.add((Component)this.jPanel33, "Last");
        this.centerPanel.add((Component)this.jPanel3, "Last");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.lastPanel.setBorder(BorderFactory.createEtchedBorder());
        this.cancelButton.setText("message.close");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterJDialogP18.this.closeWindows();
            }
        });
        this.warningLabelC.setIcon(new ImageIcon(Constants.WARNINGLIGHTIMG));
        this.warningLabelV.setText("message.noteMsgToUser");
        this.dateLabel.setText("message.machineTime[:]");
        this.dateTextField.setEditable(false);
        this.dateTextField.setBackground(I18NListener.bgColor);
        this.dateTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(ParameterJDialogP18.this.dateTextField);
                calendarPanel.setBounds(ParameterJDialogP18.this.getX() + ParameterJDialogP18.this.dateLabelPanel.getX() + 30, ParameterJDialogP18.this.getY() + ParameterJDialogP18.this.dateLabelPanel.getY() + 350, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.dateLabelPanel.setIcon(new ImageIcon(Constants.DATE));
        this.dateLabelPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(ParameterJDialogP18.this.dateTextField);
                calendarPanel.setBounds(ParameterJDialogP18.this.getX() + ParameterJDialogP18.this.dateLabelPanel.getX() + 30, ParameterJDialogP18.this.getY() + ParameterJDialogP18.this.dateLabelPanel.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.timeTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ParameterJDialogP18.this.clock != null) {
                    ParameterJDialogP18.this.clock.setGo(false);
                }
            }
        });
        this.setDateButton.setText("message.apply");
        this.setDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                ParameterJDialogP18.this.setTime();
            }
        });
        GroupLayout lastPanelLayout = new GroupLayout(this.lastPanel);
        this.lastPanel.setLayout(lastPanelLayout);
        lastPanelLayout.setHorizontalGroup(lastPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, lastPanelLayout.createSequentialGroup().addContainerGap(613, Short.MAX_VALUE).addComponent(this.cancelButton).addContainerGap()));
        lastPanelLayout.setVerticalGroup(lastPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(lastPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.cancelButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.lastPanel, "Last");
        this.getTime(false);
        this.pack();
    }

    public synchronized void closeWindows() {
        if (this.clock != null) {
            this.clock.setGo(false);
        }
        QueryParameterThread thread = new QueryParameterThread();
        thread.setPriority(10);
        thread.start();
        this.dispose();
    }

    private void setJPanel1Layout() {
        List<AutoRadioItem> list = this.protocol.getRadioParameter().getRadioParameterList();
        PageUtils.setRadioLayout(list, this.jPanel1, this);
    }

    private void setJPanel2Layout() {
        List<AutoComboBoxItem> list = this.protocol.getComboBoxParameter().getComboBoxParameterList();
        PageUtils.setComboBoxLayout(list, this.jPanel2, this, this.protocol.getCommandMap());
    }

    private void setJPanel31Layout() {
        List<AutoSpinnerItem> list = this.protocol.getSpinnerParameter().getSpinnerParameterList();
        PageUtils.setSpinnerLayout(list, this.jPanel31, this, this.protocol.getCommandMap(), this.protocol.getRelationList(), false, false);
    }

    private void setJPanel32Layout() {
        PageUtils.setTimeLayout(null, this.jPanel32);
    }

    private void setJPanel33Layout() {
        GroupLayout jPanel33Laout = new GroupLayout(this.jPanel33);
        this.jPanel33.setLayout(jPanel33Laout);
        jPanel33Laout.setHorizontalGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel33Laout.createSequentialGroup().addGap(36, 36, 36).addGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.dateLabel, GroupLayout.Alignment.TRAILING).addComponent(this.warningLabelC, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel33Laout.createSequentialGroup().addGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.timeTextField).addComponent(this.dateTextField, -2, 126, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.setDateButton).addComponent(this.dateLabelPanel))).addComponent(this.warningLabelV, -1, 578, Short.MAX_VALUE))));
        jPanel33Laout.setVerticalGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel33Laout.createSequentialGroup().addContainerGap().addGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.warningLabelV).addComponent(this.warningLabelC)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.dateLabelPanel).addComponent(this.dateTextField, -2, -1, -2).addComponent(this.dateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel33Laout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.setDateButton).addComponent(this.timeTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void setTime() {
        int re;
        if (this.processor == null) {
            this.processor = GlobalProcessors.getCurrentProcessor();
        }
        if (this.processor != null && (re = DisplayMessage.showConfirmDialog("message.noteMsgToUser", "message.confirm")) == 0) {
            boolean result = false;
            String source = this.dateTextField.getText().trim();
            String timeStr = this.timeTextField.getText().trim();
            if ("".equals(source) || "".equals(timeStr)) {
                result = false;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
            Calendar calendar = Calendar.getInstance();
            try {
                Date date = sdf.parse(source);
                calendar.setTime(date);
            }
            catch (ParseException e1) {
                e1.printStackTrace();
            }
            String year = ("" + calendar.get(1)).substring(2);
            int mon = calendar.get(2) + 1;
            String month = "";
            month = mon < 10 ? "0" + mon : "" + mon;
            String day = "";
            int da = calendar.get(5);
            day = da < 10 ? "0" + da : "" + da;
            String time = "";
            String[] timeArr = timeStr.split(":");
            int i = 0;
            while (i < timeArr.length) {
                if (timeArr[i].length() < 2) {
                    timeArr[i] = "0" + timeArr[i];
                }
                time = String.valueOf(time) + timeArr[i];
                ++i;
            }
            if (source.length() == 10 && time.length() == 6) {
                StringBuffer parameter = new StringBuffer();
                parameter.append(year).append(month).append(day).append(time);
                try {
                    if (this.processor != null) {
                        result = this.processor.executeControl("setCurrentTime", new String[]{parameter.toString()});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                result = false;
            }
            if (result) {
                DisplayMessage.showInfoDialog("message.setTrue");
                this.getTime(true);
                if (this.processor != null) {
                    this.processor.setCurrentTime(this.processor.getCurrentTime());
                }
                MainJFrame.getNewInstance().refreshClock();
            } else {
                DisplayMessage.showErrorDialog("message.setFalse");
            }
        }
    }

    private void getTime(boolean isQuery) {
        Date date = new Date();
        if (this.processor != null) {
            Calendar ca = Calendar.getInstance();
            ca = isQuery ? this.processor.queryCurrentTime() : this.processor.getCurrentTime();
            if (ca != null) {
                date = ca.getTime();
            }
            this.dateTextField.setText(DateUtils.getFormatDate(date));
            this.clock = new Clock(date, this.timeTextField);
            this.clock.setGo(true);
            this.clock.start();
        } else {
            this.dateTextField.setText(DateUtils.getFormatDate(date));
            this.timeTextField.setText("");
        }
    }

    private void doDrag() {
        this.window.setVisible(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ((ParameterJDialogP18)ParameterJDialogP18.this).offset.x = e.getXOnScreen();
                ((ParameterJDialogP18)ParameterJDialogP18.this).offset.y = e.getYOnScreen();
                ParameterJDialogP18.this.setBounds(ParameterJDialogP18.this.getX(), ParameterJDialogP18.this.getY(), ParameterJDialogP18.this.getWidth(), ParameterJDialogP18.this.getHeight());
                ParameterJDialogP18.this.window.setBounds(ParameterJDialogP18.this.getX(), ParameterJDialogP18.this.getY(), ParameterJDialogP18.this.getWidth(), ParameterJDialogP18.this.getHeight());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ParameterJDialogP18.this.setLocation(ParameterJDialogP18.this.window.getX(), ParameterJDialogP18.this.window.getY());
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = ParameterJDialogP18.this.window.getX() + e.getXOnScreen() - ((ParameterJDialogP18)ParameterJDialogP18.this).offset.x;
                int y = ParameterJDialogP18.this.window.getY() + e.getYOnScreen() - ((ParameterJDialogP18)ParameterJDialogP18.this).offset.y;
                ParameterJDialogP18.this.window.setLocation(x, y);
                ParameterJDialogP18.this.setLocation(x, y);
                ((ParameterJDialogP18)ParameterJDialogP18.this).offset.x = e.getXOnScreen();
                ((ParameterJDialogP18)ParameterJDialogP18.this).offset.y = e.getYOnScreen();
            }
        });
    }
}

