/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.config;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertyGetter;

public class PropertyPrinter
implements PropertyGetter.PropertyCallback {
    protected int numAppenders = 0;
    protected Hashtable appenderNames = new Hashtable();
    protected Hashtable layoutNames = new Hashtable();
    protected PrintWriter out;
    protected boolean doCapitalize;

    public PropertyPrinter(PrintWriter printWriter) {
        this(printWriter, false);
    }

    public PropertyPrinter(PrintWriter printWriter, boolean bl) {
        this.out = printWriter;
        this.doCapitalize = bl;
        this.print(printWriter);
        printWriter.flush();
    }

    protected String genAppName() {
        return "A" + this.numAppenders++;
    }

    protected boolean isGenAppName(String string) {
        if (string.length() < 2 || string.charAt(0) != 'A') {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) < '0' || string.charAt(n) > '9') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void print(PrintWriter printWriter) {
        this.printOptions(printWriter, Logger.getRootLogger());
        Enumeration enumeration = LogManager.getCurrentLoggers();
        while (enumeration.hasMoreElements()) {
            this.printOptions(printWriter, (Logger)enumeration.nextElement());
        }
    }

    protected void printOptions(PrintWriter printWriter, Logger logger) {
        Object object;
        Enumeration enumeration = logger.getAllAppenders();
        Level level = logger.getLevel();
        String string = level == null ? "" : level.toString();
        while (enumeration.hasMoreElements()) {
            object = (Appender)enumeration.nextElement();
            String string2 = (String)this.appenderNames.get(object);
            if (string2 == null) {
                string2 = object.getName();
                if (string2 == null || this.isGenAppName(string2)) {
                    string2 = this.genAppName();
                }
                this.appenderNames.put(object, string2);
                this.printOptions(printWriter, object, "log4j.appender." + string2);
                if (object.getLayout() != null) {
                    this.printOptions(printWriter, object.getLayout(), "log4j.appender." + string2 + ".layout");
                }
            }
            string = string + ", " + string2;
        }
        Object object2 = object = logger == Logger.getRootLogger() ? "log4j.rootLogger" : "log4j.logger." + logger.getName();
        if (string != "") {
            printWriter.println((String)object + "=" + string);
        }
        if (!logger.getAdditivity() && logger != Logger.getRootLogger()) {
            printWriter.println("log4j.additivity." + logger.getName() + "=false");
        }
    }

    protected void printOptions(PrintWriter printWriter, Object object, String string) {
        printWriter.println(string + "=" + object.getClass().getName());
        PropertyGetter.getProperties(object, this, string + ".");
    }

    public void foundProperty(Object object, String string, String string2, Object object2) {
        if (object instanceof Appender && "name".equals(string2)) {
            return;
        }
        if (this.doCapitalize) {
            string2 = PropertyPrinter.capitalize(string2);
        }
        this.out.println(string + string2 + "=" + object2.toString());
    }

    public static String capitalize(String string) {
        if (Character.isLowerCase(string.charAt(0)) && (string.length() == 1 || Character.isLowerCase(string.charAt(1)))) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.setCharAt(0, Character.toUpperCase(string.charAt(0)));
            return stringBuffer.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) {
        new PropertyPrinter(new PrintWriter(System.out));
    }
}

