/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;
import org.springframework.core.Constants;

public class PropertyPlaceholderConfigurer
extends PropertyResourceConfigurer
implements BeanNameAware,
BeanFactoryAware {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    public static final int SYSTEM_PROPERTIES_MODE_NEVER = 0;
    public static final int SYSTEM_PROPERTIES_MODE_FALLBACK = 1;
    public static final int SYSTEM_PROPERTIES_MODE_OVERRIDE = 2;
    private static final Constants constants = new Constants(class$org$springframework$beans$factory$config$PropertyPlaceholderConfigurer == null ? (class$org$springframework$beans$factory$config$PropertyPlaceholderConfigurer = PropertyPlaceholderConfigurer.class$("org.springframework.beans.factory.config.PropertyPlaceholderConfigurer")) : class$org$springframework$beans$factory$config$PropertyPlaceholderConfigurer);
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private int systemPropertiesMode = 1;
    private boolean searchSystemEnvironment = true;
    private boolean ignoreUnresolvablePlaceholders = false;
    private String beanName;
    private BeanFactory beanFactory;
    static /* synthetic */ Class class$org$springframework$beans$factory$config$PropertyPlaceholderConfigurer;

    public void setPlaceholderPrefix(String string) {
        this.placeholderPrefix = string;
    }

    public void setPlaceholderSuffix(String string) {
        this.placeholderSuffix = string;
    }

    public void setSystemPropertiesModeName(String string) throws IllegalArgumentException {
        this.systemPropertiesMode = constants.asNumber(string).intValue();
    }

    public void setSystemPropertiesMode(int n) {
        this.systemPropertiesMode = n;
    }

    public void setSearchSystemEnvironment(boolean bl) {
        this.searchSystemEnvironment = bl;
    }

    public void setIgnoreUnresolvablePlaceholders(boolean bl) {
        this.ignoreUnresolvablePlaceholders = bl;
    }

    public void setBeanName(String string) {
        this.beanName = string;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected void processProperties(ConfigurableListableBeanFactory configurableListableBeanFactory, Properties properties) throws BeansException {
        PlaceholderResolvingBeanDefinitionVisitor placeholderResolvingBeanDefinitionVisitor = new PlaceholderResolvingBeanDefinitionVisitor(properties);
        String[] stringArray = configurableListableBeanFactory.getBeanDefinitionNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(this.beanName) && configurableListableBeanFactory.equals(this.beanFactory)) continue;
            BeanDefinition beanDefinition = configurableListableBeanFactory.getBeanDefinition(stringArray[i]);
            try {
                placeholderResolvingBeanDefinitionVisitor.visitBeanDefinition(beanDefinition);
                continue;
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {
                throw new BeanDefinitionStoreException(beanDefinition.getResourceDescription(), stringArray[i], beanDefinitionStoreException.getMessage());
            }
        }
    }

    protected String parseStringValue(String string, Properties properties, Set set) throws BeanDefinitionStoreException {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.indexOf(this.placeholderPrefix);
        while (n != -1) {
            int n2 = stringBuffer.toString().indexOf(this.placeholderSuffix, n + this.placeholderPrefix.length());
            if (n2 != -1) {
                String string2 = stringBuffer.substring(n + this.placeholderPrefix.length(), n2);
                if (!set.add(string2)) {
                    throw new BeanDefinitionStoreException("Circular placeholder reference '" + string2 + "' in property definitions");
                }
                String string3 = this.resolvePlaceholder(string2, properties, this.systemPropertiesMode);
                if (string3 != null) {
                    string3 = this.parseStringValue(string3, properties, set);
                    stringBuffer.replace(n, n2 + this.placeholderSuffix.length(), string3);
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("Resolved placeholder '" + string2 + "'"));
                    }
                    n = stringBuffer.toString().indexOf(this.placeholderPrefix, n + string3.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    n = stringBuffer.toString().indexOf(this.placeholderPrefix, n2 + this.placeholderSuffix.length());
                } else {
                    throw new BeanDefinitionStoreException("Could not resolve placeholder '" + string2 + "'");
                }
                set.remove(string2);
                continue;
            }
            n = -1;
        }
        return stringBuffer.toString();
    }

    protected String resolvePlaceholder(String string, Properties properties, int n) {
        String string2 = null;
        if (n == 2) {
            string2 = this.resolveSystemProperty(string);
        }
        if (string2 == null) {
            string2 = this.resolvePlaceholder(string, properties);
        }
        if (string2 == null && n == 1) {
            string2 = this.resolveSystemProperty(string);
        }
        return string2;
    }

    protected String resolvePlaceholder(String string, Properties properties) {
        return properties.getProperty(string);
    }

    protected String resolveSystemProperty(String string) {
        try {
            String string2 = System.getProperty(string);
            if (string2 == null && this.searchSystemEnvironment) {
                string2 = System.getenv(string);
            }
            return string2;
        }
        catch (Throwable throwable) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could not access system property '" + string + "': " + throwable));
            }
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PlaceholderResolvingBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        private final Properties props;

        public PlaceholderResolvingBeanDefinitionVisitor(Properties properties) {
            this.props = properties;
        }

        protected String resolveStringValue(String string) throws BeansException {
            return PropertyPlaceholderConfigurer.this.parseStringValue(string, this.props, new HashSet());
        }
    }
}

