/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.PresetFile;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

@Deprecated
final class JFCParser {
    public static final String FILE_EXTENSION = ".jfc";

    JFCParser() {
    }

    public static boolean hasValidFileExtension(File file) {
        return file.getAbsolutePath().toLowerCase().endsWith(FILE_EXTENSION);
    }

    public static EventDefaultSet createEventDefaultSet(String string) throws IOException, ParseException {
        return JFCParser.createPresetFile(string).getSettings();
    }

    public static PresetFile createPresetFile(File file) throws IOException, ParseException {
        return JFCParser.createPresetFile(PresetFile.readContent(file));
    }

    public static PresetFile createPresetFile(String string) throws IOException, ParseException {
        try {
            JFCParser.validateXML(string);
            ConfigurationHandler configurationHandler = new ConfigurationHandler();
            JFCParser.parseXML(string, configurationHandler);
            EventDefaultSet eventDefaultSet = new EventDefaultSet(configurationHandler.eventDefaults);
            return new PresetFile(configurationHandler.configurationName, configurationHandler.configurationDescription, configurationHandler.configurationProvider, eventDefaultSet, string);
        }
        catch (SAXParseException sAXParseException) {
            throw new ParseException(sAXParseException.getMessage(), sAXParseException.getLineNumber());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), -1);
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new IOException("Error trying to read jfc-file.", exception);
        }
    }

    private static void parseXML(String string, ConfigurationHandler configurationHandler) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
        SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(charArrayReader), (DefaultHandler)configurationHandler);
    }

    private static void validateXML(String string) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        String string2 = "/" + JFCParser.class.getPackage().getName().replace(".", "/") + "/jfc.xsd";
        try (InputStream inputStream = PresetFile.class.getResourceAsStream(string2);){
            if (inputStream == null) {
                throw new IOException("Could not load schema resource for validating jfc-file from " + string2);
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            sAXParserFactory.setSchema(schemaFactory.newSchema(new Source[]{new StreamSource(inputStream)}));
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setErrorHandler(new RethrowErrorHandler());
            CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
            xMLReader.parse(new InputSource(charArrayReader));
        }
    }

    private static final class ConfigurationHandler
    extends DefaultHandler {
        private static final String ELEMENT_CONFIGURATION = "configuration";
        private static final String ELEMENT_PRODUCER = "producer";
        private static final String ELEMENT_EVENT_TYPE = "event";
        private static final String ELEMENT_SETTING = "setting";
        private static final String ATTRIBUTE_NAME = "name";
        private static final String ATTRIBUTE_URI = "uri";
        private static final String ATTRIBUTE_DESCRIPTION = "description";
        private static final String ATTRIBUTE_PATH = "path";
        private static final String ATTRIBUTE_PROVIDER = "provider";
        private final List<EventDefault> eventDefaults = new ArrayList<EventDefault>();
        private final Set<String> usedURIPaths = new HashSet<String>();
        private String configurationDescription;
        private String configurationName;
        private String configurationProvider;
        private URI currentProducerURI;
        private int currentEventId = 0;
        private String currentEventPath;
        private Map<String, String> currentSettings = new LinkedHashMap<String, String>();
        private String currentSettingsName;
        private StringBuilder currentCharacters;

        private ConfigurationHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (string3.toLowerCase()) {
                case "configuration": {
                    this.configurationName = attributes.getValue(ATTRIBUTE_NAME);
                    this.configurationDescription = this.getOptional(attributes, ATTRIBUTE_DESCRIPTION, "");
                    this.configurationProvider = this.getOptional(attributes, ATTRIBUTE_PROVIDER, "");
                    break;
                }
                case "producer": {
                    this.currentProducerURI = this.createURI(attributes.getValue(ATTRIBUTE_URI));
                    break;
                }
                case "event": {
                    this.currentSettings = new LinkedHashMap<String, String>();
                    this.currentEventPath = attributes.getValue(ATTRIBUTE_PATH);
                    break;
                }
                case "setting": {
                    this.currentSettingsName = attributes.getValue(ATTRIBUTE_NAME);
                }
            }
            this.currentCharacters = null;
        }

        private String getOptional(Attributes attributes, String string, String string2) {
            String string3 = attributes.getValue(string);
            return string3 == null ? string2 : string3;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentCharacters == null) {
                this.currentCharacters = new StringBuilder(n2);
            }
            this.currentCharacters.append(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            switch (string3.toLowerCase()) {
                case "configuration": {
                    break;
                }
                case "producer": {
                    this.currentProducerURI = null;
                    break;
                }
                case "event": {
                    this.addEventDefaults();
                    this.currentEventPath = null;
                    this.currentSettings = null;
                    break;
                }
                case "setting": {
                    String string4;
                    String string5 = string4 = this.currentCharacters == null ? "" : this.currentCharacters.toString();
                    if (this.currentSettings.containsKey(this.currentSettingsName)) {
                        throw new IllegalArgumentException("Setting '" + this.currentSettingsName + "'" + " already defined for event '" + this.currentProducerURI.toString() + this.currentEventPath + '\"');
                    }
                    this.currentSettings.put(this.currentSettingsName, string4);
                    this.currentSettingsName = null;
                }
            }
        }

        private void addEventDefaults() {
            String string = this.currentProducerURI.toString() + this.currentEventPath;
            if (!this.usedURIPaths.add(string)) {
                throw new IllegalArgumentException("'" + string + "' already used in jfc.");
            }
            URI uRI = this.createURI(string);
            try {
                this.eventDefaults.add(new EventDefault(uRI, new EventSetting(this.currentEventId, this.currentSettings)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Event setting for '" + string + "' is incorrect. " + illegalArgumentException.getMessage());
            }
        }

        private URI createURI(String string) throws IllegalArgumentException {
            try {
                if (EventDefault.containsWildcard(string)) {
                    throw new IllegalArgumentException(string + " contains wildcard. All settings must use resolved event URIs");
                }
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Not a valid URI " + string, uRISyntaxException);
            }
        }
    }

    private static final class RethrowErrorHandler
    implements ErrorHandler {
        private RethrowErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

