/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;
import sun.swing.SwingUtilities2;

public class SynthSliderUI
extends BasicSliderUI
implements PropertyChangeListener,
SynthUI {
    private Rectangle valueRect = new Rectangle();
    private boolean paintValue;
    private Dimension lastSize;
    private int trackHeight;
    private int trackBorder;
    private int thumbWidth;
    private int thumbHeight;
    private SynthStyle style;
    private SynthStyle sliderTrackStyle;
    private SynthStyle sliderThumbStyle;
    private transient boolean thumbActive;
    private transient boolean thumbPressed;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSliderUI((JSlider)jComponent);
    }

    protected SynthSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        this.updateStyle(jSlider);
    }

    @Override
    protected void uninstallDefaults(JSlider jSlider) {
        SynthContext synthContext = this.getContext((JComponent)jSlider, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(jSlider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.sliderTrackStyle = null;
        synthContext = this.getContext(jSlider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.sliderThumbStyle = null;
    }

    @Override
    protected void installListeners(JSlider jSlider) {
        super.installListeners(jSlider);
        jSlider.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSlider jSlider) {
        jSlider.removePropertyChangeListener(this);
        super.uninstallListeners(jSlider);
    }

    private void updateStyle(JSlider jSlider) {
        SynthContext synthContext = this.getContext((JComponent)jSlider, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.thumbWidth = this.style.getInt(synthContext, "Slider.thumbWidth", 30);
            this.thumbHeight = this.style.getInt(synthContext, "Slider.thumbHeight", 14);
            String string = (String)this.slider.getClientProperty("JComponent.sizeVariant");
            if (string != null) {
                if ("large".equals(string)) {
                    this.thumbWidth = (int)((double)this.thumbWidth * 1.15);
                    this.thumbHeight = (int)((double)this.thumbHeight * 1.15);
                } else if ("small".equals(string)) {
                    this.thumbWidth = (int)((double)this.thumbWidth * 0.857);
                    this.thumbHeight = (int)((double)this.thumbHeight * 0.857);
                } else if ("mini".equals(string)) {
                    this.thumbWidth = (int)((double)this.thumbWidth * 0.784);
                    this.thumbHeight = (int)((double)this.thumbHeight * 0.784);
                }
            }
            this.trackBorder = this.style.getInt(synthContext, "Slider.trackBorder", 1);
            this.trackHeight = this.thumbHeight + this.trackBorder * 2;
            this.paintValue = this.style.getBoolean(synthContext, "Slider.paintValue", true);
            if (synthStyle != null) {
                this.uninstallKeyboardActions(jSlider);
                this.installKeyboardActions(jSlider);
            }
        }
        synthContext.dispose();
        synthContext = this.getContext(jSlider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jSlider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new SynthTrackListener();
    }

    private void updateThumbState(int n, int n2) {
        this.setThumbActive(this.thumbRect.contains(n, n2));
    }

    private void updateThumbState(int n, int n2, boolean bl) {
        this.updateThumbState(n, n2);
        this.setThumbPressed(bl);
    }

    private void setThumbActive(boolean bl) {
        if (this.thumbActive != bl) {
            this.thumbActive = bl;
            this.slider.repaint(this.thumbRect);
        }
    }

    private void setThumbPressed(boolean bl) {
        if (this.thumbPressed != bl) {
            this.thumbPressed = bl;
            this.slider.repaint(this.thumbRect);
        }
    }

    @Override
    public int getBaseline(JComponent jComponent, int n, int n2) {
        if (jComponent == null) {
            throw new NullPointerException("Component must be non-null");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        if (this.slider.getPaintLabels() && this.labelsHaveSameBaselines()) {
            Integer n3;
            Insets insets = new Insets(0, 0, 0, 0);
            SynthContext synthContext = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
            this.style.getInsets(synthContext, insets);
            synthContext.dispose();
            if (this.slider.getOrientation() == 0) {
                int n4 = 0;
                if (this.paintValue) {
                    SynthContext synthContext2 = this.getContext(this.slider);
                    n4 = synthContext2.getStyle().getGraphicsUtils(synthContext2).getMaximumCharHeight(synthContext2);
                    synthContext2.dispose();
                }
                int n5 = 0;
                if (this.slider.getPaintTicks()) {
                    n5 = this.getTickLength();
                }
                int n6 = this.getHeightOfTallestLabel();
                int n7 = n4 + this.trackHeight + insets.top + insets.bottom + n5 + n6 + 4;
                int n8 = n2 / 2 - n7 / 2;
                n8 += n4 + 2;
                n8 += this.trackHeight + insets.top + insets.bottom;
                JComponent jComponent2 = (JComponent)this.slider.getLabelTable().elements().nextElement();
                Dimension dimension = jComponent2.getPreferredSize();
                return (n8 += n5 + 2) + jComponent2.getBaseline(dimension.width, dimension.height);
            }
            Integer n9 = n3 = this.slider.getInverted() ? this.getLowestValue() : this.getHighestValue();
            if (n3 != null) {
                int n10 = this.insetCache.top;
                int n11 = 0;
                if (this.paintValue) {
                    SynthContext synthContext3 = this.getContext(this.slider);
                    n11 = synthContext3.getStyle().getGraphicsUtils(synthContext3).getMaximumCharHeight(synthContext3);
                    synthContext3.dispose();
                }
                int n12 = n2 - this.insetCache.top - this.insetCache.bottom;
                int n13 = n10 + n11;
                int n14 = n12 - n11;
                int n15 = this.yPositionForValue(n3, n13, n14);
                JComponent jComponent3 = (JComponent)this.slider.getLabelTable().get(n3);
                Dimension dimension = jComponent3.getPreferredSize();
                return n15 - dimension.height / 2 + jComponent3.getBaseline(dimension.width, dimension.height);
            }
        }
        return -1;
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentRect.width, this.contentRect.height);
        if (this.slider.getOrientation() == 1) {
            dimension.height = 200;
        } else {
            dimension.width = 200;
        }
        Insets insets = this.slider.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentRect.width, this.contentRect.height);
        if (this.slider.getOrientation() == 1) {
            dimension.height = this.thumbRect.height + this.insetCache.top + this.insetCache.bottom;
        } else {
            dimension.width = this.thumbRect.width + this.insetCache.left + this.insetCache.right;
        }
        return dimension;
    }

    @Override
    protected void calculateGeometry() {
        this.calculateThumbSize();
        this.layout();
        this.calculateThumbLocation();
    }

    protected void layout() {
        SynthContext synthContext = this.getContext(this.slider);
        SynthGraphicsUtils synthGraphicsUtils = this.style.getGraphicsUtils(synthContext);
        Insets insets = new Insets(0, 0, 0, 0);
        SynthContext synthContext2 = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.style.getInsets(synthContext2, insets);
        synthContext2.dispose();
        if (this.slider.getOrientation() == 0) {
            int n;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphicsUtils.getMaximumCharHeight(synthContext);
            }
            this.trackRect.height = this.trackHeight;
            this.tickRect.height = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.height = this.getTickLength();
            }
            this.labelRect.height = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.height = this.getHeightOfTallestLabel();
            }
            this.contentRect.height = this.valueRect.height + this.trackRect.height + insets.top + insets.bottom + this.tickRect.height + this.labelRect.height + 4;
            this.contentRect.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
            int n2 = 0;
            if (this.slider.getPaintLabels()) {
                this.trackRect.x = this.insetCache.left;
                this.trackRect.width = this.contentRect.width;
                Dictionary dictionary = this.slider.getLabelTable();
                if (dictionary != null) {
                    int n3 = this.slider.getMinimum();
                    int n4 = this.slider.getMaximum();
                    int n5 = Integer.MAX_VALUE;
                    int n6 = Integer.MIN_VALUE;
                    Enumeration enumeration = dictionary.keys();
                    while (enumeration.hasMoreElements()) {
                        int n7 = (Integer)enumeration.nextElement();
                        if (n7 >= n3 && n7 < n5) {
                            n5 = n7;
                        }
                        if (n7 > n4 || n7 <= n6) continue;
                        n6 = n7;
                    }
                    n2 = this.getPadForLabel(n5);
                    n2 = Math.max(n2, this.getPadForLabel(n6));
                }
            }
            this.tickRect.x = this.labelRect.x = this.insetCache.left + n2;
            this.trackRect.x = this.labelRect.x;
            this.valueRect.x = this.labelRect.x;
            this.tickRect.width = this.labelRect.width = this.contentRect.width - n2 * 2;
            this.trackRect.width = this.labelRect.width;
            this.valueRect.width = this.labelRect.width;
            this.valueRect.y = n = this.slider.getHeight() / 2 - this.contentRect.height / 2;
            this.trackRect.y = (n += this.valueRect.height + 2) + insets.top;
            this.tickRect.y = n += this.trackRect.height + insets.top + insets.bottom;
            this.labelRect.y = n += this.tickRect.height + 2;
            n += this.labelRect.height;
        } else {
            this.trackRect.width = this.trackHeight;
            this.tickRect.width = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.width = this.getTickLength();
            }
            this.labelRect.width = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.width = this.getWidthOfWidestLabel();
            }
            this.valueRect.y = this.insetCache.top;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphicsUtils.getMaximumCharHeight(synthContext);
            }
            FontMetrics fontMetrics = this.slider.getFontMetrics(this.slider.getFont());
            this.valueRect.width = Math.max(synthGraphicsUtils.computeStringWidth(synthContext, this.slider.getFont(), fontMetrics, "" + this.slider.getMaximum()), synthGraphicsUtils.computeStringWidth(synthContext, this.slider.getFont(), fontMetrics, "" + this.slider.getMinimum()));
            int n = this.valueRect.width / 2;
            int n8 = insets.left + this.trackRect.width / 2;
            int n9 = this.trackRect.width / 2 + insets.right + this.tickRect.width + this.labelRect.width;
            this.contentRect.width = Math.max(n8, n) + Math.max(n9, n) + 2 + this.insetCache.left + this.insetCache.right;
            this.contentRect.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
            this.tickRect.y = this.labelRect.y = this.valueRect.y + this.valueRect.height;
            this.trackRect.y = this.labelRect.y;
            this.tickRect.height = this.labelRect.height = this.contentRect.height - this.valueRect.height;
            this.trackRect.height = this.labelRect.height;
            int n10 = this.slider.getWidth() / 2 - this.contentRect.width / 2;
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                if (n > n8) {
                    n10 += n - n8;
                }
                this.trackRect.x = n10 + insets.left;
                this.tickRect.x = n10 += insets.left + this.trackRect.width + insets.right;
                this.labelRect.x = n10 + this.tickRect.width + 2;
            } else {
                if (n > n9) {
                    n10 += n - n9;
                }
                this.labelRect.x = n10;
                this.tickRect.x = n10 += this.labelRect.width + 2;
                this.trackRect.x = n10 + this.tickRect.width + insets.left;
            }
        }
        synthContext.dispose();
        this.lastSize = this.slider.getSize();
    }

    private int getPadForLabel(int n) {
        int n2 = 0;
        JComponent jComponent = (JComponent)this.slider.getLabelTable().get(n);
        if (jComponent != null) {
            int n3;
            int n4 = this.xPositionForValue(n);
            if (n4 - (n3 = jComponent.getPreferredSize().width / 2) < this.insetCache.left) {
                n2 = Math.max(n2, this.insetCache.left - (n4 - n3));
            }
            if (n4 + n3 > this.slider.getWidth() - this.insetCache.right) {
                n2 = Math.max(n2, n4 + n3 - (this.slider.getWidth() - this.insetCache.right));
            }
        }
        return n2;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.y += this.trackBorder;
        } else {
            this.thumbRect.x += this.trackBorder;
        }
        Point point = this.slider.getMousePosition();
        if (point != null) {
            this.updateThumbState(point.x, point.y);
        }
    }

    @Override
    public void setThumbLocation(int n, int n2) {
        super.setThumbLocation(n, n2);
        this.slider.repaint(this.valueRect.x, this.valueRect.y, this.valueRect.width, this.valueRect.height);
        this.setThumbActive(false);
    }

    @Override
    protected int xPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.x + this.thumbRect.width / 2 + this.trackBorder;
        int n6 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.trackBorder;
        int n7 = n6 - n5;
        double d = (double)n4 - (double)n3;
        double d2 = (double)n7 / d;
        if (!this.drawInverted()) {
            n2 = n5;
            n2 = (int)((long)n2 + Math.round(d2 * ((double)n - (double)n3)));
        } else {
            n2 = n6;
            n2 = (int)((long)n2 - Math.round(d2 * ((double)n - (double)n3)));
        }
        n2 = Math.max(n5, n2);
        n2 = Math.min(n6, n2);
        return n2;
    }

    @Override
    protected int yPositionForValue(int n, int n2, int n3) {
        int n4;
        int n5 = this.slider.getMinimum();
        int n6 = this.slider.getMaximum();
        int n7 = n2 + this.thumbRect.height / 2 + this.trackBorder;
        int n8 = n2 + n3 - this.thumbRect.height / 2 - this.trackBorder;
        int n9 = n8 - n7;
        double d = (double)n6 - (double)n5;
        double d2 = (double)n9 / d;
        if (!this.drawInverted()) {
            n4 = n7;
            n4 = (int)((long)n4 + Math.round(d2 * ((double)n6 - (double)n)));
        } else {
            n4 = n7;
            n4 = (int)((long)n4 + Math.round(d2 * ((double)n - (double)n5)));
        }
        n4 = Math.max(n7, n4);
        n4 = Math.min(n8, n4);
        return n4;
    }

    @Override
    public int valueForYPosition(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.y + this.thumbRect.height / 2 + this.trackBorder;
        int n6 = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - this.trackBorder;
        int n7 = n6 - n5;
        if (n <= n5) {
            n2 = this.drawInverted() ? n3 : n4;
        } else if (n >= n6) {
            n2 = this.drawInverted() ? n4 : n3;
        } else {
            int n8 = n - n5;
            double d = (double)n4 - (double)n3;
            double d2 = d / (double)n7;
            int n9 = (int)Math.round((double)n8 * d2);
            n2 = this.drawInverted() ? n3 + n9 : n4 - n9;
        }
        return n2;
    }

    @Override
    public int valueForXPosition(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.x + this.thumbRect.width / 2 + this.trackBorder;
        int n6 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.trackBorder;
        int n7 = n6 - n5;
        if (n <= n5) {
            n2 = this.drawInverted() ? n4 : n3;
        } else if (n >= n6) {
            n2 = this.drawInverted() ? n3 : n4;
        } else {
            int n8 = n - n5;
            double d = (double)n4 - (double)n3;
            double d2 = d / (double)n7;
            int n9 = (int)Math.round((double)n8 * d2);
            n2 = this.drawInverted() ? n4 - n9 : n3 + n9;
        }
        return n2;
    }

    @Override
    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = this.thumbHeight;
            dimension.height = this.thumbWidth;
        } else {
            dimension.width = this.thumbWidth;
            dimension.height = this.thumbHeight;
        }
        return dimension;
    }

    @Override
    protected void recalculateIfInsetsChanged() {
        SynthContext synthContext = this.getContext(this.slider);
        Insets insets = this.style.getInsets(synthContext, null);
        Insets insets2 = this.slider.getInsets();
        insets.left += insets2.left;
        insets.right += insets2.right;
        insets.top += insets2.top;
        insets.bottom += insets2.bottom;
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
        synthContext.dispose();
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, SynthLookAndFeel.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n);
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        SynthStyle synthStyle = null;
        Class<SynthContext> clazz = SynthContext.class;
        if (region == Region.SLIDER_TRACK) {
            synthStyle = this.sliderTrackStyle;
        } else if (region == Region.SLIDER_THUMB) {
            synthStyle = this.sliderThumbStyle;
        }
        return SynthContext.getContext(clazz, jComponent, region, synthStyle, n);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        if (region == Region.SLIDER_THUMB && this.thumbActive && jComponent.isEnabled()) {
            int n;
            int n2 = n = this.thumbPressed ? 4 : 2;
            if (jComponent.isFocusOwner()) {
                n |= 0x100;
            }
            return n;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintSliderBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), this.slider.getOrientation());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        Object object;
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        if (this.lastSize == null || !this.lastSize.equals(this.slider.getSize())) {
            this.calculateGeometry();
        }
        if (this.paintValue) {
            object = SwingUtilities2.getFontMetrics((JComponent)this.slider, graphics);
            int n = synthContext.getStyle().getGraphicsUtils(synthContext).computeStringWidth(synthContext, graphics.getFont(), (FontMetrics)object, "" + this.slider.getValue());
            this.valueRect.x = this.thumbRect.x + (this.thumbRect.width - n) / 2;
            if (this.slider.getOrientation() == 0) {
                if (this.valueRect.x + n > this.insetCache.left + this.contentRect.width) {
                    this.valueRect.x = this.insetCache.left + this.contentRect.width - n;
                }
                this.valueRect.x = Math.max(this.valueRect.x, 0);
            }
            graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.TEXT_FOREGROUND));
            synthContext.getStyle().getGraphicsUtils(synthContext).paintText(synthContext, graphics, "" + this.slider.getValue(), this.valueRect.x, this.valueRect.y, -1);
        }
        if (this.slider.getPaintTrack() && rectangle.intersects(this.trackRect)) {
            object = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
            this.paintTrack((SynthContext)object, graphics, this.trackRect);
            ((SynthContext)object).dispose();
        }
        if (rectangle.intersects(this.thumbRect)) {
            object = this.getContext((JComponent)this.slider, Region.SLIDER_THUMB);
            this.paintThumb((SynthContext)object, graphics, this.thumbRect);
            ((SynthContext)object).dispose();
        }
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintSliderBorder(synthContext, graphics, n, n2, n3, n4, this.slider.getOrientation());
    }

    protected void paintThumb(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        int n = this.slider.getOrientation();
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintSliderThumbBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
        synthContext.getPainter().paintSliderThumbBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
    }

    protected void paintTrack(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        int n = this.slider.getOrientation();
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintSliderTrackBackground(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
        synthContext.getPainter().paintSliderTrackBorder(synthContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JSlider)propertyChangeEvent.getSource());
        }
    }

    private class SynthTrackListener
    extends BasicSliderUI.TrackListener {
        private SynthTrackListener() {
            super(SynthSliderUI.this);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            SynthSliderUI.this.setThumbActive(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            SynthSliderUI.this.setThumbPressed(SynthSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY()));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            SynthSliderUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY(), false);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SynthSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!SynthSliderUI.this.isDragging()) {
                return;
            }
            SynthSliderUI.this.slider.setValueIsAdjusting(true);
            switch (SynthSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int n = ((SynthSliderUI)SynthSliderUI.this).thumbRect.height / 2;
                    int n2 = mouseEvent.getY() - this.offset;
                    int n3 = ((SynthSliderUI)SynthSliderUI.this).trackRect.y;
                    int n4 = ((SynthSliderUI)SynthSliderUI.this).trackRect.y + ((SynthSliderUI)SynthSliderUI.this).trackRect.height - n - SynthSliderUI.this.trackBorder;
                    int n5 = SynthSliderUI.this.yPositionForValue(SynthSliderUI.this.slider.getMaximum() - SynthSliderUI.this.slider.getExtent());
                    if (SynthSliderUI.this.drawInverted()) {
                        n4 = n5;
                        n3 += n;
                    } else {
                        n3 = n5;
                    }
                    n2 = Math.max(n2, n3 - n);
                    n2 = Math.min(n2, n4 - n);
                    SynthSliderUI.this.setThumbLocation(((SynthSliderUI)SynthSliderUI.this).thumbRect.x, n2);
                    int n6 = n2 + n;
                    SynthSliderUI.this.slider.setValue(SynthSliderUI.this.valueForYPosition(n6));
                    break;
                }
                case 0: {
                    int n = ((SynthSliderUI)SynthSliderUI.this).thumbRect.width / 2;
                    int n7 = mouseEvent.getX() - this.offset;
                    int n8 = ((SynthSliderUI)SynthSliderUI.this).trackRect.x + n + SynthSliderUI.this.trackBorder;
                    int n9 = ((SynthSliderUI)SynthSliderUI.this).trackRect.x + ((SynthSliderUI)SynthSliderUI.this).trackRect.width - n - SynthSliderUI.this.trackBorder;
                    int n10 = SynthSliderUI.this.xPositionForValue(SynthSliderUI.this.slider.getMaximum() - SynthSliderUI.this.slider.getExtent());
                    if (SynthSliderUI.this.drawInverted()) {
                        n8 = n10;
                    } else {
                        n9 = n10;
                    }
                    n7 = Math.max(n7, n8 - n);
                    n7 = Math.min(n7, n9 - n);
                    SynthSliderUI.this.setThumbLocation(n7, ((SynthSliderUI)SynthSliderUI.this).thumbRect.y);
                    int n11 = n7 + n;
                    SynthSliderUI.this.slider.setValue(SynthSliderUI.this.valueForXPosition(n11));
                    break;
                }
                default: {
                    return;
                }
            }
            if (SynthSliderUI.this.slider.getValueIsAdjusting()) {
                SynthSliderUI.this.setThumbActive(true);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            SynthSliderUI.this.updateThumbState(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

