/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.condition;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class HasMethod
extends ProjectComponent
implements Condition {
    private String classname;
    private String method;
    private String field;
    private Path classpath;
    private AntClassLoader loader;
    private boolean ignoreSystemClasses = false;

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setIgnoreSystemClasses(boolean ignoreSystemClasses) {
        this.ignoreSystemClasses = ignoreSystemClasses;
    }

    private Class loadClass(String classname) {
        try {
            if (this.ignoreSystemClasses) {
                this.loader = this.getProject().createClassLoader(this.classpath);
                this.loader.setParentFirst(false);
                this.loader.addJavaLibraries();
                try {
                    return this.loader.findClass(classname);
                }
                catch (SecurityException se) {
                    return null;
                }
            }
            if (this.loader != null) {
                return this.loader.loadClass(classname);
            }
            ClassLoader l = this.getClass().getClassLoader();
            if (l != null) {
                return Class.forName(classname, true, l);
            }
            return Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("class \"" + classname + "\" was not found");
        }
        catch (NoClassDefFoundError e) {
            throw new BuildException("Could not load dependent class \"" + e.getMessage() + "\" for class \"" + classname + "\"");
        }
    }

    public boolean eval() throws BuildException {
        block8: {
            Class clazz;
            AntClassLoader preLoadClass;
            block7: {
                if (this.classname == null) {
                    throw new BuildException("No classname defined");
                }
                preLoadClass = this.loader;
                try {
                    clazz = this.loadClass(this.classname);
                    if (this.method == null) break block7;
                    boolean bl = this.isMethodFound(clazz);
                    Object var5_5 = null;
                    if (preLoadClass != this.loader && this.loader != null) {
                        this.loader.cleanup();
                        this.loader = null;
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var5_7 = null;
                        if (preLoadClass == this.loader || this.loader == null) break block9;
                        this.loader.cleanup();
                        this.loader = null;
                    }
                    throw throwable;
                }
            }
            if (this.field == null) break block8;
            boolean bl = this.isFieldFound(clazz);
            Object var5_6 = null;
            if (preLoadClass != this.loader && this.loader != null) {
                this.loader.cleanup();
                this.loader = null;
            }
            return bl;
        }
        throw new BuildException("Neither method nor field defined");
    }

    private boolean isFieldFound(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field fieldEntry = fields[i];
            if (!fieldEntry.getName().equals(this.field)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodFound(Class clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method methodEntry = methods[i];
            if (!methodEntry.getName().equals(this.method)) continue;
            return true;
        }
        return false;
    }
}

