/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.aluminium.AluminiumLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class AluminiumBorders
extends BaseBorders {
    private static Border buttonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return AluminiumBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource;
            Graphics2D graphics2D = (Graphics2D)graphics;
            ColorUIResource colorUIResource2 = AluminiumLookAndFeel.getWindowInactiveTitleBackgroundColor();
            if (this.isActive(component)) {
                colorUIResource2 = AluminiumLookAndFeel.getWindowTitleBackgroundColor();
            }
            int n5 = this.getTitleHeight(component);
            graphics.setColor(colorUIResource2);
            graphics.fillRect(1, 1, n3, 5);
            graphics.fillRect(1, n4 - 5, n3, 4);
            if (this.isActive(component)) {
                JTattooUtilities.fillHorGradient(graphics, AluminiumLookAndFeel.getTheme().getWindowTitleColors(), 1, 5, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AluminiumLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, 5, 5, n5 + 1);
                colorUIResource = AbstractLookAndFeel.getTheme().getWindowTitleColorDark();
                ColorUIResource colorUIResource3 = AbstractLookAndFeel.getTheme().getWindowTitleColorLight();
                graphics2D.setPaint(new GradientPaint(0.0f, 5 + n5 + 1, colorUIResource, 0.0f, n4 - n5 - 10, colorUIResource3));
                graphics.fillRect(1, 5 + n5 + 1, 4, n4 - n5 - 10);
                graphics.fillRect(n3 - 5, 5 + n5 + 1, 4, n4 - n5 - 10);
                graphics2D.setPaint(null);
            } else {
                JTattooUtilities.fillHorGradient(graphics, AluminiumLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, 5, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, AluminiumLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, 5, 5, n5 + 1);
                colorUIResource = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark();
                ColorUIResource colorUIResource4 = AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight();
                graphics2D.setPaint(new GradientPaint(0.0f, 5 + n5 + 1, colorUIResource, 0.0f, n4 - n5 - 10, colorUIResource4));
                graphics.fillRect(1, 5 + n5 + 1, 4, n4 - n5 - 10);
                graphics.fillRect(n3 - 5, 5 + n5 + 1, 4, n4 - n5 - 10);
                graphics2D.setPaint(null);
            }
            colorUIResource = AluminiumLookAndFeel.getWindowInactiveBorderColor();
            if (this.isActive(component)) {
                colorUIResource = AluminiumLookAndFeel.getWindowBorderColor();
            }
            graphics.setColor(colorUIResource);
            graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            graphics.drawLine(n + 5 - 1, n2 + this.insets.top + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + this.insets.top + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
            graphics.setColor(new Color(220, 220, 220));
            graphics.drawLine(1, 1, n3 - 3, 1);
            graphics.drawLine(1, 1, 1, n4 - 2);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            ColorUIResource colorUIResource = AluminiumLookAndFeel.getFrameColor();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(colorUIResource);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.15f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isRollover()) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    graphics.setColor(colorUIResource);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(AbstractLookAndFeel.getTheme().getSelectionBackgroundColor());
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 12, 2, 12);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }
}

