/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util.comparator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.comparator.InvertibleComparator;

public class CompoundComparator
implements Comparator,
Serializable {
    private final List comparators;

    public CompoundComparator() {
        this.comparators = new ArrayList();
    }

    public CompoundComparator(Comparator[] comparatorArray) {
        this.comparators = new ArrayList(comparatorArray.length);
        for (int i = 0; i < comparatorArray.length; ++i) {
            this.addComparator(comparatorArray[i]);
        }
    }

    public void addComparator(Comparator comparator) {
        if (comparator instanceof InvertibleComparator) {
            this.comparators.add(comparator);
        } else {
            this.comparators.add(new InvertibleComparator(comparator));
        }
    }

    public void addComparator(Comparator comparator, boolean bl) {
        this.comparators.add(new InvertibleComparator(comparator, bl));
    }

    public void setComparator(int n, Comparator comparator) {
        if (comparator instanceof InvertibleComparator) {
            this.comparators.set(n, comparator);
        } else {
            InvertibleComparator invertibleComparator = new InvertibleComparator(comparator);
            this.comparators.set(n, invertibleComparator);
        }
    }

    public void setComparator(int n, Comparator comparator, boolean bl) {
        InvertibleComparator invertibleComparator = new InvertibleComparator(comparator, bl);
        this.comparators.set(n, invertibleComparator);
    }

    public void invertOrder() {
        Iterator iterator = this.comparators.iterator();
        while (iterator.hasNext()) {
            ((InvertibleComparator)iterator.next()).invertOrder();
        }
    }

    public void invertOrder(int n) {
        this.getInvertibleComparator(n).invertOrder();
    }

    public void setAscendingOrder(int n) {
        this.getInvertibleComparator(n).setAscending(true);
    }

    public void setDescendingOrder(int n) {
        this.getInvertibleComparator(n).setAscending(false);
    }

    private InvertibleComparator getInvertibleComparator(int n) {
        return (InvertibleComparator)this.comparators.get(n);
    }

    public int getComparatorCount() {
        return this.comparators.size();
    }

    public int compare(Object object, Object object2) {
        Assert.state(this.comparators.size() > 0, "No sort definitions have been added to this CompoundComparator to compare");
        Iterator iterator = this.comparators.iterator();
        while (iterator.hasNext()) {
            InvertibleComparator invertibleComparator = (InvertibleComparator)iterator.next();
            int n = invertibleComparator.compare(object, object2);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompoundComparator)) {
            return false;
        }
        CompoundComparator compoundComparator = (CompoundComparator)object;
        return ((Object)this.comparators).equals(compoundComparator.comparators);
    }

    public int hashCode() {
        return ((Object)this.comparators).hashCode();
    }

    public String toString() {
        return "CompoundComparator: " + this.comparators;
    }
}

