/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSVIEWSRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSVIEWS";
    protected static final int SYSVIEWS_COLUMN_COUNT = 4;
    protected static final int SYSVIEWS_TABLEID = 1;
    protected static final int SYSVIEWS_VIEWDEFINITION = 2;
    protected static final int SYSVIEWS_CHECKOPTION = 3;
    protected static final int SYSVIEWS_COMPILATION_SCHEMAID = 4;
    protected static final int SYSVIEWS_TABLEID_WIDTH = 36;
    protected static final int SYSVIEWS_INDEX1_ID = 0;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"8000004d-00d0-fd77-3ed8-000a0a0b1900", "80000050-00d0-fd77-3ed8-000a0a0b1900", "8000004f-00d0-fd77-3ed8-000a0a0b1900"};

    SYSVIEWSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.initInfo(4, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (tupleDescriptor != null) {
            ViewDescriptor viewDescriptor = (ViewDescriptor)tupleDescriptor;
            UUID uUID = viewDescriptor.getUUID();
            if (uUID == null) {
                uUID = this.getUUIDFactory().createUUID();
                viewDescriptor.setUUID(uUID);
            }
            string = uUID.toString();
            string3 = viewDescriptor.getViewText();
            int n = viewDescriptor.getCheckOptionType();
            string4 = "N";
            UUID uUID2 = viewDescriptor.getCompSchemaId();
            string2 = uUID2 == null ? null : uUID2.toString();
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(4);
        execRow.setColumn(1, new SQLChar(string));
        execRow.setColumn(2, this.dvf.getLongvarcharDataValue(string3));
        execRow.setColumn(3, new SQLChar(string4));
        execRow.setColumn(4, new SQLChar(string2));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        ViewDescriptor viewDescriptor = null;
        UUID uUID = null;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID2 = this.getUUIDFactory().recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(3);
        String string3 = dataValueDescriptor.getString();
        int n = 0;
        dataValueDescriptor = execRow.getColumn(4);
        String string4 = dataValueDescriptor.getString();
        if (string4 != null) {
            uUID = this.getUUIDFactory().recreateUUID(string4);
        }
        viewDescriptor = dataDescriptorGenerator.newViewDescriptor(uUID2, null, string2, n, uUID);
        return viewDescriptor;
    }

    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("TABLEID", false), SystemColumnImpl.getColumn("VIEWDEFINITION", -1, false, 32700), SystemColumnImpl.getIndicatorColumn("CHECKOPTION"), SystemColumnImpl.getUUIDColumn("COMPILATIONSCHEMAID", true)};
    }
}

