/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.work;

import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import java.util.Collection;

public class PollProcessorStatus
extends Thread {
    private static final int MAX_COUNT = 20;

    @Override
    public void run() {
        long currenttime = System.currentTimeMillis();
        while (!SystemEnv.stopping) {
            try {
                int count = 0;
                Collection<AbstractProcessor> processors = GlobalProcessors.getProcessersCopy();
                currenttime = System.currentTimeMillis();
                for (AbstractProcessor processor : processors) {
                    if (SystemEnv.stopping) break;
                    if (processor == null || processor.isClosing() || processor.getHandler() == null) continue;
                    processor.pollQueryStatus();
                    if (++count < 20) continue;
                    PollProcessorStatus.sleep(20L);
                    count = 0;
                }
                long diff = System.currentTimeMillis() - currenttime;
                int sleeptime = 1000;
                sleeptime = diff < 4000L ? (processors.size() < 20 ? 2500 : 4000) : (diff < 8000L ? 5000 : 6000);
                PollProcessorStatus.sleep(sleeptime);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

