/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.work;

import cn.com.voltronic.solar.configure.SystemEnv;
import cn.com.voltronic.solar.dao.SynchroEnergyDao;
import cn.com.voltronic.solar.data.bean.SynchroEnergyPlan;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.work.SynchroThread;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SynchroEnergyScheduler
extends Thread {
    private static final Logger logger = Logger.getLogger(SynchroEnergyScheduler.class);
    private static final long INTEVAL_MILLIS = 10000L;

    @Override
    public void run() {
        while (!SystemEnv.stopping) {
            try {
                SynchroEnergyScheduler.sleep(10000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"run synchro energy scheduler error");
            }
            try {
                this.excuteSynchroEnergy();
            }
            catch (Exception e) {
                logger.error((Object)("run sysnchro energy control plan error" + e.getMessage()));
            }
        }
    }

    private void excuteSynchroEnergy() throws Exception {
        SynchroEnergyDao dao = new SynchroEnergyDao();
        List<SynchroEnergyPlan> plans = dao.querySynchroEnergyPlan();
        for (SynchroEnergyPlan plan : plans) {
            if (SystemEnv.stopping) break;
            if ("daily".equals(plan.getCycle())) {
                this.dailySynchro(plan);
                continue;
            }
            if ("weekly".equals(plan.getCycle())) {
                this.weeklySynchro(plan);
                continue;
            }
            if (!"monthly".equals(plan.getCycle())) continue;
            this.monthlySynchro(plan);
        }
    }

    private AbstractProcessor getProcessor(String serialno) {
        AbstractProcessor processor = null;
        Map<String, AbstractProcessor> maps = GlobalProcessors.getProcessorMapCopy();
        for (String key : maps.keySet()) {
            if (!key.endsWith(serialno)) continue;
            processor = maps.get(key);
            break;
        }
        return processor;
    }

    private void dailySynchro(SynchroEnergyPlan plan) throws Exception {
        Date planDate;
        long inteval;
        Calendar machineTime;
        AbstractProcessor processor = this.getProcessor(plan.getSerialno());
        if (processor != null && (machineTime = processor.getCurrentTime()) != null && (inteval = (planDate = this.combinDate(machineTime.getTime(), plan.getPlanTime())).getTime() - machineTime.getTimeInMillis()) > 0L && inteval < 10000L) {
            this.synchro(plan, processor, machineTime);
        }
    }

    private void weeklySynchro(SynchroEnergyPlan plan) throws Exception {
        Date planDate;
        long inteval;
        Calendar machineTime;
        AbstractProcessor processor = this.getProcessor(plan.getSerialno());
        if (processor != null && (machineTime = processor.getCurrentTime()) != null && plan.getPlanWeek() == machineTime.get(7) && (inteval = (planDate = this.combinDate(machineTime.getTime(), plan.getPlanTime())).getTime() - machineTime.getTimeInMillis()) > 0L && inteval < 10000L) {
            this.synchro(plan, processor, machineTime);
        }
    }

    private void monthlySynchro(SynchroEnergyPlan plan) throws Exception {
        Date planDate;
        long inteval;
        Calendar machineTime;
        AbstractProcessor processor = this.getProcessor(plan.getSerialno());
        if (processor != null && (machineTime = processor.getCurrentTime()) != null && plan.getPlanMonth() == machineTime.get(5) && (inteval = (planDate = this.combinDate(machineTime.getTime(), plan.getPlanTime())).getTime() - machineTime.getTimeInMillis()) > 0L && inteval < 10000L) {
            this.synchro(plan, processor, machineTime);
        }
    }

    private void synchro(SynchroEnergyPlan plan, AbstractProcessor processor, Calendar machineTime) {
        SynchroThread thread = new SynchroThread(plan, processor, machineTime, true);
        thread.setPriority(1);
        thread.start();
    }

    private Date combinDate(Date dayDate, Date timeDate) {
        Calendar dayCa = Calendar.getInstance();
        dayCa.setTime(dayDate);
        Calendar timeCa = Calendar.getInstance();
        timeCa.setTime(timeDate);
        timeCa.set(dayCa.get(1), dayCa.get(2), dayCa.get(5));
        return timeCa.getTime();
    }
}

