/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.xml;

import com.sun.deploy.xml.XMLAttribute;
import java.io.PrintWriter;
import java.io.StringWriter;

public class XMLNode {
    private boolean _isElement;
    private String _name;
    private XMLAttribute _attr;
    private XMLNode _parent;
    private XMLNode _nested;
    private XMLNode _next;
    public static final String WILDCARD = "*";

    public XMLNode(String string) {
        this._isElement = false;
        this._name = string;
        this._attr = null;
        this._nested = null;
        this._next = null;
        this._parent = null;
    }

    public XMLNode(String string, XMLAttribute xMLAttribute) {
        this(string, xMLAttribute, null, null);
    }

    public XMLNode(String string, XMLAttribute xMLAttribute, XMLNode xMLNode, XMLNode xMLNode2) {
        this._isElement = true;
        this._name = XMLNode.stripNameSpace(string);
        this._attr = xMLAttribute;
        this._nested = xMLNode;
        this._next = xMLNode2;
        this._parent = null;
    }

    public String getName() {
        return this._name;
    }

    public XMLAttribute getAttributes() {
        return this._attr;
    }

    public XMLNode getNested() {
        return this._nested;
    }

    public XMLNode getNext() {
        return this._next;
    }

    public boolean isElement() {
        return this._isElement;
    }

    public void setParent(XMLNode xMLNode) {
        this._parent = xMLNode;
    }

    public XMLNode getParent() {
        return this._parent;
    }

    public void setNext(XMLNode xMLNode) {
        this._next = xMLNode;
    }

    public void setNested(XMLNode xMLNode) {
        this._nested = xMLNode;
    }

    public static String stripNameSpace(String string) {
        int n;
        if (string != null && !string.startsWith("xmlns:") && (n = string.lastIndexOf(":")) >= 0 && n < string.length()) {
            return string.substring(n + 1);
        }
        return string;
    }

    public boolean equalsTemplate(Object object) {
        if (object == null || !(object instanceof XMLNode)) {
            return false;
        }
        XMLNode xMLNode = (XMLNode)object;
        boolean bl = this.matchTemplateName(xMLNode._name) && XMLNode.matchTemplateAttribute(this._attr, xMLNode._attr) && XMLNode.matchTemplateNode(this._nested, xMLNode._nested) && XMLNode.matchTemplateNode(this._next, xMLNode._next);
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XMLNode)) {
            return false;
        }
        XMLNode xMLNode = (XMLNode)object;
        boolean bl = XMLNode.match(this._name, xMLNode._name) && XMLNode.match(this._attr, xMLNode._attr) && XMLNode.match(this._nested, xMLNode._nested) && XMLNode.match(this._next, xMLNode._next);
        return bl;
    }

    public String getAttribute(String string) {
        for (XMLAttribute xMLAttribute = this._attr; xMLAttribute != null; xMLAttribute = xMLAttribute.getNext()) {
            if (!string.equals(xMLAttribute.getName())) continue;
            return xMLAttribute.getValue();
        }
        return "";
    }

    private static boolean match(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private boolean matchTemplateName(String string) {
        if (this._name == null) {
            return string == null;
        }
        if (this._name.equals(string)) {
            return true;
        }
        return !this._isElement && string.equals(WILDCARD);
    }

    private static boolean matchTemplateNode(XMLNode xMLNode, XMLNode xMLNode2) {
        if (xMLNode == null) {
            return xMLNode2 == null;
        }
        return xMLNode.equalsTemplate(xMLNode2);
    }

    private static boolean matchTemplateAttribute(XMLAttribute xMLAttribute, XMLAttribute xMLAttribute2) {
        if (xMLAttribute == null) {
            return xMLAttribute2 == null;
        }
        return xMLAttribute.equalsTemplate(xMLAttribute2);
    }

    public void printToStream(PrintWriter printWriter) {
        this.printToStream(printWriter, false);
    }

    public void printToStream(PrintWriter printWriter, boolean bl) {
        this.printToStream(printWriter, 0, bl);
    }

    public void printToStream(PrintWriter printWriter, int n, boolean bl) {
        if (!this.isElement()) {
            String string = this._name;
            if (bl && string.length() > 512) {
                string = "...";
            }
            printWriter.print(string);
        } else if (this._nested == null) {
            String string = this._attr == null ? "" : " " + this._attr.toString();
            XMLNode.lineln(printWriter, n, "<" + this._name + string + "/>");
        } else {
            String string = this._attr == null ? "" : " " + this._attr.toString();
            XMLNode.lineln(printWriter, n, "<" + this._name + string + ">");
            this._nested.printToStream(printWriter, n + 1, bl);
            if (this._nested.isElement()) {
                XMLNode.lineln(printWriter, n, "</" + this._name + ">");
            } else {
                printWriter.print("</" + this._name + ">");
            }
        }
        if (this._next != null) {
            this._next.printToStream(printWriter, n, bl);
        }
    }

    private static void lineln(PrintWriter printWriter, int n, String string) {
        printWriter.println("");
        for (int i = 0; i < n; ++i) {
            printWriter.print("  ");
        }
        printWriter.print(string);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringWriter stringWriter = new StringWriter(1000);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printToStream(printWriter, bl);
        printWriter.close();
        return stringWriter.toString();
    }
}

