/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractAutowireCapableBeanFactory
extends AbstractBeanFactory
implements AutowireCapableBeanFactory {
    private InstantiationStrategy instantiationStrategy = new CglibSubclassingInstantiationStrategy();
    private boolean allowCircularReferences = true;
    private boolean allowRawInjectionDespiteWrapping = false;
    private final Set ignoredDependencyTypes = new HashSet();
    private final Set ignoredDependencyInterfaces = new HashSet();
    private final ConstructorResolver constructorResolver = new ConstructorResolverAdapter();
    private final Map factoryBeanInstanceCache = new HashMap();
    private final Map filteredPropertyDescriptorsCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanNameAware;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanFactoryAware;
    static /* synthetic */ Class class$org$springframework$beans$factory$BeanClassLoaderAware;

    public AbstractAutowireCapableBeanFactory() {
        this.ignoreDependencyInterface(class$org$springframework$beans$factory$BeanNameAware == null ? (class$org$springframework$beans$factory$BeanNameAware = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.BeanNameAware")) : class$org$springframework$beans$factory$BeanNameAware);
        this.ignoreDependencyInterface(class$org$springframework$beans$factory$BeanFactoryAware == null ? (class$org$springframework$beans$factory$BeanFactoryAware = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.BeanFactoryAware")) : class$org$springframework$beans$factory$BeanFactoryAware);
        this.ignoreDependencyInterface(class$org$springframework$beans$factory$BeanClassLoaderAware == null ? (class$org$springframework$beans$factory$BeanClassLoaderAware = AbstractAutowireCapableBeanFactory.class$("org.springframework.beans.factory.BeanClassLoaderAware")) : class$org$springframework$beans$factory$BeanClassLoaderAware);
    }

    public AbstractAutowireCapableBeanFactory(BeanFactory beanFactory) {
        this();
        this.setParentBeanFactory(beanFactory);
    }

    public void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    protected InstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public void setAllowCircularReferences(boolean bl) {
        this.allowCircularReferences = bl;
    }

    public void setAllowRawInjectionDespiteWrapping(boolean bl) {
        this.allowRawInjectionDespiteWrapping = bl;
    }

    public void ignoreDependencyType(Class clazz) {
        this.ignoredDependencyTypes.add(clazz);
    }

    public void ignoreDependencyInterface(Class clazz) {
        this.ignoredDependencyInterfaces.add(clazz);
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory configurableBeanFactory) {
        super.copyConfigurationFrom(configurableBeanFactory);
        if (configurableBeanFactory instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory abstractAutowireCapableBeanFactory = (AbstractAutowireCapableBeanFactory)configurableBeanFactory;
            this.instantiationStrategy = abstractAutowireCapableBeanFactory.instantiationStrategy;
            this.allowCircularReferences = abstractAutowireCapableBeanFactory.allowCircularReferences;
            this.ignoredDependencyTypes.addAll(abstractAutowireCapableBeanFactory.ignoredDependencyTypes);
            this.ignoredDependencyInterfaces.addAll(abstractAutowireCapableBeanFactory.ignoredDependencyInterfaces);
        }
    }

    public Object createBean(Class clazz, int n, boolean bl) throws BeansException {
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(clazz, n, bl);
        rootBeanDefinition.setSingleton(false);
        return this.createBean(clazz.getName(), rootBeanDefinition, null);
    }

    public Object autowire(Class clazz, int n, boolean bl) throws BeansException {
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(clazz, n, bl);
        rootBeanDefinition.setSingleton(false);
        if (rootBeanDefinition.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(clazz.getName(), rootBeanDefinition, null).getWrappedInstance();
        }
        Object object = this.getInstantiationStrategy().instantiate(rootBeanDefinition, null, this);
        this.populateBean(clazz.getName(), rootBeanDefinition, new BeanWrapperImpl(object));
        return object;
    }

    public void autowireBeanProperties(Object object, int n, boolean bl) throws BeansException {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Just constants AUTOWIRE_BY_NAME and AUTOWIRE_BY_TYPE allowed");
        }
        RootBeanDefinition rootBeanDefinition = new RootBeanDefinition(object.getClass(), n, bl);
        rootBeanDefinition.setSingleton(false);
        this.populateBean(object.getClass().getName(), rootBeanDefinition, new BeanWrapperImpl(object));
    }

    public void applyBeanPropertyValues(Object object, String string) throws BeansException {
        RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string, true);
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
        this.initBeanWrapper(beanWrapperImpl);
        this.applyPropertyValues(string, rootBeanDefinition, beanWrapperImpl, rootBeanDefinition.getPropertyValues());
    }

    public Object configureBean(Object object, String string) throws BeansException {
        RootBeanDefinition rootBeanDefinition = this.getMergedBeanDefinition(string, true);
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
        this.initBeanWrapper(beanWrapperImpl);
        this.populateBean(string, rootBeanDefinition, beanWrapperImpl);
        return this.initializeBean(string, object, rootBeanDefinition);
    }

    public Object initializeBean(Object object, String string) {
        return this.initializeBean(string, object, null);
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object object, String string) throws BeansException {
        Object object2 = object;
        Iterator iterator = this.getBeanPostProcessors().iterator();
        while (iterator.hasNext()) {
            BeanPostProcessor beanPostProcessor = (BeanPostProcessor)iterator.next();
            object2 = beanPostProcessor.postProcessBeforeInitialization(object2, string);
        }
        return object2;
    }

    public Object applyBeanPostProcessorsAfterInitialization(Object object, String string) throws BeansException {
        Object object2 = object;
        Iterator iterator = this.getBeanPostProcessors().iterator();
        while (iterator.hasNext()) {
            BeanPostProcessor beanPostProcessor = (BeanPostProcessor)iterator.next();
            object2 = beanPostProcessor.postProcessAfterInitialization(object2, string);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createBean(String string, RootBeanDefinition rootBeanDefinition, Object[] objectArray) throws BeanCreationException {
        if (rootBeanDefinition.getDependsOn() != null) {
            for (int i = 0; i < rootBeanDefinition.getDependsOn().length; ++i) {
                this.getBean(rootBeanDefinition.getDependsOn()[i]);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating instance of bean '" + string + "' with merged definition [" + rootBeanDefinition + "]"));
        }
        Class clazz = this.resolveBeanClass(rootBeanDefinition, string);
        try {
            rootBeanDefinition.prepareMethodOverrides();
        }
        catch (BeanDefinitionValidationException beanDefinitionValidationException) {
            throw new BeanDefinitionStoreException(rootBeanDefinition.getResourceDescription(), string, "Validation of method overrides failed", (Throwable)((Object)beanDefinitionValidationException));
        }
        String string2 = null;
        try {
            Iterator iterator;
            Object object;
            Object object2;
            string2 = "BeanPostProcessor before instantiation of bean failed";
            if (clazz != null && !rootBeanDefinition.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors() && (object2 = this.applyBeanPostProcessorsBeforeInstantiation(clazz, string)) != null) {
                object2 = this.applyBeanPostProcessorsAfterInitialization(object2, string);
                return object2;
            }
            string2 = "Instantiation of bean failed";
            object2 = null;
            if (rootBeanDefinition.isSingleton()) {
                object = this.getSingletonMutex();
                synchronized (object) {
                    object2 = (BeanWrapper)this.factoryBeanInstanceCache.remove(string);
                }
            }
            if (object2 == null) {
                object2 = this.createBeanInstance(string, rootBeanDefinition, objectArray);
            }
            Object object3 = object = object2 != null ? object2.getWrappedInstance() : null;
            if (rootBeanDefinition.isSingleton() && this.allowCircularReferences && this.isSingletonCurrentlyInCreation(string)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Eagerly caching bean '" + string + "' to allow for resolving potential circular references"));
                }
                this.addSingleton(string, object);
            }
            string2 = "Initialization of bean failed";
            boolean bl = true;
            if (!rootBeanDefinition.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
                iterator = this.getBeanPostProcessors().iterator();
                while (iterator.hasNext()) {
                    InstantiationAwareBeanPostProcessor instantiationAwareBeanPostProcessor;
                    BeanPostProcessor beanPostProcessor = (BeanPostProcessor)iterator.next();
                    if (!(beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) || (instantiationAwareBeanPostProcessor = (InstantiationAwareBeanPostProcessor)beanPostProcessor).postProcessAfterInstantiation(object, string)) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                this.populateBean(string, rootBeanDefinition, (BeanWrapper)object2);
            }
            iterator = object;
            object = this.initializeBean(string, object, rootBeanDefinition);
            if (!this.allowRawInjectionDespiteWrapping && iterator != object && rootBeanDefinition.isSingleton() && this.hasDependentBean(string)) {
                throw new BeanCurrentlyInCreationException(string, "Bean with name '" + string + "' has been injected into other beans " + this.getDependentBeans(string) + " in its raw version as part of a circular reference, " + "but has eventually been wrapped (for example as part of auto-proxy creation). " + "This means that said other beans do not use the final version of the bean. " + "This is often the result of over-eager type matching - consider using " + "'getBeanNamesOfType' with the 'allowEagerInit' flag turned off, for example.");
            }
            this.registerDisposableBeanIfNecessary(string, iterator, rootBeanDefinition);
            return object;
        }
        catch (BeanCreationException beanCreationException) {
            throw beanCreationException;
        }
        catch (Throwable throwable) {
            throw new BeanCreationException(rootBeanDefinition.getResourceDescription(), string, string2, throwable);
        }
    }

    protected Class predictBeanType(String string, RootBeanDefinition rootBeanDefinition) {
        Class clazz = null;
        clazz = rootBeanDefinition.getFactoryMethodName() != null ? this.getTypeForFactoryMethod(string, rootBeanDefinition) : this.resolveBeanClass(rootBeanDefinition, string);
        if (!rootBeanDefinition.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            Iterator iterator = this.getBeanPostProcessors().iterator();
            while (iterator.hasNext()) {
                SmartInstantiationAwareBeanPostProcessor smartInstantiationAwareBeanPostProcessor;
                Class clazz2;
                BeanPostProcessor beanPostProcessor = (BeanPostProcessor)iterator.next();
                if (!(beanPostProcessor instanceof SmartInstantiationAwareBeanPostProcessor) || (clazz2 = (smartInstantiationAwareBeanPostProcessor = (SmartInstantiationAwareBeanPostProcessor)beanPostProcessor).predictBeanType(clazz, string)) == null) continue;
                return clazz2;
            }
        }
        return clazz;
    }

    protected Class getTypeForFactoryMethod(String string, RootBeanDefinition rootBeanDefinition) {
        Class clazz = null;
        boolean bl = true;
        if (rootBeanDefinition.getFactoryBeanName() != null) {
            clazz = this.getType(rootBeanDefinition.getFactoryBeanName());
            bl = false;
        } else {
            clazz = this.resolveBeanClass(rootBeanDefinition, string);
        }
        if (clazz == null) {
            return null;
        }
        int n = rootBeanDefinition.getConstructorArgumentValues().getArgumentCount();
        Method[] methodArray = ReflectionUtils.getAllDeclaredMethods((Class)clazz);
        HashSet hashSet = new HashSet(1);
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (Modifier.isStatic(method.getModifiers()) != bl || !method.getName().equals(rootBeanDefinition.getFactoryMethodName()) || method.getParameterTypes().length < n) continue;
            hashSet.add(method.getReturnType());
        }
        if (hashSet.size() == 1) {
            return (Class)hashSet.iterator().next();
        }
        return null;
    }

    protected Class getTypeForFactoryBean(String string, RootBeanDefinition rootBeanDefinition) {
        FactoryBean factoryBean;
        FactoryBean factoryBean2 = factoryBean = rootBeanDefinition.isSingleton() ? this.getSingletonFactoryBeanForTypeCheck(string, rootBeanDefinition) : this.getNonSingletonFactoryBeanForTypeCheck(string, rootBeanDefinition);
        if (factoryBean != null) {
            try {
                Class clazz = factoryBean.getObjectType();
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)"FactoryBean threw exception from getObjectType, despite the contract saying that it should return null if the type of its object cannot be determined yet", throwable);
            }
        }
        return super.getTypeForFactoryBean(string, rootBeanDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryBean getSingletonFactoryBeanForTypeCheck(String string, RootBeanDefinition rootBeanDefinition) {
        Object object = this.getSingletonMutex();
        synchronized (object) {
            BeanWrapper beanWrapper = (BeanWrapper)this.factoryBeanInstanceCache.get(string);
            if (beanWrapper != null) {
                return (FactoryBean)beanWrapper.getWrappedInstance();
            }
            if (this.isSingletonCurrentlyInCreation(string)) {
                return null;
            }
            Object object2 = null;
            try {
                Object object3;
                this.beforeSingletonCreation(string);
                Class clazz = this.resolveBeanClass(rootBeanDefinition, string);
                if (clazz != null && !rootBeanDefinition.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors() && (object3 = this.applyBeanPostProcessorsBeforeInstantiation(clazz, string)) != null) {
                    object2 = this.applyBeanPostProcessorsAfterInitialization(object3, string);
                }
                if (object2 == null) {
                    beanWrapper = this.createBeanInstance(string, rootBeanDefinition, null);
                    object2 = beanWrapper.getWrappedInstance();
                }
            }
            finally {
                this.afterSingletonCreation(string);
            }
            if (!(object2 instanceof FactoryBean)) {
                throw new BeanCreationException(string, "Bean instance of type [" + object2.getClass() + "] is not a FactoryBean");
            }
            if (beanWrapper != null) {
                this.factoryBeanInstanceCache.put(string, beanWrapper);
            }
            return (FactoryBean)object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryBean getNonSingletonFactoryBeanForTypeCheck(String string, RootBeanDefinition rootBeanDefinition) {
        if (this.isPrototypeCurrentlyInCreation(string)) {
            return null;
        }
        Object object = null;
        try {
            Object object2;
            this.beforePrototypeCreation(string);
            Class clazz = this.resolveBeanClass(rootBeanDefinition, string);
            if (clazz != null && !rootBeanDefinition.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors() && (object2 = this.applyBeanPostProcessorsBeforeInstantiation(clazz, string)) != null) {
                object = this.applyBeanPostProcessorsAfterInitialization(object2, string);
            }
            if (object == null) {
                object2 = this.createBeanInstance(string, rootBeanDefinition, null);
                object = object2.getWrappedInstance();
            }
        }
        finally {
            this.afterPrototypeCreation(string);
        }
        if (!(object instanceof FactoryBean)) {
            throw new BeanCreationException(string, "Bean instance of type [" + object.getClass() + "] is not a FactoryBean");
        }
        return (FactoryBean)object;
    }

    protected Object applyBeanPostProcessorsBeforeInstantiation(Class clazz, String string) throws BeansException {
        Iterator iterator = this.getBeanPostProcessors().iterator();
        while (iterator.hasNext()) {
            InstantiationAwareBeanPostProcessor instantiationAwareBeanPostProcessor;
            Object object;
            BeanPostProcessor beanPostProcessor = (BeanPostProcessor)iterator.next();
            if (!(beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) || (object = (instantiationAwareBeanPostProcessor = (InstantiationAwareBeanPostProcessor)beanPostProcessor).postProcessBeforeInstantiation(clazz, string)) == null) continue;
            return object;
        }
        return null;
    }

    protected BeanWrapper createBeanInstance(String string, RootBeanDefinition rootBeanDefinition, Object[] objectArray) {
        if (rootBeanDefinition.getFactoryMethodName() != null) {
            return this.instantiateUsingFactoryMethod(string, rootBeanDefinition, objectArray);
        }
        Constructor constructor = this.determineConstructorFromBeanPostProcessors(rootBeanDefinition.getBeanClass(), string);
        if (constructor != null || rootBeanDefinition.getResolvedAutowireMode() == 3 || rootBeanDefinition.hasConstructorArgumentValues()) {
            return this.autowireConstructor(string, rootBeanDefinition, constructor);
        }
        return this.instantiateBean(string, rootBeanDefinition);
    }

    protected Constructor determineConstructorFromBeanPostProcessors(Class clazz, String string) throws BeansException {
        Iterator iterator = this.getBeanPostProcessors().iterator();
        while (iterator.hasNext()) {
            SmartInstantiationAwareBeanPostProcessor smartInstantiationAwareBeanPostProcessor;
            Constructor constructor;
            BeanPostProcessor beanPostProcessor = (BeanPostProcessor)iterator.next();
            if (!(beanPostProcessor instanceof SmartInstantiationAwareBeanPostProcessor) || (constructor = (smartInstantiationAwareBeanPostProcessor = (SmartInstantiationAwareBeanPostProcessor)beanPostProcessor).determineConstructor(clazz, string)) == null) continue;
            return constructor;
        }
        return null;
    }

    protected BeanWrapper instantiateBean(String string, RootBeanDefinition rootBeanDefinition) {
        Object object = this.getInstantiationStrategy().instantiate(rootBeanDefinition, string, this);
        BeanWrapperImpl beanWrapperImpl = new BeanWrapperImpl(object);
        this.initBeanWrapper(beanWrapperImpl);
        return beanWrapperImpl;
    }

    protected BeanWrapper instantiateUsingFactoryMethod(String string, RootBeanDefinition rootBeanDefinition, Object[] objectArray) {
        ConstructorResolverAdapter constructorResolverAdapter = new ConstructorResolverAdapter();
        return constructorResolverAdapter.instantiateUsingFactoryMethod(string, rootBeanDefinition, objectArray);
    }

    protected BeanWrapper autowireConstructor(String string, RootBeanDefinition rootBeanDefinition, Constructor constructor) {
        return this.constructorResolver.autowireConstructor(string, rootBeanDefinition, constructor);
    }

    protected void populateBean(String string, RootBeanDefinition rootBeanDefinition, BeanWrapper beanWrapper) {
        boolean bl;
        PropertyValues propertyValues = rootBeanDefinition.getPropertyValues();
        if (beanWrapper == null) {
            if (!propertyValues.isEmpty()) {
                throw new BeanCreationException(string, "Cannot apply property values to null instance");
            }
            return;
        }
        if (rootBeanDefinition.getResolvedAutowireMode() == 1 || rootBeanDefinition.getResolvedAutowireMode() == 2) {
            MutablePropertyValues mutablePropertyValues = new MutablePropertyValues(propertyValues);
            if (rootBeanDefinition.getResolvedAutowireMode() == 1) {
                this.autowireByName(string, rootBeanDefinition, beanWrapper, mutablePropertyValues);
            }
            if (rootBeanDefinition.getResolvedAutowireMode() == 2) {
                this.autowireByType(string, rootBeanDefinition, beanWrapper, mutablePropertyValues);
            }
            propertyValues = mutablePropertyValues;
        }
        boolean bl2 = this.hasInstantiationAwareBeanPostProcessors();
        boolean bl3 = bl = rootBeanDefinition.getDependencyCheck() != 0;
        if (bl2 || bl) {
            PropertyDescriptor[] propertyDescriptorArray = this.filterPropertyDescriptorsForDependencyCheck(beanWrapper);
            if (bl2) {
                Iterator iterator = this.getBeanPostProcessors().iterator();
                while (iterator.hasNext()) {
                    InstantiationAwareBeanPostProcessor instantiationAwareBeanPostProcessor;
                    BeanPostProcessor beanPostProcessor = (BeanPostProcessor)iterator.next();
                    if (!(beanPostProcessor instanceof InstantiationAwareBeanPostProcessor) || (propertyValues = (instantiationAwareBeanPostProcessor = (InstantiationAwareBeanPostProcessor)beanPostProcessor).postProcessPropertyValues(propertyValues, propertyDescriptorArray, beanWrapper.getWrappedInstance(), string)) != null) continue;
                    return;
                }
            }
            if (bl) {
                this.checkDependencies(string, rootBeanDefinition, propertyDescriptorArray, propertyValues);
            }
        }
        this.applyPropertyValues(string, rootBeanDefinition, beanWrapper, propertyValues);
    }

    protected void autowireByName(String string, RootBeanDefinition rootBeanDefinition, BeanWrapper beanWrapper, MutablePropertyValues mutablePropertyValues) {
        String[] stringArray = this.unsatisfiedNonSimpleProperties(rootBeanDefinition, beanWrapper);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (this.containsBean(string2)) {
                Object object = this.getBean(string2);
                mutablePropertyValues.addPropertyValue(string2, object);
                if (rootBeanDefinition.isSingleton()) {
                    this.registerDependentBean(string2, string);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + string + "' via property '" + string2 + "' to bean named '" + string2 + "'"));
                continue;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Not autowiring property '" + string2 + "' of bean '" + string + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String string, RootBeanDefinition rootBeanDefinition, BeanWrapper beanWrapper, MutablePropertyValues mutablePropertyValues) {
        String[] stringArray = this.unsatisfiedNonSimpleProperties(rootBeanDefinition, beanWrapper);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            Class<?> clazz = beanWrapper.getPropertyDescriptor(string2).getPropertyType();
            Map map = this.findAutowireCandidates(string, clazz);
            int n = map.size();
            if (n == 1) {
                Map.Entry entry = map.entrySet().iterator().next();
                String string3 = (String)entry.getKey();
                Object v = entry.getValue();
                mutablePropertyValues.addPropertyValue(string2, v);
                if (rootBeanDefinition.isSingleton()) {
                    this.registerDependentBean(string3, string);
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Autowiring by type from bean name '" + string + "' via property '" + string2 + "' to bean named '" + string3 + "'"));
                continue;
            }
            if (n > 1) {
                throw new UnsatisfiedDependencyException(rootBeanDefinition.getResourceDescription(), string, string2, "There are " + map.size() + " beans of type [" + clazz.getName() + "] available for autowiring by type: " + map.keySet() + ". There should have been exactly 1 to be able to autowire property '" + string2 + "' of bean '" + string + "'. Consider using autowiring by name instead.");
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Not autowiring property '" + string2 + "' of bean '" + string + "' by type: no matching bean found"));
        }
    }

    protected String[] unsatisfiedNonSimpleProperties(RootBeanDefinition rootBeanDefinition, BeanWrapper beanWrapper) {
        TreeSet<String> treeSet = new TreeSet<String>();
        MutablePropertyValues mutablePropertyValues = rootBeanDefinition.getPropertyValues();
        PropertyDescriptor[] propertyDescriptorArray = beanWrapper.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (propertyDescriptorArray[i].getWriteMethod() == null || this.isExcludedFromDependencyCheck(propertyDescriptorArray[i]) || mutablePropertyValues.contains(propertyDescriptorArray[i].getName()) || BeanUtils.isSimpleProperty(propertyDescriptorArray[i].getPropertyType())) continue;
            treeSet.add(propertyDescriptorArray[i].getName());
        }
        return StringUtils.toStringArray(treeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyDescriptor[] filterPropertyDescriptorsForDependencyCheck(BeanWrapper beanWrapper) {
        Map map = this.filteredPropertyDescriptorsCache;
        synchronized (map) {
            PropertyDescriptor[] propertyDescriptorArray = (PropertyDescriptor[])this.filteredPropertyDescriptorsCache.get(beanWrapper.getWrappedClass());
            if (propertyDescriptorArray == null) {
                LinkedList<PropertyDescriptor> linkedList = new LinkedList<PropertyDescriptor>(Arrays.asList(beanWrapper.getPropertyDescriptors()));
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)iterator.next();
                    if (!this.isExcludedFromDependencyCheck(propertyDescriptor)) continue;
                    iterator.remove();
                }
                propertyDescriptorArray = linkedList.toArray(new PropertyDescriptor[linkedList.size()]);
                this.filteredPropertyDescriptorsCache.put(beanWrapper.getWrappedClass(), propertyDescriptorArray);
            }
            return propertyDescriptorArray;
        }
    }

    protected boolean isExcludedFromDependencyCheck(PropertyDescriptor propertyDescriptor) {
        return AutowireUtils.isExcludedFromDependencyCheck(propertyDescriptor) || this.ignoredDependencyTypes.contains(propertyDescriptor.getPropertyType()) || AutowireUtils.isSetterDefinedInInterface(propertyDescriptor, this.ignoredDependencyInterfaces);
    }

    protected void checkDependencies(String string, RootBeanDefinition rootBeanDefinition, PropertyDescriptor[] propertyDescriptorArray, PropertyValues propertyValues) throws UnsatisfiedDependencyException {
        int n = rootBeanDefinition.getDependencyCheck();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            boolean bl;
            if (propertyDescriptorArray[i].getWriteMethod() == null || propertyValues.contains(propertyDescriptorArray[i].getName())) continue;
            boolean bl2 = BeanUtils.isSimpleProperty(propertyDescriptorArray[i].getPropertyType());
            boolean bl3 = bl = n == 3 || bl2 && n == 2 || !bl2 && n == 1;
            if (!bl) continue;
            throw new UnsatisfiedDependencyException(rootBeanDefinition.getResourceDescription(), string, propertyDescriptorArray[i].getName(), "Set this property value or disable dependency checking for this bean.");
        }
    }

    protected void applyPropertyValues(String string, RootBeanDefinition rootBeanDefinition, BeanWrapper beanWrapper, PropertyValues propertyValues) {
        if (propertyValues == null || propertyValues.isEmpty()) {
            return;
        }
        MutablePropertyValues mutablePropertyValues = null;
        List list = null;
        if (propertyValues instanceof MutablePropertyValues) {
            mutablePropertyValues = (MutablePropertyValues)propertyValues;
            if (mutablePropertyValues.isConverted()) {
                try {
                    beanWrapper.setPropertyValues(mutablePropertyValues);
                    return;
                }
                catch (BeansException beansException) {
                    throw new BeanCreationException(rootBeanDefinition.getResourceDescription(), string, "Error setting property values", (Throwable)((Object)beansException));
                }
            }
            list = mutablePropertyValues.getPropertyValueList();
        } else {
            list = Arrays.asList(propertyValues.getPropertyValues());
        }
        BeanDefinitionValueResolver beanDefinitionValueResolver = new BeanDefinitionValueResolver(this, string, rootBeanDefinition, beanWrapper);
        BeanWrapperImpl beanWrapperImpl = beanWrapper instanceof BeanWrapperImpl ? (BeanWrapperImpl)beanWrapper : null;
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>(list.size());
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PropertyValue propertyValue = (PropertyValue)iterator.next();
            if (propertyValue.isConverted()) {
                arrayList.add(propertyValue);
                continue;
            }
            String string2 = propertyValue.getName();
            Object object = propertyValue.getValue();
            Object object2 = beanDefinitionValueResolver.resolveValueIfNecessary("bean property '" + string2 + "'", object);
            if (object2 == object) {
                if (beanWrapperImpl != null && !PropertyAccessorUtils.isNestedOrIndexedProperty(string2)) {
                    propertyValue.setConvertedValue(beanWrapperImpl.convertForProperty(object2, string2));
                }
                arrayList.add(propertyValue);
                continue;
            }
            if (object instanceof TypedStringValue && beanWrapperImpl != null && !PropertyAccessorUtils.isNestedOrIndexedProperty(string2)) {
                propertyValue.setConvertedValue(beanWrapperImpl.convertForProperty(object2, string2));
                arrayList.add(propertyValue);
                continue;
            }
            bl = true;
            arrayList.add(new PropertyValue(string2, object2));
        }
        if (mutablePropertyValues != null && !bl) {
            mutablePropertyValues.setConverted();
        }
        try {
            beanWrapper.setPropertyValues(new MutablePropertyValues(arrayList));
        }
        catch (BeansException beansException) {
            throw new BeanCreationException(rootBeanDefinition.getResourceDescription(), string, "Error setting property values", (Throwable)((Object)beansException));
        }
    }

    protected Object initializeBean(String string, Object object, RootBeanDefinition rootBeanDefinition) {
        if (object instanceof BeanNameAware) {
            ((BeanNameAware)object).setBeanName(string);
        }
        if (object instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)object).setBeanClassLoader(this.getBeanClassLoader());
        }
        if (object instanceof BeanFactoryAware) {
            ((BeanFactoryAware)object).setBeanFactory(this);
        }
        Object object2 = object;
        if (rootBeanDefinition == null || !rootBeanDefinition.isSynthetic()) {
            object2 = this.applyBeanPostProcessorsBeforeInitialization(object2, string);
        }
        try {
            this.invokeInitMethods(string, object2, rootBeanDefinition);
        }
        catch (Throwable throwable) {
            throw new BeanCreationException(rootBeanDefinition != null ? rootBeanDefinition.getResourceDescription() : null, string, "Invocation of init method failed", throwable);
        }
        if (rootBeanDefinition == null || !rootBeanDefinition.isSynthetic()) {
            object2 = this.applyBeanPostProcessorsAfterInitialization(object2, string);
        }
        return object2;
    }

    protected void invokeInitMethods(String string, Object object, RootBeanDefinition rootBeanDefinition) throws Throwable {
        if (object instanceof InitializingBean) {
            ((InitializingBean)object).afterPropertiesSet();
        }
        if (rootBeanDefinition != null && rootBeanDefinition.getInitMethodName() != null) {
            this.invokeCustomInitMethod(string, object, rootBeanDefinition.getInitMethodName(), rootBeanDefinition.isEnforceInitMethod());
        }
    }

    protected void invokeCustomInitMethod(String string, Object object, String string2, boolean bl) throws Throwable {
        Method method = BeanUtils.findMethod(object.getClass(), string2, null);
        if (method == null) {
            if (bl) {
                throw new NoSuchMethodException("Couldn't find an init method named '" + string2 + "' on bean with name '" + string + "'");
            }
            return;
        }
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        try {
            method.invoke(object, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String string) {
        return this.applyBeanPostProcessorsAfterInitialization(object, string);
    }

    protected void removeSingleton(String string) {
        super.removeSingleton(string);
        this.factoryBeanInstanceCache.remove(string);
    }

    protected Map findAutowireCandidates(String string, Class clazz) throws BeansException {
        Map map = this.findMatchingBeans(clazz);
        return map != null ? map : Collections.EMPTY_MAP;
    }

    protected Map findMatchingBeans(Class clazz) throws BeansException {
        throw new FatalBeanException("Bean lookup by type not supported by this factory");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ConstructorResolverAdapter
    extends ConstructorResolver {
        public ConstructorResolverAdapter() {
            super(AbstractAutowireCapableBeanFactory.this, AbstractAutowireCapableBeanFactory.this.getInstantiationStrategy());
        }

        protected Map findAutowireCandidates(String string, Class clazz) throws BeansException {
            return AbstractAutowireCapableBeanFactory.this.findAutowireCandidates(string, clazz);
        }
    }
}

