/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Vector;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialException;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public class SerialJavaObject
implements Serializable,
Cloneable {
    private final Object obj;
    private transient Field[] fields;
    static final long serialVersionUID = -1465795139032831023L;
    Vector chain;

    public SerialJavaObject(Object object) throws SerialException {
        Class<?> clazz = object.getClass();
        if (!(object instanceof Serializable)) {
            this.setWarning(new RowSetWarning("Warning, the object passed to the constructor does not implement Serializable"));
        }
        boolean bl = false;
        this.fields = clazz.getFields();
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getModifiers() != 8) continue;
            bl = true;
        }
        if (bl) {
            throw new SerialException("Located static fields in object instance. Cannot serialize");
        }
        this.obj = object;
    }

    public Object getObject() throws SerialException {
        return this.obj;
    }

    @CallerSensitive
    public Field[] getFields() throws SerialException {
        if (this.fields != null) {
            Class clazz;
            Class<?> clazz2 = this.obj.getClass();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && ReflectUtil.needsPackageAccessCheck((clazz = Reflection.getCallerClass()).getClassLoader(), clazz2.getClassLoader())) {
                ReflectUtil.checkPackageAccess(clazz2);
            }
            return clazz2.getFields();
        }
        throw new SerialException("SerialJavaObject does not contain a serialized object instance");
    }

    private void setWarning(RowSetWarning rowSetWarning) {
        if (this.chain == null) {
            this.chain = new Vector();
        }
        this.chain.add(rowSetWarning);
    }
}

