/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.sourcemodel.attach;

import com.sun.xml.internal.ws.policy.Policy;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyModelTranslator;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicyModelUnmarshaller;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.policy.sourcemodel.attach.ContextClassloaderLocal;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ExternalAttachmentsUnmarshaller {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(ExternalAttachmentsUnmarshaller.class);
    public static final URI BINDING_ID;
    public static final URI BINDING_OPERATION_ID;
    public static final URI BINDING_OPERATION_INPUT_ID;
    public static final URI BINDING_OPERATION_OUTPUT_ID;
    public static final URI BINDING_OPERATION_FAULT_ID;
    private static final QName POLICY_ATTACHMENT;
    private static final QName APPLIES_TO;
    private static final QName POLICY;
    private static final QName URI;
    private static final QName POLICIES;
    private static final ContextClassloaderLocal<XMLInputFactory> XML_INPUT_FACTORY;
    private static final PolicyModelUnmarshaller POLICY_UNMARSHALLER;
    private final Map<URI, Policy> map = new HashMap<URI, Policy>();
    private URI currentUri = null;
    private Policy currentPolicy = null;

    public static Map<URI, Policy> unmarshal(Reader reader) throws PolicyException {
        LOGGER.entering(reader);
        try {
            XMLEventReader xMLEventReader = XML_INPUT_FACTORY.get().createXMLEventReader(reader);
            ExternalAttachmentsUnmarshaller externalAttachmentsUnmarshaller = new ExternalAttachmentsUnmarshaller();
            Map<URI, Policy> map = externalAttachmentsUnmarshaller.unmarshal(xMLEventReader, null);
            LOGGER.exiting(map);
            return Collections.unmodifiableMap(map);
        }
        catch (XMLStreamException xMLStreamException) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0086_FAILED_CREATE_READER(reader)), xMLStreamException);
        }
    }

    private Map<URI, Policy> unmarshal(XMLEventReader xMLEventReader, StartElement startElement) throws PolicyException {
        XMLEvent xMLEvent = null;
        block9: while (xMLEventReader.hasNext()) {
            try {
                xMLEvent = xMLEventReader.peek();
                switch (xMLEvent.getEventType()) {
                    case 5: 
                    case 7: {
                        xMLEventReader.nextEvent();
                        continue block9;
                    }
                    case 4: {
                        this.processCharacters(xMLEvent.asCharacters(), startElement, this.map);
                        xMLEventReader.nextEvent();
                        continue block9;
                    }
                    case 2: {
                        this.processEndTag(xMLEvent.asEndElement(), startElement);
                        xMLEventReader.nextEvent();
                        return this.map;
                    }
                    case 1: {
                        StartElement startElement2 = xMLEvent.asStartElement();
                        this.processStartTag(startElement2, startElement, xMLEventReader, this.map);
                        continue block9;
                    }
                    case 8: {
                        return this.map;
                    }
                }
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0087_UNKNOWN_EVENT(xMLEvent)));
            }
            catch (XMLStreamException xMLStreamException) {
                Location location = xMLEvent == null ? null : xMLEvent.getLocation();
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0088_FAILED_PARSE(location)), xMLStreamException);
            }
        }
        return this.map;
    }

    private void processStartTag(StartElement startElement, StartElement startElement2, XMLEventReader xMLEventReader, Map<URI, Policy> map) throws PolicyException {
        try {
            QName qName = startElement.getName();
            if (startElement2 == null) {
                if (!qName.equals(POLICIES)) {
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0089_EXPECTED_ELEMENT("<Policies>", qName, startElement.getLocation())));
                }
            } else {
                QName qName2 = startElement2.getName();
                if (qName2.equals(POLICIES)) {
                    if (!qName.equals(POLICY_ATTACHMENT)) {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0089_EXPECTED_ELEMENT("<PolicyAttachment>", qName, startElement.getLocation())));
                    }
                } else if (qName2.equals(POLICY_ATTACHMENT)) {
                    if (qName.equals(POLICY)) {
                        this.readPolicy(xMLEventReader);
                        return;
                    }
                    if (!qName.equals(APPLIES_TO)) {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0089_EXPECTED_ELEMENT("<AppliesTo> or <Policy>", qName, startElement.getLocation())));
                    }
                } else if (qName2.equals(APPLIES_TO)) {
                    if (!qName.equals(URI)) {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0089_EXPECTED_ELEMENT("<URI>", qName, startElement.getLocation())));
                    }
                } else {
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0090_UNEXPECTED_ELEMENT(qName, startElement.getLocation())));
                }
            }
            xMLEventReader.nextEvent();
            this.unmarshal(xMLEventReader, startElement);
        }
        catch (XMLStreamException xMLStreamException) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0088_FAILED_PARSE(startElement.getLocation()), xMLStreamException));
        }
    }

    private void readPolicy(XMLEventReader xMLEventReader) throws PolicyException {
        PolicySourceModel policySourceModel = POLICY_UNMARSHALLER.unmarshalModel(xMLEventReader);
        PolicyModelTranslator policyModelTranslator = PolicyModelTranslator.getTranslator();
        Policy policy = policyModelTranslator.translate(policySourceModel);
        if (this.currentUri != null) {
            this.map.put(this.currentUri, policy);
            this.currentUri = null;
            this.currentPolicy = null;
        } else {
            this.currentPolicy = policy;
        }
    }

    private void processEndTag(EndElement endElement, StartElement startElement) throws PolicyException {
        this.checkEndTagName(startElement.getName(), endElement);
    }

    private void checkEndTagName(QName qName, EndElement endElement) throws PolicyException {
        QName qName2 = endElement.getName();
        if (!qName.equals(qName2)) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0091_END_ELEMENT_NO_MATCH(qName, endElement, endElement.getLocation())));
        }
    }

    private void processCharacters(Characters characters, StartElement startElement, Map<URI, Policy> map) throws PolicyException {
        if (characters.isWhiteSpace()) {
            return;
        }
        String string = characters.getData();
        if (startElement != null && URI.equals(startElement.getName())) {
            this.processUri(characters, map);
            return;
        }
        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0092_CHARACTER_DATA_UNEXPECTED(startElement, string, characters.getLocation())));
    }

    private void processUri(Characters characters, Map<URI, Policy> map) throws PolicyException {
        String string = characters.getData().trim();
        try {
            URI uRI = new URI(string);
            if (this.currentPolicy != null) {
                map.put(uRI, this.currentPolicy);
                this.currentUri = null;
                this.currentPolicy = null;
            } else {
                this.currentUri = uRI;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0093_INVALID_URI(string, characters.getLocation())), uRISyntaxException);
        }
    }

    static {
        try {
            BINDING_ID = new URI("urn:uuid:c9bef600-0d7a-11de-abc1-0002a5d5c51b");
            BINDING_OPERATION_ID = new URI("urn:uuid:62e66b60-0d7b-11de-a1a2-0002a5d5c51b");
            BINDING_OPERATION_INPUT_ID = new URI("urn:uuid:730d8d20-0d7b-11de-84e9-0002a5d5c51b");
            BINDING_OPERATION_OUTPUT_ID = new URI("urn:uuid:85b0f980-0d7b-11de-8e9d-0002a5d5c51b");
            BINDING_OPERATION_FAULT_ID = new URI("urn:uuid:917cb060-0d7b-11de-9e80-0002a5d5c51b");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_0094_INVALID_URN()), uRISyntaxException);
        }
        POLICY_ATTACHMENT = new QName("http://www.w3.org/ns/ws-policy", "PolicyAttachment");
        APPLIES_TO = new QName("http://www.w3.org/ns/ws-policy", "AppliesTo");
        POLICY = new QName("http://www.w3.org/ns/ws-policy", "Policy");
        URI = new QName("http://www.w3.org/ns/ws-policy", "URI");
        POLICIES = new QName("http://java.sun.com/xml/ns/metro/management", "Policies");
        XML_INPUT_FACTORY = new ContextClassloaderLocal<XMLInputFactory>(){

            @Override
            protected XMLInputFactory initialValue() throws Exception {
                return XMLInputFactory.newInstance();
            }
        };
        POLICY_UNMARSHALLER = PolicyModelUnmarshaller.getXmlUnmarshaller();
    }
}

