/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.dao;

import cn.com.voltronic.solar.dao.BaseDao;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.dbtools.DBManager;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.util.DateUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class FaultDataDao
extends BaseDao {
    private final String DELETE_FAULTDATA = "delete from faultdata where serialno = ? and trandate = ?";
    private final String DELETE_FAULTDATA_ALL = "delete from faultdata where serialno = ? and trandate BETWEEN ? and ?";

    public List<String> getAllProdid() {
        ArrayList<String> result;
        block6: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct prodid FROM faultdata");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString("prodid"));
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public String getProdidBySerialno(String serialno) {
        String result;
        block6: {
            result = "";
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct prodid FROM faultdata where serialno=?");
                    ps.setString(1, serialno);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = rs.getString("prodid");
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public List<String> getSerialNo() {
        ArrayList<String> result;
        block6: {
            result = new ArrayList<String>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("SELECT distinct serialno FROM faultdata order by serialno");
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result.add(rs.getString("serialno"));
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean alreadyInsert(DataBeforeFault data) {
        boolean result;
        block6: {
            result = false;
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from faultdata where serialno=? and trandate=? and faultString=?");
                    ps.setString(1, data.getSerialno());
                    ps.setTimestamp(2, new Timestamp(data.getTrandate().getTime()));
                    ps.setString(3, data.getFaultString());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        result = true;
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return result;
    }

    public boolean insertData(DataBeforeFault faultdata) {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement(" INSERT INTO faultdata (    prodid,serialno,faultString,trandate,pvinputvoltage1,pvinputvoltage2,pvinputvoltage3,   pvinputcurrent1,pvinputcurrent2,pvinputcurrent3,inverterVoltage,inverterCurrent,   gridVoltage,gridCurrent,gridFrequency,outputLoadPercent,outputLoadCurrent,outputLoadVoltage,   outputLoadFrequency,batteryVoltage,maxTemperature,runStatus,workMode,batteryCurrent,pvinputpower1,pvinputpower2,   acinputvoltager,acinputvoltages,acinputvoltaget,acoutputvoltager,acoutputvoltages,acoutputvoltaget,   acoutputapperentpowerr,acoutputapperentpowers,acoutputapperentpowert,innertemperature,componenttemperature,   externalbatterytemperature,pvinputpower3,acoutputactivepowerr,acoutputactivepowers,acoutputactivepowert,acoutputfrequency,   batteryDischargeCurrent,batteryChargingCurrent,batteryCapacity) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                ps.setString(1, faultdata.getProdid());
                ps.setString(2, faultdata.getSerialno());
                ps.setString(3, faultdata.getFaultString());
                ps.setTimestamp(4, new Timestamp(faultdata.getTrandate().getTime()));
                ps.setDouble(5, faultdata.getPvinputvoltage1());
                ps.setDouble(6, faultdata.getPvinputvoltage2());
                ps.setDouble(7, faultdata.getPvinputvoltage3());
                ps.setDouble(8, faultdata.getPvinputcurrent1());
                ps.setDouble(9, faultdata.getPvinputcurrent2());
                ps.setDouble(10, faultdata.getPvinputcurrent3());
                ps.setDouble(11, faultdata.getInverterVoltage());
                ps.setDouble(12, faultdata.getInverterCurrent());
                ps.setDouble(13, faultdata.getGridVoltage());
                ps.setDouble(14, faultdata.getGridCurrent());
                ps.setDouble(15, faultdata.getGridFrequency());
                ps.setInt(16, faultdata.getOutputLoadPercent());
                ps.setDouble(17, faultdata.getOutputLoadCurrent());
                ps.setDouble(18, faultdata.getOutputLoadVoltage());
                ps.setDouble(19, faultdata.getOutputLoadFrequency());
                ps.setDouble(20, faultdata.getBatteryVoltage());
                ps.setDouble(21, faultdata.getMaxTemperature());
                ps.setString(22, faultdata.getRunStatus());
                ps.setString(23, faultdata.getWorkMode());
                ps.setDouble(24, faultdata.getBatteryCurrent());
                ps.setDouble(25, faultdata.getPvinputpower1());
                ps.setDouble(26, faultdata.getPvinputpower2());
                ps.setDouble(27, faultdata.getAcinputvoltager());
                ps.setDouble(28, faultdata.getAcinputvoltages());
                ps.setDouble(29, faultdata.getAcinputvoltaget());
                ps.setDouble(30, faultdata.getAcoutputvoltager());
                ps.setDouble(31, faultdata.getAcoutputvoltages());
                ps.setDouble(32, faultdata.getAcoutputvoltaget());
                ps.setDouble(33, faultdata.getAcoutputapperentpowerr());
                ps.setDouble(34, faultdata.getAcoutputapperentpowers());
                ps.setDouble(35, faultdata.getAcoutputapperentpowert());
                ps.setDouble(36, faultdata.getInnertemperature());
                ps.setDouble(37, faultdata.getComponenttemperature());
                ps.setDouble(38, faultdata.getExternalbatterytemperature());
                ps.setDouble(39, faultdata.getPvinputpower3());
                ps.setDouble(40, faultdata.getAcoutputactivepowerr());
                ps.setDouble(41, faultdata.getAcoutputactivepowers());
                ps.setDouble(42, faultdata.getAcoutputactivepowert());
                ps.setDouble(43, faultdata.getAcoutputfrequency());
                ps.setDouble(44, faultdata.getBatteryDischargeCurrent());
                ps.setDouble(45, faultdata.getBatteryChargingCurrent());
                ps.setInt(46, faultdata.getBatteryCapacity());
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public List<DataBeforeFault> queryData(String serialno, Date beginDate, Date endDate) {
        ArrayList<DataBeforeFault> resultList;
        block6: {
            String prodid = "P15";
            prodid = this.getProdidBySerialno(serialno);
            Calendar end = Calendar.getInstance();
            end.setTime(endDate);
            Calendar start = Calendar.getInstance();
            start.setTime(beginDate);
            resultList = new ArrayList<DataBeforeFault>();
            Connection conn = DBManager.getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    ps = conn.prepareStatement("select * from faultdata where serialno=? and trandate between ? and ? order by trandate ");
                    ps.setString(1, serialno);
                    ps.setTimestamp(2, new Timestamp(DateUtils.getStartofDayFullTime(start).getTime().getTime()));
                    ps.setTimestamp(3, new Timestamp(DateUtils.getEndofDayFullTime(end).getTime().getTime()));
                    rs = ps.executeQuery();
                    conn.commit();
                    while (rs.next()) {
                        DataBeforeFault data = new DataBeforeFault();
                        data.setSerialno(serialno);
                        data.setTrandate(rs.getTimestamp("trandate"));
                        String faultString = EventsHandler.getFaultString(prodid, rs.getString("faultString"));
                        data.setFaultString(faultString);
                        data.setPvinputvoltage1(rs.getDouble("pvinputvoltage1"));
                        data.setPvinputvoltage2(rs.getDouble("pvinputvoltage2"));
                        data.setPvinputvoltage3(rs.getDouble("pvinputvoltage3"));
                        data.setPvinputcurrent1(rs.getDouble("pvinputcurrent1"));
                        data.setPvinputcurrent2(rs.getDouble("pvinputcurrent2"));
                        data.setPvinputcurrent3(rs.getDouble("pvinputcurrent3"));
                        data.setPvinputpower1(rs.getDouble("pvinputpower1"));
                        data.setPvinputpower2(rs.getDouble("pvinputpower2"));
                        data.setPvinputpower3(rs.getDouble("pvinputpower3"));
                        data.setInverterVoltage(rs.getDouble("inverterVoltage"));
                        data.setInverterCurrent(rs.getDouble("inverterCurrent"));
                        data.setGridCurrent(rs.getDouble("gridCurrent"));
                        data.setGridVoltage(rs.getDouble("gridVoltage"));
                        data.setGridFrequency(rs.getDouble("gridFrequency"));
                        data.setOutputLoadPercent(rs.getInt("outputLoadPercent"));
                        data.setOutputLoadCurrent(rs.getDouble("outputLoadCurrent"));
                        data.setOutputLoadVoltage(rs.getDouble("outputLoadVoltage"));
                        data.setOutputLoadFrequency(rs.getDouble("outputLoadFrequency"));
                        data.setBatteryVoltage(rs.getDouble("batteryVoltage"));
                        data.setMaxTemperature(rs.getDouble("maxTemperature"));
                        data.setRunStatus(rs.getString("runStatus"));
                        data.setAcinputvoltager(rs.getDouble("acinputvoltager"));
                        data.setAcinputvoltages(rs.getDouble("acinputvoltages"));
                        data.setAcinputvoltaget(rs.getDouble("acinputvoltaget"));
                        data.setAcoutputvoltager(rs.getDouble("acoutputvoltager"));
                        data.setAcoutputvoltages(rs.getDouble("acoutputvoltages"));
                        data.setAcoutputvoltaget(rs.getDouble("acoutputvoltaget"));
                        data.setAcoutputactivepowerr(rs.getDouble("acoutputactivepowerr"));
                        data.setAcoutputactivepowers(rs.getDouble("acoutputactivepowers"));
                        data.setAcoutputactivepowert(rs.getDouble("acoutputactivepowert"));
                        data.setAcoutputfrequency(rs.getDouble("acoutputfrequency"));
                        data.setBatteryDischargeCurrent(rs.getDouble("batteryDischargeCurrent"));
                        data.setBatteryChargingCurrent(rs.getDouble("batteryChargingCurrent"));
                        data.setBatteryCapacity(rs.getInt("batteryCapacity"));
                        resultList.add(data);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.close(rs, ps);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.close(rs, ps);
                throw throwable;
            }
            this.close(rs, ps);
        }
        return resultList;
    }

    public boolean removeData(String serialno, Date date) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata where serialno = ? and trandate = ?");
                ps.setString(1, serialno);
                ps.setTimestamp(2, new Timestamp(date.getTime()));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean removeDataAll(String serialno, Date fromDate, Date toDate) {
        boolean result = false;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata where serialno = ? and trandate BETWEEN ? and ?");
                ps.setString(1, serialno);
                ps.setDate(2, new java.sql.Date(fromDate.getTime()));
                ps.setDate(3, new java.sql.Date(toDate.getTime() + 86400000L));
                if (ps.executeUpdate() > 0) {
                    result = true;
                }
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public boolean removeAll() {
        boolean result = true;
        Connection conn = DBManager.getConnection();
        PreparedStatement ps = null;
        try {
            try {
                ps = conn.prepareStatement("delete from faultdata");
                ps.executeUpdate();
                conn.commit();
            }
            catch (Exception e) {
                result = false;
                this.close(ps);
            }
        }
        finally {
            this.close(ps);
        }
        return result;
    }

    public static void main(String[] args) {
        FaultDataDao dao = new FaultDataDao();
        DataBeforeFault faultdata = new DataBeforeFault();
        faultdata.setProdid("P16");
        faultdata.setSerialno("90000000000002");
        faultdata.setFaultString("1002");
        faultdata.setGridVoltage(222.0);
        faultdata.setGridCurrent(2.0);
        faultdata.setGridFrequency(123.0);
        faultdata.setMaxTemperature(32.0);
        faultdata.setPvinputcurrent1(15.0);
        faultdata.setPvinputvoltage1(12.0);
        faultdata.setTrandate(new Date());
        faultdata.setPvinputcurrent2(231.0);
        faultdata.setPvinputvoltage2(43.0);
        faultdata.setBatteryVoltage(555.0);
        boolean re = dao.insertData(faultdata);
        System.out.println(re);
    }
}

