/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class PropertyOverrideConfigurer
extends PropertyResourceConfigurer {
    public static final String DEFAULT_BEAN_NAME_SEPARATOR = ".";
    private String beanNameSeparator = ".";
    private boolean ignoreInvalidKeys = false;
    private Set beanNames = Collections.synchronizedSet(new HashSet());

    public void setBeanNameSeparator(String string) {
        this.beanNameSeparator = string;
    }

    public void setIgnoreInvalidKeys(boolean bl) {
        this.ignoreInvalidKeys = bl;
    }

    protected void processProperties(ConfigurableListableBeanFactory configurableListableBeanFactory, Properties properties) throws BeansException {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            try {
                this.processKey(configurableListableBeanFactory, string, properties.getProperty(string));
            }
            catch (BeansException beansException) {
                String string2 = "Could not process key '" + string + "' in PropertyOverrideConfigurer";
                if (!this.ignoreInvalidKeys) {
                    throw new BeanInitializationException(string2, (Throwable)((Object)beansException));
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)string2, (Throwable)((Object)beansException));
            }
        }
    }

    protected void processKey(ConfigurableListableBeanFactory configurableListableBeanFactory, String string, String string2) throws BeansException {
        int n = string.indexOf(this.beanNameSeparator);
        if (n == -1) {
            throw new BeanInitializationException("Invalid key '" + string + "': expected 'beanName" + this.beanNameSeparator + "property'");
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        this.beanNames.add(string3);
        this.applyPropertyValue(configurableListableBeanFactory, string3, string4, string2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Property '" + string + "' set to value [" + string2 + "]"));
        }
    }

    protected void applyPropertyValue(ConfigurableListableBeanFactory configurableListableBeanFactory, String string, String string2, String string3) {
        BeanDefinition beanDefinition = configurableListableBeanFactory.getBeanDefinition(string);
        beanDefinition.getPropertyValues().addPropertyValue(string2, string3);
    }

    public boolean hasPropertyOverridesFor(String string) {
        return this.beanNames.contains(string);
    }
}

