/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.support.MethodOverride;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ReplaceOverride
extends MethodOverride {
    private final String methodReplacerBeanName;
    private List typeIdentifiers = new LinkedList();

    public ReplaceOverride(String string, String string2) {
        super(string);
        Assert.notNull((Object)string, (String)"Method replacer bean name must not be null");
        this.methodReplacerBeanName = string2;
    }

    public String getMethodReplacerBeanName() {
        return this.methodReplacerBeanName;
    }

    public void addTypeIdentifier(String string) {
        this.typeIdentifiers.add(string);
    }

    public boolean matches(Method method) {
        if (!method.getName().equals(this.getMethodName())) {
            return false;
        }
        if (!this.isOverloaded()) {
            return true;
        }
        if (this.typeIdentifiers.size() != method.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < this.typeIdentifiers.size(); ++i) {
            String string = (String)this.typeIdentifiers.get(i);
            if (method.getParameterTypes()[i].getName().indexOf(string) != -1) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Replace override for method '" + this.getMethodName() + "; will call bean '" + this.methodReplacerBeanName + "'";
    }

    public boolean equals(Object object) {
        if (!(object instanceof ReplaceOverride) || !super.equals(object)) {
            return false;
        }
        ReplaceOverride replaceOverride = (ReplaceOverride)object;
        return ObjectUtils.nullSafeEquals((Object)this.methodReplacerBeanName, (Object)replaceOverride.methodReplacerBeanName) && ObjectUtils.nullSafeEquals((Object)this.typeIdentifiers, (Object)replaceOverride.typeIdentifiers);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object)this.methodReplacerBeanName);
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object)this.typeIdentifiers);
        return n;
    }
}

