/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private final Map beans = new HashMap();
    static /* synthetic */ Class class$org$springframework$beans$factory$FactoryBean;

    public void addBean(String string, Object object) {
        this.beans.put(string, object);
    }

    public Object getBean(String string) throws BeansException {
        String string2 = BeanFactoryUtils.transformedBeanName(string);
        Object v = this.beans.get(string2);
        if (v == null) {
            throw new NoSuchBeanDefinitionException(string2, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (BeanFactoryUtils.isFactoryDereference(string) && !(v instanceof FactoryBean)) {
            throw new BeanIsNotAFactoryException(string2, v.getClass());
        }
        if (v instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(string)) {
            try {
                return ((FactoryBean)v).getObject();
            }
            catch (Exception exception) {
                throw new BeanCreationException(string2, "FactoryBean threw exception on object creation", exception);
            }
        }
        return v;
    }

    public Object getBean(String string, Class clazz) throws BeansException {
        Object object = this.getBean(string);
        if (clazz != null && !clazz.isAssignableFrom(object.getClass())) {
            throw new BeanNotOfRequiredTypeException(string, clazz, object.getClass());
        }
        return object;
    }

    public boolean containsBean(String string) {
        return this.beans.containsKey(string);
    }

    public boolean isSingleton(String string) throws NoSuchBeanDefinitionException {
        Object object = this.getBean(string);
        return object instanceof FactoryBean && ((FactoryBean)object).isSingleton();
    }

    public boolean isPrototype(String string) throws NoSuchBeanDefinitionException {
        Object object = this.getBean(string);
        return object instanceof SmartFactoryBean && ((SmartFactoryBean)object).isPrototype() || object instanceof FactoryBean && !((FactoryBean)object).isSingleton();
    }

    public boolean isTypeMatch(String string, Class clazz) throws NoSuchBeanDefinitionException {
        Class clazz2 = this.getType(string);
        return clazz == null || clazz2 != null && clazz.isAssignableFrom(clazz2);
    }

    public Class getType(String string) throws NoSuchBeanDefinitionException {
        String string2 = BeanFactoryUtils.transformedBeanName(string);
        Object v = this.beans.get(string2);
        if (v == null) {
            throw new NoSuchBeanDefinitionException(string2, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        if (v instanceof FactoryBean && !BeanFactoryUtils.isFactoryDereference(string)) {
            return ((FactoryBean)v).getObjectType();
        }
        return v.getClass();
    }

    public String[] getAliases(String string) {
        return new String[0];
    }

    public boolean containsBeanDefinition(String string) {
        return this.beans.containsKey(string);
    }

    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray(this.beans.keySet());
    }

    public String[] getBeanNamesForType(Class clazz) {
        return this.getBeanNamesForType(clazz, true, true);
    }

    public String[] getBeanNamesForType(Class clazz, boolean bl, boolean bl2) {
        boolean bl3 = clazz != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = StaticListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(clazz);
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = this.beans.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.beans.get(string);
            if (v instanceof FactoryBean && !bl3) {
                Class clazz2;
                if (!bl2 || (clazz2 = ((FactoryBean)v).getObjectType()) == null || !clazz.isAssignableFrom(clazz2)) continue;
                arrayList.add(string);
                continue;
            }
            if (!clazz.isInstance(v)) continue;
            arrayList.add(string);
        }
        return StringUtils.toStringArray(arrayList);
    }

    public Map getBeansOfType(Class clazz) throws BeansException {
        return this.getBeansOfType(clazz, true, true);
    }

    public Map getBeansOfType(Class clazz, boolean bl, boolean bl2) throws BeansException {
        boolean bl3 = clazz != null && (class$org$springframework$beans$factory$FactoryBean == null ? (class$org$springframework$beans$factory$FactoryBean = StaticListableBeanFactory.class$("org.springframework.beans.factory.FactoryBean")) : class$org$springframework$beans$factory$FactoryBean).isAssignableFrom(clazz);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = this.beans.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Object v = entry.getValue();
            if (v instanceof FactoryBean && !bl3) {
                if (!bl2) continue;
                FactoryBean factoryBean = (FactoryBean)v;
                Class clazz2 = factoryBean.getObjectType();
                if (!bl && !factoryBean.isSingleton() || clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
                hashMap.put(string, this.getBean(string));
                continue;
            }
            if (!clazz.isInstance(v)) continue;
            if (bl3) {
                string = "&" + string;
            }
            hashMap.put(string, v);
        }
        return hashMap;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

