/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.net.SocketFactory;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.SlaveAddress;
import org.apache.derby.impl.store.replication.net.SocketConnection;

public class ReplicationMessageTransmit {
    private final int DEFAULT_MESSAGE_RESPONSE_TIMEOUT = 5000;
    private Thread msgReceiver = null;
    private final Object receiveSemaphore = new Object();
    private ReplicationMessage receivedMsg = null;
    private volatile boolean stopMessageReceiver = false;
    private final SlaveAddress slaveAddress;
    private SocketConnection socketConn;
    private String dbname;

    public ReplicationMessageTransmit(SlaveAddress slaveAddress) {
        this.slaveAddress = slaveAddress;
    }

    public void initConnection(int n, long l) throws PrivilegedActionException, IOException, StandardException, ClassNotFoundException {
        Socket socket = null;
        final int n2 = n;
        socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                SocketFactory socketFactory = SocketFactory.getDefault();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(ReplicationMessageTransmit.this.slaveAddress.getHostAddress(), ReplicationMessageTransmit.this.slaveAddress.getPortNumber());
                Socket socket = socketFactory.createSocket();
                socket.connect(inetSocketAddress, n2);
                return socket;
            }
        });
        socket.setKeepAlive(true);
        this.socketConn = new SocketConnection(socket);
        this.startMessageReceiverThread(this.dbname);
        this.brokerConnection(l);
    }

    public void tearDown() throws IOException {
        this.stopMessageReceiver = true;
        this.msgReceiver = null;
        if (this.socketConn != null) {
            this.socketConn.tearDown();
            this.socketConn = null;
        }
    }

    public void sendMessage(ReplicationMessage replicationMessage) throws IOException {
        this.checkSocketConnection();
        this.socketConn.writeMessage(replicationMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ReplicationMessage sendMessageWaitForReply(ReplicationMessage replicationMessage) throws IOException, StandardException {
        this.receivedMsg = null;
        this.checkSocketConnection();
        this.socketConn.writeMessage(replicationMessage);
        Object object = this.receiveSemaphore;
        synchronized (object) {
            try {
                this.receiveSemaphore.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.receivedMsg == null) {
            throw StandardException.newException("XRE04.U.2", this.dbname);
        }
        return this.receivedMsg;
    }

    private void brokerConnection(long l) throws IOException, StandardException, ClassNotFoundException {
        ReplicationMessage replicationMessage = new ReplicationMessage(0, new Long(1L));
        this.verifyMessageType(this.sendMessageWaitForReply(replicationMessage), 11);
        replicationMessage = new ReplicationMessage(1, new Long(l));
        this.verifyMessageType(this.sendMessageWaitForReply(replicationMessage), 11);
    }

    private boolean verifyMessageType(ReplicationMessage replicationMessage, int n) throws StandardException {
        if (replicationMessage.getType() == n) {
            return true;
        }
        if (replicationMessage.getType() == 12) {
            Object[] objectArray = (String[])replicationMessage.getMessage();
            throw StandardException.newException(objectArray[objectArray.length - 1], objectArray);
        }
        throw StandardException.newException("XRE03");
    }

    private void checkSocketConnection() throws IOException {
        if (this.socketConn == null) {
            throw new IOException("R012");
        }
    }

    private void startMessageReceiverThread(String string) {
        this.msgReceiver = new MasterReceiverThread(string);
        this.msgReceiver.setDaemon(true);
        this.msgReceiver.start();
    }

    private class MasterReceiverThread
    extends Thread {
        private final ReplicationMessage pongMsg;

        MasterReceiverThread(String string) {
            super("derby.master.receiver-" + string);
            this.pongMsg = new ReplicationMessage(14, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!ReplicationMessageTransmit.this.stopMessageReceiver) {
                try {
                    ReplicationMessage replicationMessage = this.readMessage();
                    switch (replicationMessage.getType()) {
                        case 13: {
                            ReplicationMessageTransmit.this.sendMessage(this.pongMsg);
                            break;
                        }
                        case 11: 
                        case 12: {
                            Object object = ReplicationMessageTransmit.this.receiveSemaphore;
                            synchronized (object) {
                                ReplicationMessageTransmit.this.receivedMsg = replicationMessage;
                                ReplicationMessageTransmit.this.receiveSemaphore.notify();
                                break;
                            }
                        }
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (IOException iOException) {
                    ReplicationMessageTransmit.this.stopMessageReceiver = true;
                    ReplicationMessageTransmit.this.msgReceiver = null;
                }
            }
        }

        private ReplicationMessage readMessage() throws ClassNotFoundException, IOException {
            ReplicationMessageTransmit.this.checkSocketConnection();
            return (ReplicationMessage)ReplicationMessageTransmit.this.socketConn.readMessage();
        }
    }
}

