/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import org.springframework.util.ClassUtils;

public class CustomizableThreadCreator {
    private final Object monitor = new Object();
    private String threadNamePrefix;
    private int threadPriority = 5;
    private boolean daemon = false;
    private ThreadGroup threadGroup;
    private int threadCount = 0;

    public CustomizableThreadCreator() {
        this(null);
    }

    public CustomizableThreadCreator(String string) {
        this.setThreadNamePrefix(string);
    }

    public void setThreadNamePrefix(String string) {
        this.threadNamePrefix = string != null ? string : this.getDefaultThreadNamePrefix();
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }

    public void setThreadPriority(int n) {
        this.threadPriority = n;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public void setDaemon(boolean bl) {
        this.daemon = bl;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setThreadGroupName(String string) {
        this.threadGroup = new ThreadGroup(string);
    }

    public void setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public Thread createThread(Runnable runnable) {
        Thread thread = new Thread(this.getThreadGroup(), runnable, this.nextThreadName());
        thread.setPriority(this.getThreadPriority());
        thread.setDaemon(this.isDaemon());
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String nextThreadName() {
        int n = 0;
        Object object = this.monitor;
        synchronized (object) {
            ++this.threadCount;
            n = this.threadCount;
        }
        return this.getThreadNamePrefix() + n;
    }

    protected String getDefaultThreadNamePrefix() {
        return ClassUtils.getShortName(this.getClass()) + "-";
    }
}

