/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BeanDefinitionHolder
implements BeanMetadataElement {
    private final BeanDefinition beanDefinition;
    private final String beanName;
    private final String[] aliases;

    public BeanDefinitionHolder(BeanDefinition beanDefinition, String string) {
        this(beanDefinition, string, null);
    }

    public BeanDefinitionHolder(BeanDefinition beanDefinition, String string, String[] stringArray) {
        Assert.notNull((Object)beanDefinition, (String)"BeanDefinition must not be null");
        Assert.notNull((Object)string, (String)"Bean name must not be null");
        this.beanDefinition = beanDefinition;
        this.beanName = string;
        this.aliases = stringArray;
    }

    public BeanDefinitionHolder(BeanDefinitionHolder beanDefinitionHolder) {
        Assert.notNull((Object)beanDefinitionHolder, (String)"BeanDefinitionHolder must not be null");
        this.beanDefinition = beanDefinitionHolder.getBeanDefinition();
        this.beanName = beanDefinitionHolder.getBeanName();
        this.aliases = beanDefinitionHolder.getAliases();
    }

    public BeanDefinition getBeanDefinition() {
        return this.beanDefinition;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public Object getSource() {
        return this.beanDefinition.getSource();
    }

    public String getShortDescription() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Bean definition with name '").append(this.beanName).append("'");
        if (this.aliases != null) {
            stringBuffer.append(" and aliases [").append(StringUtils.arrayToCommaDelimitedString((Object[])this.aliases)).append("]");
        }
        return stringBuffer.toString();
    }

    public String getLongDescription() {
        StringBuffer stringBuffer = new StringBuffer(this.getShortDescription());
        stringBuffer.append(": ").append(this.beanDefinition);
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getLongDescription();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BeanDefinitionHolder)) {
            return false;
        }
        BeanDefinitionHolder beanDefinitionHolder = (BeanDefinitionHolder)object;
        return this.beanDefinition.equals(beanDefinitionHolder.beanDefinition) && this.beanName.equals(beanDefinitionHolder.beanName) && ObjectUtils.nullSafeEquals((Object)this.aliases, (Object)beanDefinitionHolder.aliases);
    }

    public int hashCode() {
        int n = this.beanDefinition.hashCode();
        n = 29 * n + this.beanName.hashCode();
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object[])this.aliases);
        return n;
    }
}

