/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.enums;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.core.enums.AbstractCachingLabeledEnumResolver;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.util.Assert;

public class StaticLabeledEnumResolver
extends AbstractCachingLabeledEnumResolver {
    private static final StaticLabeledEnumResolver INSTANCE = new StaticLabeledEnumResolver();

    public static StaticLabeledEnumResolver instance() {
        return INSTANCE;
    }

    protected Set findLabeledEnums(Class clazz) {
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !clazz.isAssignableFrom(field.getType())) continue;
            try {
                Object object = field.get(null);
                Assert.isTrue(object instanceof LabeledEnum, "Field value must be a LabeledEnum instance");
                treeSet.add(object);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                this.logger.warn((Object)("Unable to access field value " + field), (Throwable)illegalAccessException);
            }
        }
        return treeSet;
    }
}

