/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.ObjectUtils;

public abstract class CollectionUtils {
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static List arrayToList(Object object) {
        return Arrays.asList(ObjectUtils.toObjectArray(object));
    }

    public static void mergeArrayIntoCollection(Object object, Collection collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Collection must not be null");
        }
        Object[] objectArray = ObjectUtils.toObjectArray(object);
        for (int i = 0; i < objectArray.length; ++i) {
            collection.add(objectArray[i]);
        }
    }

    public static void mergePropertiesIntoMap(Properties properties, Map map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                map.put(string, properties.getProperty(string));
            }
        }
    }

    public static boolean contains(Iterator iterator, Object object) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!ObjectUtils.nullSafeEquals(e, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean contains(Enumeration enumeration, Object object) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!ObjectUtils.nullSafeEquals(e, object)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsInstance(Collection collection, Object object) {
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e != object) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(Collection collection, Collection collection2) {
        if (CollectionUtils.isEmpty(collection) || CollectionUtils.isEmpty(collection2)) {
            return false;
        }
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstMatch(Collection collection, Collection collection2) {
        if (CollectionUtils.isEmpty(collection) || CollectionUtils.isEmpty(collection2)) {
            return null;
        }
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!collection.contains(e)) continue;
            return e;
        }
        return null;
    }

    public static Object findValueOfType(Collection collection, Class clazz) throws IllegalArgumentException {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class clazz2 = clazz != null ? clazz : (class$java$lang$Object == null ? (class$java$lang$Object = CollectionUtils.class$("java.lang.Object")) : class$java$lang$Object);
        Object var3_3 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!clazz2.isInstance(e)) continue;
            if (var3_3 != null) {
                throw new IllegalArgumentException("More than one value of type [" + clazz2.getName() + "] found");
            }
            var3_3 = e;
        }
        return var3_3;
    }

    public static Object findValueOfType(Collection collection, Class[] classArray) throws IllegalArgumentException {
        if (CollectionUtils.isEmpty(collection) || ObjectUtils.isEmpty(classArray)) {
            return null;
        }
        for (int i = 0; i < classArray.length; ++i) {
            Object object = CollectionUtils.findValueOfType(collection, classArray[i]);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public static boolean hasUniqueObject(Collection collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return false;
        }
        boolean bl = false;
        Object var2_2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!bl) {
                bl = true;
                var2_2 = e;
                continue;
            }
            if (var2_2 == e) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

