/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.processor;

import cn.com.voltronic.solar.beanbag.BeanBag;
import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.comusbprocessor.ParallSubProcessor;
import cn.com.voltronic.solar.configure.GlobalConfig;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.dao.DeviceDao;
import cn.com.voltronic.solar.dao.EnergyDao;
import cn.com.voltronic.solar.data.bean.ColumnChartItem;
import cn.com.voltronic.solar.data.bean.DataBeforeFault;
import cn.com.voltronic.solar.data.bean.DeviceBean;
import cn.com.voltronic.solar.data.bean.EnergyBean;
import cn.com.voltronic.solar.data.bean.EnergyData;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.exception.FaultHandler;
import cn.com.voltronic.solar.processor.Energyquery;
import cn.com.voltronic.solar.processor.WorkMonitor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.RunTools;
import cn.com.voltronic.solar.util.VolUtil;
import cn.com.voltronic.solar.webservice.WebServices;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.wimpi.modbus.util.BitVector;

public abstract class AbstractProcessor {
    public static Locale usLocale = new Locale("en", "US");
    public static final int POLL_TIME_PERIOD = 2000;
    public static final int ENERGY_TIME_PERIOD = 30000;
    protected ICommunicateDevice _handler;
    protected BeanBag _beanbag;
    protected AbstractControlModule _control;
    protected IProtocol _protocol;
    protected String _deviceName;
    protected float _fwVersion = 0.0f;
    protected String _deviceModel = "100";
    protected String _faultID = "00";
    protected boolean hasFault = false;
    protected int TRY_TIMES = 2;
    private boolean isFistQueryEnergy = true;
    protected Calendar currenttime = null;
    protected Calendar enerystarttime = null;
    protected long currentsystemtime = 0L;
    private volatile long timeinseconds = 0L;
    private Object timecountlock = new Integer(0);
    private boolean startQuerySelfTestResult = false;
    public boolean isfirstquery = true;
    public boolean isfirstenery = true;
    private WorkMonitor monitorThread;
    private Energyquery energyThread;
    public int reconnectTimes = 0;
    protected int _outputmode = 0;
    protected int _paralleltype = 0;
    protected int _parallelnum = 0;
    protected String _serialNo;
    protected HashMap<String, ParallSubProcessor> subMap = null;
    protected int parallkey = 0;
    protected String _processKey = "";
    private volatile boolean _closing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimeCount() {
        Object object = this.timecountlock;
        synchronized (object) {
            this.timeinseconds = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeCount(int value) {
        Object object = this.timecountlock;
        synchronized (object) {
            this.timeinseconds += (long)value;
        }
    }

    public String getDeviceName() {
        return this._deviceName;
    }

    public void setDeviceName(String name) {
        this._deviceName = name;
    }

    public int getParalleltype() {
        return this._paralleltype;
    }

    public boolean isParent(AbstractProcessor subProcess) {
        return this._paralleltype == 1 && this.subMap != null && this.subMap.containsKey(subProcess.getSerialNo());
    }

    protected String getValidate(String Command2) {
        int temp = 0;
        int i = 0;
        while (i < Command2.length()) {
            char ch = Command2.charAt(i);
            temp += ch;
            ++i;
        }
        String ascii = String.valueOf(temp &= 0xFF);
        int index = ascii.length();
        while (index < 3) {
            ascii = "0" + ascii;
            ++index;
        }
        return ascii;
    }

    public void startMonitor() throws Exception {
        if (this._closing || this._handler == null) {
            GlobalProcessors.removeProcessor(this.processorKey());
            return;
        }
        this.isFistQueryEnergy = true;
        String prodid = this.getProtocol().getProtocolID();
        String serialno = this.getProtocol().getSerialNo();
        int mpptNumber = this.getProtocol().getMpptTrackNumber();
        DeviceDao dao = new DeviceDao();
        if (!(serialno == null || "".equals(serialno) || serialno.equals("(NAK") || serialno.equals("(ACK") || prodid == null || "".equals(prodid))) {
            DeviceBean bean = new DeviceBean();
            bean.setProdid(prodid);
            bean.setSerialno(serialno);
            bean.setMpptnumber(1);
            bean.setModetype(this.getProtocol().getDeviceModel());
            bean.setModelname(this.getProtocol().getModelName());
            dao.InsertOrUpdateDevice(bean);
        }
        this.saveDevice();
        this.monitorThread = new WorkMonitor(this);
        this.monitorThread.setPriority(5);
        this.monitorThread.start();
        this.energyThread = new Energyquery(this);
        this.energyThread.setPriority(1);
        this.energyThread.start();
        GlobalProcessors.setCurrentProcesserIfExist(this.processorKey());
        GlobalConfig global = GlobalVariables.globalConfig;
        if (global.isAutoTime()) {
            boolean result = false;
            int times = 0;
            while (!result && times < 3) {
                Calendar calendar = Calendar.getInstance(usLocale);
                String year = ("" + calendar.get(1)).substring(2);
                int mon = calendar.get(2) + 1;
                String month = "";
                month = mon < 10 ? "0" + mon : "" + mon;
                String day = "";
                int da = calendar.get(5);
                day = da < 10 ? "0" + da : "" + da;
                String hour = "";
                int hou = calendar.get(11);
                hour = hou < 10 ? "0" + hou : "" + hou;
                String minute = "";
                int minut = calendar.get(12);
                minute = minut < 10 ? "0" + minut : "" + minut;
                String second = "";
                int secon = calendar.get(13);
                second = secon < 10 ? "0" + secon : "" + secon;
                StringBuffer parameter = new StringBuffer();
                parameter.append(year).append(month).append(day).append(hour).append(minute).append(second);
                if (parameter.toString().length() == 12) {
                    try {
                        result = this.executeControl("setCurrentTime", new String[]{parameter.toString()});
                    }
                    catch (Exception e) {
                        result = false;
                    }
                } else {
                    result = false;
                }
                ++times;
            }
        }
        if (this.getProtocol().getProtocolID().equals("P15") && this.getFWVersion() >= 0.9f || this.getProtocol().getProtocolID().equals("P16") && this.getFWVersion() >= 0.3f) {
            IComUSBHandler handler = (IComUSBHandler)((Object)this.getHandler());
            if (handler == null) {
                return;
            }
            int i = 0;
            while (i < 9) {
                try {
                    String parameter = "0" + i;
                    String qpihf = handler.excuteCommand("QPIHF" + parameter, true);
                    if (!("".equals(qpihf) || qpihf.equals("(NAK") || qpihf.startsWith("(00"))) {
                        String timeStr;
                        this._faultID = parameter;
                        String[] qpifsArr = qpihf.split(" ");
                        String faultstr = qpifsArr[0].substring(1);
                        int kind = VolUtil.parseInt(faultstr);
                        if (this.getProtocol().getProtocolID().equals("P16")) {
                            if (kind > 0 && kind < 28) {
                                DataBeforeFault data = new DataBeforeFault();
                                timeStr = qpifsArr[1];
                                data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                                data.setProdid("P16");
                                data.setSerialno(this.getProtocol().getSerialNo());
                                data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                                data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                                data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                                data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                                data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                                data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                                data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                                data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                                data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                                data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                                data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                                data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                                data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                                data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                                data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                                data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                                data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                                String runStatus = new String(qpifsArr[19]);
                                data.setRunStatus(runStatus);
                                FaultHandler.doFaultEvent(faultstr, data.getProdid(), data.getSerialno(), data);
                            }
                        } else if (kind > 0 && kind < 21) {
                            DataBeforeFault data = new DataBeforeFault();
                            timeStr = qpifsArr[1];
                            data.setTrandate(DateUtils.parseDate(timeStr, "yyyyMMddHHmmss"));
                            data.setProdid("P15");
                            data.setSerialno(this.getProtocol().getSerialNo());
                            data.setPvinputvoltage1(VolUtil.parseDouble(qpifsArr[2]));
                            data.setPvinputcurrent1(VolUtil.parseDouble(qpifsArr[3]));
                            data.setPvinputvoltage2(VolUtil.parseDouble(qpifsArr[4]));
                            data.setPvinputcurrent2(VolUtil.parseDouble(qpifsArr[5]));
                            data.setPvinputvoltage3(VolUtil.parseDouble(qpifsArr[6]));
                            data.setPvinputcurrent3(VolUtil.parseDouble(qpifsArr[7]));
                            data.setInverterVoltage(VolUtil.parseDouble(qpifsArr[8]));
                            data.setInverterCurrent(VolUtil.parseDouble(qpifsArr[9]));
                            data.setGridVoltage(VolUtil.parseDouble(qpifsArr[10]));
                            data.setGridFrequency(VolUtil.parseDouble(qpifsArr[11]));
                            data.setGridCurrent(VolUtil.parseDouble(qpifsArr[12]));
                            data.setOutputLoadPercent(VolUtil.parseInt(qpifsArr[13]));
                            data.setOutputLoadCurrent(VolUtil.parseDouble(qpifsArr[14]));
                            data.setOutputLoadVoltage(VolUtil.parseDouble(qpifsArr[15]));
                            data.setOutputLoadFrequency(VolUtil.parseDouble(qpifsArr[16]));
                            data.setBatteryVoltage(VolUtil.parseDouble(qpifsArr[17]));
                            data.setMaxTemperature(VolUtil.parseDouble(qpifsArr[18]));
                            String runStatus = new String(qpifsArr[19]);
                            data.setRunStatus(runStatus);
                            FaultHandler.doFaultEvent(faultstr, data.getProdid(), data.getSerialno(), data);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public void close() {
        this._closing = true;
        if (this.subMap != null) {
            for (AbstractProcessor abstractProcessor : this.subMap.values()) {
                if (abstractProcessor.getSerialNo().equalsIgnoreCase(this.getSerialNo())) continue;
                abstractProcessor.close();
            }
            this.subMap.clear();
        }
        if (this._paralleltype != 2 && this.getHandler() != null) {
            try {
                this.getHandler().close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this._handler = null;
        }
        GlobalProcessors.removeProcessor(this.processorKey());
    }

    public boolean isClosing() {
        return this._closing;
    }

    public AbstractProcessor(ICommunicateDevice handler, IProtocol protocol) {
        this._handler = handler;
        this._handler.setNotifyProcess(this);
        this._protocol = protocol;
        this.initBeanBag();
        this.initProtocol();
        this.initControlModule();
        this._protocol.initCommandMap();
        this._serialNo = this._protocol.getSerialNo();
    }

    public Calendar getEnergyBeginDate() {
        if (this.enerystarttime == null) {
            this.queryEnergyBeginDate();
        }
        return this.enerystarttime;
    }

    public abstract void queryEnergyBeginDate();

    public abstract boolean queryDefaultData();

    public abstract float queryFWVersion();

    public float getFWVersion() {
        return this._fwVersion;
    }

    public abstract boolean queryDeviceModel();

    public abstract String getDeviceMode();

    public String processorKey() {
        if (this._processKey.isEmpty()) {
            this._processKey = this._outputmode == 0 ? String.valueOf(this.getDeviceName()) + "_" + this.getProtocol().getSerialNo() : (this._outputmode == 1 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_PARALLEL" : (this._outputmode == 2 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_R PHASE" : (this._outputmode == 3 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_S PHASE" : (this._outputmode == 4 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_T PHASE" : String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo()))));
        }
        return this._processKey;
    }

    protected abstract void initBeanBag();

    public BeanBag getBeanBag() {
        return this._beanbag;
    }

    public ICommunicateDevice getHandler() {
        return this._handler;
    }

    protected abstract void initControlModule();

    public abstract void querySelfTestResult();

    public abstract boolean supportSelfTest();

    public AbstractControlModule getControlModule() {
        return this._control;
    }

    public abstract void initProtocol();

    public IProtocol getProtocol() {
        return this._protocol;
    }

    public boolean executeControl(String commandMethod, Object[] paras) {
        return this._control.execute(commandMethod, paras);
    }

    public boolean pollQuery() {
        this.queryDateTimeandKeep();
        if (this.currenttime != null) {
            this.isfirstquery = false;
        }
        return this.currenttime != null;
    }

    private void queryDateTimeandKeep() {
        this.currenttime = this.queryCurrentTime();
        this.currentsystemtime = System.currentTimeMillis();
        this.resetTimeCount();
    }

    public boolean pollQueryStatus() {
        return this.currenttime != null;
    }

    public abstract boolean queryMachineInfo();

    public abstract Calendar queryCurrentTime();

    public abstract double queryEnergyTotal();

    public abstract double queryEnergyYear(int var1) throws Exception;

    public abstract double queryEnergyMonth(int var1, int var2) throws Exception;

    public abstract double queryEnergyDay(Calendar var1) throws Exception;

    public abstract double queryEnergyHour(Calendar var1, int var2) throws Exception;

    public abstract boolean queryCapability();

    public abstract boolean queryConfigData();

    public boolean executeQuery(String queryMethod) {
        return (Boolean)RunTools.runMethod((Object)this, queryMethod, null);
    }

    public void setCurrentTime(Calendar ca) {
        this.currenttime = ca;
    }

    public double parseDoubleV(String str) throws Exception {
        return Double.parseDouble(str);
    }

    public Calendar getCurrentTime() {
        if (this.currenttime == null) {
            this.queryDateTimeandKeep();
        }
        Calendar ca = null;
        if (this.currenttime != null) {
            if (Math.abs(System.currentTimeMillis() - this.currentsystemtime - this.timeinseconds * 1000L) > 60000L) {
                this.queryDateTimeandKeep();
            }
            if (this.currenttime != null) {
                ca = (Calendar)this.currenttime.clone();
                long diff = System.currentTimeMillis() - this.currentsystemtime;
                ca.add(14, (int)diff);
            }
        }
        return ca;
    }

    public final void refreshWarningStatus(BitVector warnStatus, BitVector oldwarnings, int index, String eventCode, WorkInfo workinfo) {
        if (warnStatus.getBit(index)) {
            EventsHandler.handleEvent(workinfo.getProdid(), workinfo.getSerialno(), workinfo.getCurrentTime(), eventCode);
            workinfo.addWarning(eventCode);
        }
    }

    public boolean energyqueryCompleted(double value) {
        long lngvalue = (long)value;
        String hex = String.format("%X", lngvalue);
        return !hex.equals("FEFFFFFF");
    }

    public boolean energyquerySuccess(double value) {
        long lngvalue = (long)value;
        String hex = String.format("%X", lngvalue);
        return !hex.equals("FFFFFFFF") && !hex.equals("FEFFFFFF");
    }

    public void transactEnergyFromChangetime(Calendar newtime) {
        EnergyDao dao = new EnergyDao();
        dao.transactEnergyFromChangetime(this.getProtocol().getSerialNo(), newtime);
    }

    public boolean pollEnergy() {
        String prodid = this._protocol.getProtocolID();
        if (prodid.equals("P18") || prodid.equals("P1834K") || prodid.equals("P1812K")) {
            return this.doPoolEnergyForP18();
        }
        if (prodid.equals("P1730K")) {
            return this.doPoolEnergyForP1730K();
        }
        return this.doPoolEnergy();
    }

    private boolean doPoolEnergy() {
        WebServices web;
        Calendar starttime;
        boolean result = true;
        if (this.enerystarttime == null && (starttime = this.getEnergyBeginDate()) != null && (web = new WebServices()).doEnergyBeginDate(this.getProtocol().getProtocolID(), this.getProtocol().getSerialNo(), starttime)) {
            return false;
        }
        try {
            EnergyData data = (EnergyData)this.getBeanBag().getBean("energydata");
            String processorKey = this.processorKey();
            WebServices web2 = new WebServices();
            Calendar currentDate = this.getCurrentTime();
            if (currentDate != null) {
                this.isfirstenery = false;
                double currentD = 0.0;
                double currentM = 0.0;
                double currentY = 0.0;
                data.setHorizontalTitleH(DateUtils.getFormatDate(currentDate.getTime(), DateUtils.getDateFormat(true)));
                data.setHorizontalTitleD(DateUtils.getFormatDate(currentDate.getTime(), DateUtils.getDateFormat(false)));
                data.setHorizontalTitleM("" + currentDate.get(1));
                data.setHorizontalTitleY("");
                List<EnergyBean> hours = web2.queryHourwithoutPrice(processorKey, this.getProtocol().getSerialNo(), currentDate, 0, currentDate, 23, this.isFistQueryEnergy);
                ArrayList<ColumnChartItem> viewHours = new ArrayList<ColumnChartItem>();
                double maxH = 0.0;
                int i = 0;
                while (i < hours.size()) {
                    viewHours.add(new ColumnChartItem(data.getHorizontalTitleH(), "" + i, "" + hours.get(i).getQuantity()));
                    currentD += hours.get(i).getQuantity();
                    if (hours.get(i).getQuantity() > maxH) {
                        maxH = hours.get(i).getQuantity();
                    }
                    ++i;
                }
                data.setEnergyInD(VolUtil.round(currentD, 3));
                data.setEnergyHours(viewHours);
                if (maxH <= 0.0) {
                    maxH = 100.0;
                }
                if (maxH == 0.001) {
                    maxH *= 2.0;
                }
                data.setMaxH(VolUtil.round(maxH + maxH * 0.35, 3));
                List<EnergyBean> days = web2.queryDaywithoutPrice(processorKey, this.getProtocol().getSerialNo(), DateUtils.getStartofMonth(currentDate), DateUtils.getEndofMonth(currentDate), this.isFistQueryEnergy);
                ArrayList<ColumnChartItem> viewDays = new ArrayList<ColumnChartItem>();
                double maxD = 0.0;
                int i2 = 1;
                while (i2 <= days.size()) {
                    if (days.get(i2 - 1).getTrandate().equals(DateUtils.getShortdate(currentDate))) {
                        viewDays.add(new ColumnChartItem(data.getHorizontalTitleD(), "" + i2, "" + VolUtil.round(currentD, 3)));
                        currentM += currentD;
                        if (VolUtil.round(currentD, 3) > maxD) {
                            maxD = VolUtil.round(currentD, 3);
                        }
                    } else {
                        viewDays.add(new ColumnChartItem(data.getHorizontalTitleD(), "" + i2, "" + days.get(i2 - 1).getQuantity()));
                        currentM += days.get(i2 - 1).getQuantity();
                        if (days.get(i2 - 1).getQuantity() > maxD) {
                            maxD = days.get(i2 - 1).getQuantity();
                        }
                    }
                    ++i2;
                }
                data.setEnergyInM(VolUtil.round(currentM, 3));
                data.setEnergyDays(viewDays);
                if (maxD <= 0.0) {
                    maxD = 100.0;
                }
                if (maxD == 0.001) {
                    maxD *= 2.0;
                }
                data.setMaxD(VolUtil.round(maxD + maxD * 0.35, 3));
                List<EnergyBean> months = web2.queryMonthwithoutPrice(processorKey, this.getProtocol().getSerialNo(), currentDate.get(1), 1, currentDate.get(1), 12, this.isFistQueryEnergy);
                ArrayList<ColumnChartItem> viewMonths = new ArrayList<ColumnChartItem>();
                String currentYearMonth = String.format("%4d%02d", currentDate.get(1), currentDate.get(2) + 1);
                double maxM = 0.0;
                int i3 = 1;
                while (i3 <= months.size()) {
                    if (currentYearMonth.equals(months.get(i3 - 1).getYearmonth())) {
                        viewMonths.add(new ColumnChartItem(data.getHorizontalTitleM(), "" + i3, "" + VolUtil.round(currentM, 3)));
                        currentY += currentM;
                        if (VolUtil.round(currentM, 3) > maxM) {
                            maxM = VolUtil.round(currentM, 3);
                        }
                    } else {
                        viewMonths.add(new ColumnChartItem(data.getHorizontalTitleM(), "" + i3, "" + months.get(i3 - 1).getQuantity()));
                        currentY += months.get(i3 - 1).getQuantity();
                        if (months.get(i3 - 1).getQuantity() > maxM) {
                            maxM = months.get(i3 - 1).getQuantity();
                        }
                    }
                    ++i3;
                }
                data.setEnergyInY(VolUtil.round(currentY, 3));
                data.setEnergyMonths(viewMonths);
                if (maxM <= 0.0) {
                    maxM = 100.0;
                }
                if (maxM == 0.001) {
                    maxM *= 2.0;
                }
                data.setMaxM(VolUtil.round(maxM + maxM * 0.35, 3));
                List<EnergyBean> years = web2.queryYearwithoutPrice(processorKey, this.getProtocol().getSerialNo(), currentDate.get(1), currentDate.get(1), this.isFistQueryEnergy);
                ArrayList<ColumnChartItem> viewYears = new ArrayList<ColumnChartItem>();
                int currentYear = currentDate.get(1);
                double maxY = 0.0;
                int i4 = 0;
                while (i4 < years.size()) {
                    if (currentYear == years.get(i4).getYear()) {
                        viewYears.add(new ColumnChartItem(data.getHorizontalTitleY(), "" + years.get(i4).getYear(), "" + VolUtil.round(currentY, 3)));
                        if (VolUtil.round(currentY, 3) > maxY) {
                            maxY = VolUtil.round(currentY, 3);
                        }
                    } else {
                        viewYears.add(new ColumnChartItem(data.getHorizontalTitleY(), "" + years.get(i4).getYear(), "" + years.get(i4).getQuantity()));
                        if (years.get(i4).getQuantity() > maxY) {
                            maxY = years.get(i4).getQuantity();
                        }
                    }
                    ++i4;
                }
                data.setEnergyYears(viewYears);
                if (maxY <= 0.0) {
                    maxY = 100.0;
                }
                if (maxY == 0.001) {
                    maxY *= 2.0;
                }
                data.setMaxY(VolUtil.round(maxY + maxY * 0.35, 3));
                this.isFistQueryEnergy = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private boolean doPoolEnergyForP1730K() {
        boolean result = true;
        try {
            EnergyData data = (EnergyData)this.getBeanBag().getBean("energydata");
            String processorKey = this.processorKey();
            WebServices web = new WebServices();
            Calendar currentDate = this.getCurrentTime();
            if (currentDate != null) {
                this.isfirstenery = false;
                double currentD = 0.0;
                double currentM = 0.0;
                double currentY = 0.0;
                double energyTl = 0.0;
                data.setHorizontalTitleH(DateUtils.getFormatDate(currentDate.getTime(), DateUtils.getDateFormat(true)));
                data.setHorizontalTitleD(DateUtils.getFormatDate(currentDate.getTime(), DateUtils.getDateFormat(false)));
                data.setHorizontalTitleM("" + currentDate.get(1));
                data.setHorizontalTitleY("");
                List<EnergyBean> days = web.queryDaywithoutPriceForP1730K(processorKey, this.getProtocol().getSerialNo(), DateUtils.getStartofMonth(currentDate), DateUtils.getEndofMonth(currentDate), this.isFistQueryEnergy);
                ArrayList<ColumnChartItem> viewDays = new ArrayList<ColumnChartItem>();
                double maxD = 0.0;
                int i = 1;
                while (i <= days.size()) {
                    if (days.get(i - 1).getTrandate().equals(DateUtils.getShortdate(currentDate))) {
                        currentD = days.get(i - 1).getQuantity();
                        currentM += currentD;
                        data.setEnergyInD(VolUtil.round(currentD, 3));
                        viewDays.add(new ColumnChartItem(data.getHorizontalTitleD(), "" + i, "" + VolUtil.round(currentD, 3)));
                        if (VolUtil.round(currentD, 3) > maxD) {
                            maxD = VolUtil.round(currentD, 3);
                        }
                    } else {
                        currentM += days.get(i - 1).getQuantity();
                        viewDays.add(new ColumnChartItem(data.getHorizontalTitleD(), "" + i, "" + days.get(i - 1).getQuantity()));
                        if (days.get(i - 1).getQuantity() > maxD) {
                            maxD = days.get(i - 1).getQuantity();
                        }
                    }
                    ++i;
                }
                data.setEnergyDays(viewDays);
                if (maxD <= 0.0) {
                    maxD = 100.0;
                }
                if (maxD == 0.001) {
                    maxD *= 2.0;
                }
                data.setMaxD(VolUtil.round(maxD + maxD * 0.35, 3));
                List<EnergyBean> months = web.queryMonthwithoutPriceForP1730K(processorKey, this.getProtocol().getSerialNo(), currentDate.get(1), 1, currentDate.get(1), 12, this.isFistQueryEnergy);
                ArrayList<ColumnChartItem> viewMonths = new ArrayList<ColumnChartItem>();
                String currentYearMonth = String.format("%4d%02d", currentDate.get(1), currentDate.get(2) + 1);
                double maxM = 0.0;
                int i2 = 1;
                while (i2 <= months.size()) {
                    if (currentYearMonth.equals(months.get(i2 - 1).getYearmonth())) {
                        currentY += currentM;
                        data.setEnergyInM(VolUtil.round(currentM, 3));
                        viewMonths.add(new ColumnChartItem(data.getHorizontalTitleM(), "" + i2, "" + currentM));
                        if (VolUtil.round(currentM, 3) > maxM) {
                            maxM = VolUtil.round(currentM, 3);
                        }
                    } else {
                        currentY += months.get(i2 - 1).getQuantity();
                        viewMonths.add(new ColumnChartItem(data.getHorizontalTitleM(), "" + i2, "" + months.get(i2 - 1).getQuantity()));
                        if (months.get(i2 - 1).getQuantity() > maxM) {
                            maxM = months.get(i2 - 1).getQuantity();
                        }
                    }
                    ++i2;
                }
                data.setEnergyMonths(viewMonths);
                if (maxM <= 0.0) {
                    maxM = 100.0;
                }
                if (maxM == 0.001) {
                    maxM *= 2.0;
                }
                data.setMaxM(maxM + maxM * 0.35);
                int startyear = currentDate.get(1) - 9;
                if (startyear < 2016) {
                    startyear = 2016;
                }
                List<EnergyBean> years = web.queryYearwithoutPriceForP1730K(processorKey, this.getProtocol().getSerialNo(), startyear, currentDate.get(1), this.isFistQueryEnergy);
                int firstEnergyYear = currentDate.get(1);
                int i3 = 0;
                while (i3 < years.size()) {
                    if (years.get(i3).getQuantity() > 0.0) {
                        firstEnergyYear = years.get(i3).getYear();
                        break;
                    }
                    ++i3;
                }
                ArrayList<ColumnChartItem> viewYears = new ArrayList<ColumnChartItem>();
                int currentYear = currentDate.get(1);
                double maxY = 0.0;
                int i4 = 0;
                while (i4 < years.size()) {
                    if (years.get(i4).getYear() >= firstEnergyYear) {
                        if (currentYear == years.get(i4).getYear()) {
                            data.setEnergyInY(VolUtil.round(currentY, 3));
                            viewYears.add(new ColumnChartItem(data.getHorizontalTitleY(), "" + years.get(i4).getYear(), "" + VolUtil.round(currentY, 3)));
                            if (VolUtil.round(currentY, 3) > maxY) {
                                maxY = VolUtil.round(currentY, 3);
                            }
                        } else {
                            viewYears.add(new ColumnChartItem(data.getHorizontalTitleY(), "" + years.get(i4).getYear(), "" + years.get(i4).getQuantity()));
                            if (years.get(i4).getQuantity() > maxY) {
                                maxY = years.get(i4).getQuantity();
                            }
                        }
                    }
                    ++i4;
                }
                data.setEnergyYears(viewYears);
                if (maxY <= 0.0) {
                    maxY = 100.0;
                }
                if (maxY == 0.001) {
                    maxY *= 2.0;
                }
                data.setMaxY(maxY + maxY * 0.35);
                energyTl = this.queryEnergyTotal();
                energyTl = VolUtil.round(energyTl * 0.001, 3);
                data.setEnergyTotal(energyTl);
                this.isFistQueryEnergy = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private boolean doPoolEnergyForP18() {
        boolean result = true;
        try {
            EnergyData data = (EnergyData)this.getBeanBag().getBean("energydata");
            String processorKey = this.processorKey();
            WebServices web = new WebServices();
            Calendar currentDate = this.getCurrentTime();
            if (currentDate != null) {
                this.isfirstenery = false;
                double currentD = 0.0;
                double currentM = 0.0;
                double currentY = 0.0;
                double energyTl = 0.0;
                data.setHorizontalTitleH(DateUtils.getFormatDate(currentDate.getTime(), DateUtils.getDateFormat(true)));
                data.setHorizontalTitleD(DateUtils.getFormatDate(currentDate.getTime(), DateUtils.getDateFormat(false)));
                data.setHorizontalTitleM("" + currentDate.get(1));
                data.setHorizontalTitleY("");
                List<EnergyBean> days = web.queryDaywithoutPriceForP18(processorKey, this.getProtocol().getSerialNo(), DateUtils.getStartofMonth(currentDate), DateUtils.getEndofMonth(currentDate), this.isFistQueryEnergy);
                ArrayList<ColumnChartItem> viewDays = new ArrayList<ColumnChartItem>();
                double maxD = 0.0;
                int i = 1;
                while (i <= days.size()) {
                    if (days.get(i - 1).getTrandate().equals(DateUtils.getShortdate(currentDate))) {
                        currentD = days.get(i - 1).getQuantity();
                        currentM += currentD;
                        data.setEnergyInD(VolUtil.round(currentD, 3));
                        viewDays.add(new ColumnChartItem(data.getHorizontalTitleD(), "" + i, "" + VolUtil.round(currentD, 3)));
                        if (VolUtil.round(currentD, 3) > maxD) {
                            maxD = VolUtil.round(currentD, 3);
                        }
                    } else {
                        currentM += days.get(i - 1).getQuantity();
                        viewDays.add(new ColumnChartItem(data.getHorizontalTitleD(), "" + i, "" + days.get(i - 1).getQuantity()));
                        if (days.get(i - 1).getQuantity() > maxD) {
                            maxD = days.get(i - 1).getQuantity();
                        }
                    }
                    ++i;
                }
                data.setEnergyDays(viewDays);
                if (maxD <= 0.0) {
                    maxD = 100.0;
                }
                if (maxD == 0.001) {
                    maxD *= 2.0;
                }
                data.setMaxD(VolUtil.round(maxD + maxD * 0.35, 3));
                List<EnergyBean> months = web.queryMonthwithoutPriceForP18(processorKey, this.getProtocol().getSerialNo(), currentDate.get(1), 1, currentDate.get(1), 12, this.isFistQueryEnergy);
                ArrayList<ColumnChartItem> viewMonths = new ArrayList<ColumnChartItem>();
                String currentYearMonth = String.format("%4d%02d", currentDate.get(1), currentDate.get(2) + 1);
                double maxM = 0.0;
                int i2 = 1;
                while (i2 <= months.size()) {
                    if (currentYearMonth.equals(months.get(i2 - 1).getYearmonth())) {
                        currentY += currentM;
                        data.setEnergyInM(VolUtil.round(currentM, 3));
                        viewMonths.add(new ColumnChartItem(data.getHorizontalTitleM(), "" + i2, "" + currentM));
                        if (VolUtil.round(currentM, 3) > maxM) {
                            maxM = VolUtil.round(currentM, 3);
                        }
                    } else {
                        currentY += months.get(i2 - 1).getQuantity();
                        viewMonths.add(new ColumnChartItem(data.getHorizontalTitleM(), "" + i2, "" + months.get(i2 - 1).getQuantity()));
                        if (months.get(i2 - 1).getQuantity() > maxM) {
                            maxM = months.get(i2 - 1).getQuantity();
                        }
                    }
                    ++i2;
                }
                data.setEnergyMonths(viewMonths);
                if (maxM <= 0.0) {
                    maxM = 100.0;
                }
                if (maxM == 0.001) {
                    maxM *= 2.0;
                }
                data.setMaxM(maxM + maxM * 0.35);
                int startyear = currentDate.get(1) - 9;
                if (startyear < 2016) {
                    startyear = 2016;
                }
                List<EnergyBean> years = web.queryYearwithoutPriceForP18(processorKey, this.getProtocol().getSerialNo(), startyear, currentDate.get(1), this.isFistQueryEnergy);
                int firstEnergyYear = currentDate.get(1);
                int i3 = 0;
                while (i3 < years.size()) {
                    if (years.get(i3).getQuantity() > 0.0) {
                        firstEnergyYear = years.get(i3).getYear();
                        break;
                    }
                    ++i3;
                }
                ArrayList<ColumnChartItem> viewYears = new ArrayList<ColumnChartItem>();
                int currentYear = currentDate.get(1);
                double maxY = 0.0;
                int i4 = 0;
                while (i4 < years.size()) {
                    if (years.get(i4).getYear() >= firstEnergyYear) {
                        if (currentYear == years.get(i4).getYear()) {
                            data.setEnergyInY(VolUtil.round(currentY, 3));
                            viewYears.add(new ColumnChartItem(data.getHorizontalTitleY(), "" + years.get(i4).getYear(), "" + VolUtil.round(currentY, 3)));
                            if (VolUtil.round(currentY, 3) > maxY) {
                                maxY = VolUtil.round(currentY, 3);
                            }
                        } else {
                            viewYears.add(new ColumnChartItem(data.getHorizontalTitleY(), "" + years.get(i4).getYear(), "" + years.get(i4).getQuantity()));
                            if (years.get(i4).getQuantity() > maxY) {
                                maxY = years.get(i4).getQuantity();
                            }
                        }
                    }
                    ++i4;
                }
                data.setEnergyYears(viewYears);
                if (maxY <= 0.0) {
                    maxY = 100.0;
                }
                if (maxY == 0.001) {
                    maxY *= 2.0;
                }
                data.setMaxY(maxY + maxY * 0.35);
                energyTl = this.queryEnergyTotal();
                energyTl = VolUtil.round(energyTl * 0.001, 3);
                data.setEnergyTotal(energyTl);
                this.isFistQueryEnergy = false;
            }
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public void setThreadPriority(int priority) {
        if (this.monitorThread != null) {
            this.monitorThread.setPriority(priority);
        }
        if (priority == 10) {
            if (this.energyThread != null) {
                this.energyThread.setPriority(priority);
            }
        } else if (this.energyThread != null) {
            this.energyThread.setPriority(1);
        }
    }

    public int getThreadPriority() {
        int kmoniter = 5;
        int kenergy = 5;
        if (this.monitorThread != null) {
            kmoniter = this.monitorThread.getPriority();
        }
        if (this.energyThread != null) {
            kenergy = this.energyThread.getPriority();
        }
        if (kmoniter == 10 || kenergy == 10) {
            return 10;
        }
        return 5;
    }

    public boolean isStartQuerySelfTestResult() {
        return this.startQuerySelfTestResult;
    }

    public void setStartQuerySelfTestResult(boolean startQuerySelfTestResult) {
        this.startQuerySelfTestResult = startQuerySelfTestResult;
    }

    public void setParallKey(int key) {
        this.parallkey = key;
    }

    public int getParallKey() {
        return this.parallkey;
    }

    public String reGenProcesorKey() {
        this._processKey = this._outputmode == 0 ? String.valueOf(this.getDeviceName()) + "_" + this.getProtocol().getSerialNo() : (this._outputmode == 1 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_PARALLEL" : (this._outputmode == 2 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_R PHASE" : (this._outputmode == 3 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_S PHASE" : (this._outputmode == 4 ? String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo() + "_T PHASE" : String.valueOf(this.getDeviceName()) + "_" + this.getSerialNo()))));
        return this._processKey;
    }

    public void saveDevice() {
        String prodid = this.getProtocol().getProtocolID();
        String serialno = this.getSerialNo();
        DeviceDao dao = new DeviceDao();
        if (!(serialno == null || "".equals(serialno) || serialno.equals("(NAK") || serialno.equals("(ACK") || prodid == null || "".equals(prodid))) {
            DeviceBean bean = new DeviceBean();
            bean.setProdid(prodid);
            bean.setSerialno(serialno);
            bean.setMpptnumber(1);
            bean.setModetype("00");
            bean.setModelname(this.getProtocol().getModelName());
            bean.setParallel(this._outputmode);
            this.subMap = new HashMap();
            dao.InsertOrUpdateDevice(bean);
        }
    }

    public String getSerialNo() {
        return this._serialNo;
    }

    public void setSerialNo(String serialno) {
        this._serialNo = serialno;
    }

    public int getOutputmode() {
        return this._outputmode;
    }

    public void setOutputmode(int _outputmode) {
        this._outputmode = _outputmode;
    }
}

