/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.protocol;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.data.bean.AutoComboBoxItem;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.AutoMenuItem;
import cn.com.voltronic.solar.data.bean.AutoMenuList;
import cn.com.voltronic.solar.data.bean.AutoMenuOne;
import cn.com.voltronic.solar.data.bean.AutoMenuTwo;
import cn.com.voltronic.solar.data.bean.AutoRadioItem;
import cn.com.voltronic.solar.data.bean.AutoSpinnerItem;
import cn.com.voltronic.solar.data.bean.BaseInfo;
import cn.com.voltronic.solar.data.bean.ComboBoxParameter;
import cn.com.voltronic.solar.data.bean.CommandParameterMap;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.ControlRelation;
import cn.com.voltronic.solar.data.bean.EnableSpinnerParameter;
import cn.com.voltronic.solar.data.bean.HistoryChart;
import cn.com.voltronic.solar.data.bean.HistoryData;
import cn.com.voltronic.solar.data.bean.HistoryDataChartColumns;
import cn.com.voltronic.solar.data.bean.HistoryDataColumns;
import cn.com.voltronic.solar.data.bean.HistoryFaultDataColumns;
import cn.com.voltronic.solar.data.bean.MoreInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.PurchaseInfo;
import cn.com.voltronic.solar.data.bean.RadioParameter;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.data.bean.RestoreInfo;
import cn.com.voltronic.solar.data.bean.SpinnerParameter;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.VolUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class P18
implements IProtocol {
    public Logger logger = Logger.getLogger(P18.class);
    protected static final int THREE_K = 3000;
    protected static final int FOUR_K = 4000;
    protected static final int FIVE_K = 5000;
    protected String serialNo = "";
    protected String modelName = "";
    protected String modelType = "01";
    protected int outputMode = 0;
    private CommandParameterMap map = new CommandParameterMap();
    private List<ControlRelation> relalist = new ArrayList<ControlRelation>();

    @Override
    public boolean matchProtocol(Object handler) {
        if (handler instanceof IComUSBHandler) {
            IComUSBHandler _handler = (IComUSBHandler)handler;
            return this.doComUSB(_handler);
        }
        return false;
    }

    private boolean doComUSB(IComUSBHandler handler) {
        handler.setUseCRC(true);
        String qPI = handler.excuteSimpleCommand("PI");
        if (StringUtils.isEmpty((String)qPI) || !qPI.startsWith("18")) {
            return false;
        }
        String qID = handler.getSerialNo();
        if (StringUtils.isEmpty((String)qID)) {
            return false;
        }
        this.serialNo = qID;
        String pPIRI = handler.excuteCommand("PIRI", true);
        if (StringUtils.isEmpty((String)pPIRI)) {
            return false;
        }
        String[] piri = pPIRI.split(",");
        this.outputMode = VolUtil.parseInt(piri[22]);
        int acOutputRatingApparentPower = VolUtil.parseInt(piri[5]);
        return acOutputRatingApparentPower >= 5000;
    }

    @Override
    public String getProtocolID() {
        return "P18";
    }

    @Override
    public BaseInfo getBaseInfo() {
        BaseInfo baseInfo = new BaseInfo();
        ArrayList<AutoLabelItem> item = new ArrayList<AutoLabelItem>();
        item.add(new AutoLabelItem("message.pvInputVoltage1[:]", "{workInfo.getPvInputVoltage1}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower1[:]", "{workInfo.getPvInputPower1}", "W"));
        item.add(new AutoLabelItem("message.pvInputVoltage2[:]", "{workInfo.getPvInputVoltage2}", "V"));
        item.add(new AutoLabelItem("message.pvInputPower2[:]", "{workInfo.getPvInputPower2}", "W"));
        item.add(new AutoLabelItem("message.gridVoltageR[:]", "{workInfo.getGridVoltageR}", "V"));
        item.add(new AutoLabelItem("message.gridFrequency[:]", "{workInfo.getGridFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.batteryVoltage[:]", "{workInfo.getBatteryVoltage}", "V"));
        item.add(new AutoLabelItem("message.batteryCapacity[:]", "{workInfo.getBatteryCapacity}", "%"));
        item.add(new AutoLabelItem("message.BatteryChargingCurrent[:]", "{workInfo.getChargingCurrent}", "A"));
        item.add(new AutoLabelItem("message.BatteryDischargeCurrent[:]", "{workInfo.getDisChargingCurrent}", "A"));
        item.add(new AutoLabelItem("message.gridOutputVoltage[:]", "{workInfo.getAcOutputVoltageR}", "V"));
        item.add(new AutoLabelItem("message.acOutputFreq[:]", "{workInfo.getAcOutputFrequency}", "Hz"));
        item.add(new AutoLabelItem("message.acOutputApperentPower[:]", "{workInfo.getAcOutputApperentPowerR}", "VA"));
        item.add(new AutoLabelItem("message.acOutputActivePower[:]", "{workInfo.getAcOutputActivePowerR}", "W"));
        item.add(new AutoLabelItem("message.loadpercent[:]", "{workInfo.getOutputLoadPercent}", "%"));
        if (this.outputMode == 1) {
            item.add(new AutoLabelItem("message.totalchargingcurrent[:]", "{workInfo.getTotalBatteryChargingCurrent}", "A"));
            item.add(new AutoLabelItem("message.totaloutputapparentpower[:]", "{workInfo.getTotalACOutputApparentPower}", "VA"));
            item.add(new AutoLabelItem("message.totaloutputactivepower[:]", "{workInfo.getTotalACOutputActivePower}", "W"));
            item.add(new AutoLabelItem("message.totaloutputpercent[:]", "{workInfo.getTotalOutputLoadPercent}", "%"));
        }
        baseInfo.setBaseInfoList(item);
        return baseInfo;
    }

    @Override
    public CommandParameterMap getCommandMap() {
        return this.map;
    }

    @Override
    public String getDSPVersion() {
        return null;
    }

    @Override
    public String getDeviceModel() {
        return null;
    }

    @Override
    public EnableSpinnerParameter getEnableSpinnerParameter() {
        return null;
    }

    @Override
    public SpinnerParameter getFactoryParameter() {
        return null;
    }

    @Override
    public HistoryDataChartColumns getHistoryChartColumns() {
        HistoryDataChartColumns columns = new HistoryDataChartColumns();
        ArrayList<HistoryChart> list = new ArrayList<HistoryChart>();
        list.add(new HistoryChart("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputPower1", "{workInfo.getPvInputPower1}", 3000.0, "W", true));
        list.add(new HistoryChart("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", 200.0, "V", true));
        list.add(new HistoryChart("message.pvInputPower2", "{workInfo.getPvInputPower2}", 3000.0, "W", true));
        list.add(new HistoryChart("message.gridVoltageR", "{workInfo.getGridVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.gridFrequency", "{workInfo.getGridFrequency}", 70.0, "Hz", true));
        list.add(new HistoryChart("message.batteryVoltage", "{workInfo.getBatteryVoltage}", 100.0, "V", true));
        list.add(new HistoryChart("message.batteryCapacity", "{workInfo.getBatteryCapacity}", 100.0, "%", true));
        list.add(new HistoryChart("message.BatteryChargingCurrent", "{workInfo.getChargingCurrent}", 250.0, "A", true));
        list.add(new HistoryChart("message.BatteryDischargeCurrent", "{workInfo.getDisChargingCurrent}", 150.0, "A", true));
        list.add(new HistoryChart("message.gridOutputVoltage", "{workInfo.getAcOutputVoltageR}", 300.0, "V", true));
        list.add(new HistoryChart("message.acOutputFreq", "{workInfo.getAcOutputFrequency}", 70.0, "Hz", true));
        list.add(new HistoryChart("message.acOutputActivePower", "{workInfo.getAcOutputActivePowerR}", 3000.0, "VA", true));
        list.add(new HistoryChart("message.acOutputApperentPower", "{workInfo.getAcOutputApperentPowerR}", 3000.0, "W", true));
        list.add(new HistoryChart("message.loadpercent", "{workInfo.getOutputLoadPercent}", 100.0, "%", true));
        if (this.outputMode == 1) {
            list.add(new HistoryChart("message.totalchargingcurrent", "{workInfo.getTotalBatteryChargingCurrent}", 100.0, "A", true));
            list.add(new HistoryChart("message.totaloutputapparentpower", "{workInfo.getTotalACOutputApparentPower}", 20000.0, "VA", true));
            list.add(new HistoryChart("message.totaloutputactivepower", "{workInfo.getTotalACOutputActivePower}", 20000.0, "W", true));
            list.add(new HistoryChart("message.totaloutputpercent", "{workInfo.getTotalOutputLoadPercent}", 100.0, "%", true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryDataColumns getHistoryColumns() {
        HistoryDataColumns columns = new HistoryDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.workMode", "{workInfo.getWorkMode}", true, false));
        list.add(new HistoryData("message.time", "{workInfo.getCurrentTime}", true, false));
        list.add(new HistoryData("message.pvInputVoltage1", "{workInfo.getPvInputVoltage1}", true, true));
        list.add(new HistoryData("message.pvInputPower1", "{workInfo.getPvInputPower1}", true, true));
        list.add(new HistoryData("message.pvInputVoltage2", "{workInfo.getPvInputVoltage2}", true, true));
        list.add(new HistoryData("message.pvInputPower2", "{workInfo.getPvInputPower2}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{workInfo.getGridVoltageR}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{workInfo.getGridFrequency}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{workInfo.getBatteryVoltage}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{workInfo.getBatteryCapacity}", true, true));
        list.add(new HistoryData("message.BatteryChargingCurrent", "{workInfo.getChargingCurrent}", true, true));
        list.add(new HistoryData("message.BatteryDischargeCurrent", "{workInfo.getDisChargingCurrent}", true, true));
        list.add(new HistoryData("message.gridOutputVoltage", "{workInfo.getAcOutputVoltageR}", true, true));
        list.add(new HistoryData("message.acOutputFreq", "{workInfo.getAcOutputFrequency}", true, true));
        list.add(new HistoryData("message.acOutputActivePower", "{workInfo.getAcOutputActivePowerR}", true, true));
        list.add(new HistoryData("message.acOutputApperentPower", "{workInfo.getAcOutputApperentPowerR}", true, true));
        list.add(new HistoryData("message.loadpercent", "{workInfo.getOutputLoadPercent}", true, true));
        if (this.outputMode == 1) {
            list.add(new HistoryData("message.totalchargingcurrent", "{workInfo.getTotalBatteryChargingCurrent}", true, true));
            list.add(new HistoryData("message.totaloutputapparentpower", "{workInfo.getTotalACOutputApparentPower}", true, true));
            list.add(new HistoryData("message.totaloutputactivepower", "{workInfo.getTotalACOutputActivePower}", true, true));
            list.add(new HistoryData("message.totaloutputpercent", "{workInfo.getTotalOutputLoadPercent}", true, true));
        }
        columns.setColumns(list);
        return columns;
    }

    @Override
    public HistoryFaultDataColumns getHistoryFaultColumns() {
        HistoryFaultDataColumns columns = new HistoryFaultDataColumns();
        ArrayList<HistoryData> list = new ArrayList<HistoryData>();
        list.add(new HistoryData("message.trandate", "{faultData.getTrandate}", true, true));
        list.add(new HistoryData("message.faultString", "{faultData.getFaultString}", true, true));
        list.add(new HistoryData("message.pvInputVoltage1", "{faultData.getPvinputvoltage1}", true, true));
        list.add(new HistoryData("message.pvInputPower1", "{faultData.getPvinputpower1}", true, true));
        list.add(new HistoryData("message.pvInputVoltage2", "{faultData.getPvinputvoltage2}", true, true));
        list.add(new HistoryData("message.pvInputPower2", "{faultData.getPvinputpower2}", true, true));
        list.add(new HistoryData("message.gridVoltageR", "{faultData.getGridVoltage}", true, true));
        list.add(new HistoryData("message.gridFrequency", "{faultData.getGridFrequency}", true, true));
        list.add(new HistoryData("message.batteryVoltage", "{faultData.getBatteryVoltage}", true, true));
        list.add(new HistoryData("message.BatteryChargingCurrent", "{faultData.getBatteryChargingCurrent}", true, true));
        list.add(new HistoryData("message.BatteryDischargeCurrent", "{faultData.getBatteryDischargeCurrent}", true, true));
        list.add(new HistoryData("message.batteryCapacity", "{faultData.getBatteryCapacity}", true, true));
        list.add(new HistoryData("message.gridOutputVoltage", "{faultData.getAcoutputvoltager}", true, true));
        list.add(new HistoryData("message.acOutputFreq", "{faultData.getAcoutputfrequency}", true, true));
        list.add(new HistoryData("message.acOutputActivePower", "{faultData.getAcoutputactivepowerr}", true, true));
        list.add(new HistoryData("message.acOutputApperentPower", "{faultData.getAcoutputapperentpowerr}", true, true));
        columns.setColumns(list);
        return columns;
    }

    @Override
    public String getMCUVersion() {
        return null;
    }

    @Override
    public AutoMenuList getMenuList() {
        AutoMenuList menuList = new AutoMenuList();
        ArrayList<AutoMenuOne> menus = new ArrayList<AutoMenuOne>();
        ArrayList<AutoMenuTwo> items1 = new ArrayList<AutoMenuTwo>();
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.baseSet", 101, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.passwordSet", 102, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.smsinfoSet", 104, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.emailSet", 105, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.electricEventSet", 106, ""), null));
        items1.add(new AutoMenuTwo(new AutoMenuItem("message.setcom", 107, ""), null));
        ArrayList<AutoMenuTwo> items2 = new ArrayList<AutoMenuTwo>();
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.parametersSetting", 201, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.factoryReset", 202, ""), null));
        items2.add(new AutoMenuTwo(new AutoMenuItem("message.realTimeCtrl", 204, ""), null));
        ArrayList<AutoMenuTwo> items3 = new ArrayList<AutoMenuTwo>();
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryPower", 301, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryData", 302, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryFaultData", 303, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.queryEvent", 304, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.monitorPointInfo", 305, ""), null));
        items3.add(new AutoMenuTwo(new AutoMenuItem("message.powerNumber", 306, ""), null));
        ArrayList<AutoMenuTwo> items4 = new ArrayList<AutoMenuTwo>();
        items4.add(new AutoMenuTwo(new AutoMenuItem("English", 401, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("French", 402, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("German", 403, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Italian", 404, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Polish", 405, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Portuguese", 406, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Russian", 407, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Spanish", 408, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Ukrainian", 409, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Turkish", 410, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Simplified)", 411, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Chinese(Traditional)", 412, "radio"), null));
        items4.add(new AutoMenuTwo(new AutoMenuItem("Japanese", 413, "radio"), null));
        ArrayList<AutoMenuTwo> items5 = new ArrayList<AutoMenuTwo>();
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.about", 501, ""), null));
        items5.add(new AutoMenuTwo(new AutoMenuItem("message.onlineHelp", 502, ""), null));
        menus.add(new AutoMenuOne("[" + GlobalVariables.customerConfig.getCustomerName() + "]" + "message.pvConfig", 1, items1));
        menus.add(new AutoMenuOne("message.pvControl", 2, items2));
        menus.add(new AutoMenuOne("message.pvView", 3, items3));
        menus.add(new AutoMenuOne("message.language", 4, items4));
        menus.add(new AutoMenuOne("message.help", 5, items5));
        menuList.setMenuList(menus);
        return menuList;
    }

    @Override
    public ProductInfo getProductInfo() {
        ProductInfo productInfo = new ProductInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.machinetype[:]", "{machineInfo.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.topology[:]", "{machineInfo.getTopology}", ""));
        infos.add(new AutoLabelItem("message.mainfirewareversion[:]", "{machineInfo.getMainFirmwareVersion}", ""));
        infos.add(new AutoLabelItem("message.slavefirewareversion1[:]", "{machineInfo.getSlaveFirmwareVersion1}", ""));
        infos.add(new AutoLabelItem("message.slavefirewareversion2[:]", "{machineInfo.getSlaveFirmwareVersion2}", ""));
        productInfo.setInfos(infos);
        return productInfo;
    }

    @Override
    public PurchaseInfo getPurchaseInfo() {
        return null;
    }

    @Override
    public RadioParameter getRadioParameter() {
        RadioParameter radioParameter = new RadioParameter();
        ArrayList<AutoRadioItem> list = new ArrayList<AutoRadioItem>();
        list.add(new AutoRadioItem("message.pepdA[:]", "message.enable", "message.disable", "{cappbility.isCapableA}", "CapableA", false));
        list.add(new AutoRadioItem("message.overLoadAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableD}", "CapableD", false));
        list.add(new AutoRadioItem("message.overTemperatureAutoRestart[:]", "message.enable", "message.disable", "{cappbility.isCapableE}", "CapableE", false));
        list.add(new AutoRadioItem("message.backlight[:]", "message.enable", "message.disable", "{cappbility.isCapableF}", "CapableF", false));
        list.add(new AutoRadioItem("message.machinetype[:]", "Hybrid", "Off-grid", "{cappbility.isCapableI}", "CapableI", false));
        list.add(new AutoRadioItem("message.OverloadBypass[:]", "message.enable", "message.disable", "{cappbility.isCapableB}", "CapableB", false));
        list.add(new AutoRadioItem("message.LCDDisplayEscapeToDefaultPage[:]", "message.enable", "message.disable", "{cappbility.isCapableC}", "CapableC", false));
        list.add(new AutoRadioItem("message.beepsWhileInterrupt[:]", "message.enable", "message.disable", "{cappbility.isCapableG}", "CapableG", false));
        list.add(new AutoRadioItem("message.FaultCodeRecord[:]", "message.enable", "message.disable", "{cappbility.isCapableH}", "CapableH", false));
        radioParameter.setRadioParameterList(list);
        return radioParameter;
    }

    @Override
    public RatingInfo getRatingInfo() {
        RatingInfo ratingInfo = new RatingInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.nominalacvol[:]", "{machineInfo.getAcInputRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominalaccur[:]", "{machineInfo.getAcInputRatingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.nominaloutputvol[:]", "{machineInfo.getAcOutputRatingVoltage}", "V"));
        infos.add(new AutoLabelItem("message.nominaloutputcur[:]", "{machineInfo.getAcOutputRatingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.nominaloutputfre[:]", "{machineInfo.getAcOutputRatingFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.nominaloutputactivepowwer[:]", "{machineInfo.getAcOutputRatingActivePower}", "W"));
        infos.add(new AutoLabelItem("message.nominaloutputapparentpower[:]", "{machineInfo.getAcOutputRatingApparentPower}", "VA"));
        infos.add(new AutoLabelItem("message.batteryRatingVoltage[:]", "{machineInfo.getBatteryRatingVoltage}", "V"));
        ratingInfo.setInfos(infos);
        return ratingInfo;
    }

    @Override
    public RestoreInfo getResotreInfo() {
        RestoreInfo restoreInfo = new RestoreInfo();
        ArrayList<AutoLabelItem> infos = new ArrayList<AutoLabelItem>();
        infos.add(new AutoLabelItem("message.chargerSourcePriority[:]", "{defaultData.getChargerSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.outputSourcePriority[:]", "{defaultData.getOutputSourcePriority}", ""));
        infos.add(new AutoLabelItem("message.SolarPowerPriority[:]", "{defaultData.getSolarPowerPriority}", ""));
        infos.add(new AutoLabelItem("message.acInputRange[:]", "{defaultData.getAcInputVoltageRange}", ""));
        infos.add(new AutoLabelItem("message.batteryType[:]", "{defaultData.getBatteryType}", ""));
        infos.add(new AutoLabelItem("message.outputMode[:]", "{defaultData.getOutputModel}", ""));
        infos.add(new AutoLabelItem("message.outputFrequency[:]", "{defaultData.getAcOutputFrequency}", "Hz"));
        infos.add(new AutoLabelItem("message.BatteryRechargeVoltage[:]", "{defaultData.getBatteryRechargeVoltage}", "V"));
        infos.add(new AutoLabelItem("message.BatteryRedischargeVoltage[:]", "{defaultData.getBatteryRedischargeVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxChargingCurrent[:]", "{defaultData.getMaxChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.maxAcChargingCurrent[:]", "{defaultData.getMaxACChargingCurrent}", "A"));
        infos.add(new AutoLabelItem("message.maxChargingVoltage[:]", "{defaultData.getBatteryBulkVoltage}", "V"));
        infos.add(new AutoLabelItem("message.maxFloatingVoltage[:]", "{defaultData.getBatteryFloatVoltage}", "V"));
        infos.add(new AutoLabelItem("message.batteryCutoffVoltage[:]", "{defaultData.getBatteryUnderVoltage}", "V"));
        infos.add(new AutoLabelItem("message.pepdA[:]", "{defaultData.getCapableA}", ""));
        infos.add(new AutoLabelItem("message.overLoadAutoRestart[:]", "{defaultData.getCapableD}", ""));
        infos.add(new AutoLabelItem("message.overTemperatureAutoRestart[:]", "{defaultData.getCapableE}", ""));
        infos.add(new AutoLabelItem("message.backlight[:]", "{defaultData.getCapableF}", ""));
        infos.add(new AutoLabelItem("message.machinetype[:]", "{defaultData.getMachineType}", ""));
        infos.add(new AutoLabelItem("message.OverloadBypass[:]", "{defaultData.getCapableB}", ""));
        infos.add(new AutoLabelItem("message.LCDDisplayEscapeToDefaultPage[:]", "{defaultData.getCapableC}", ""));
        infos.add(new AutoLabelItem("message.AlarmOnWhenPrimarySourceInterrupt[:]", "{defaultData.getCapableG}", ""));
        infos.add(new AutoLabelItem("message.FaultCodeRecord[:]", "{defaultData.getCapableH}", ""));
        restoreInfo.setInfos(infos);
        return restoreInfo;
    }

    @Override
    public ComboBoxParameter getComboBoxParameter() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        ConfigData config = null;
        config = processor != null ? (ConfigData)processor.getBeanBag().getBean("configdata") : new ConfigData();
        ComboBoxParameter comboBoxParameter = new ComboBoxParameter();
        ArrayList<AutoComboBoxItem> list = new ArrayList<AutoComboBoxItem>();
        if (this.getProtocolID().equals("P1812K")) {
            list.add(new AutoComboBoxItem("message.standard[:]", new String[]{"India", "Germany"}, "{configData.getRegulationsState}", "", "setRS", 0, false));
        } else {
            list.add(new AutoComboBoxItem("message.standard[:]", new String[]{"India", "Germany", "South America"}, "{configData.getRegulationsState}", "", "setRS", 0, false));
        }
        list.add(new AutoComboBoxItem("message.chargerSourcePriority[:]", new String[]{"Solar first", "Solar and Utility", "Solar only"}, "{configData.getChargerSourcePriority}", "", "setPCP", 0, false));
        list.add(new AutoComboBoxItem("message.maxChargingCurrent[:]", config.getMaxChargingCurrentComBox(), "{configData.getMaxChargingCurrent}", "A", "setMCHGC", 0, false));
        list.add(new AutoComboBoxItem("message.maxAcChargingCurrent[:]", config.getMaxAcChargingCurrentCombox(), "{configData.getMaxAcChargingCurrent}", "A", "setMUCHGC", 0, false));
        list.add(new AutoComboBoxItem("message.outputMode[:]", new String[]{"Single", "Parallel output", "Phase R of 3 phase output", "Phase S of 3 phase output", "Phase T of 3 phase output"}, "{configData.getOutputModel}", "", "setPOPM", 0, false));
        list.add(new AutoComboBoxItem("message.acInputRange[:]", new String[]{"Appliance", "UPS"}, "{configData.getInputVoltageRange}", "", "setPGR", 0, false));
        list.add(new AutoComboBoxItem("message.batteryType[:]", new String[]{"AGM", "Flooded", "User"}, "{configData.getBatteryType}", "", "setPBT", 0, false));
        list.add(new AutoComboBoxItem("message.SolarPowerPriority[:]", new String[]{"Battery-Load-Utility", "Load-Battery-Utility"}, "{configData.getSolarPowerPriority}", "", "setPSP", 0, false));
        list.add(new AutoComboBoxItem("message.outputSourcePriority[:]", new String[]{"Solar-Utility-Battery", "Solar-Battery-Utility"}, "{configData.getOutputSourcePriority}", "", "setPOP", 0, false));
        list.add(new AutoComboBoxItem("message.outputFrequency[:]", new String[]{"50.0", "60.0"}, "{configData.getAcOutputRatingFrequency}", "Hz", "setF", 0, false));
        list.add(new AutoComboBoxItem("message.outputVoltage[:]", new String[]{"220.0", "230.0", "240.0"}, "{configData.getAcOutputRatingVoltage}", "V", "setV", 0, false));
        if (config.getBatteryRatingVoltage() > 40.0) {
            list.add(new AutoComboBoxItem("message.BatteryRechargeVoltage[:]", new String[]{"44.0", "45.0", "46.0", "47.0", "48.0", "49.0", "50.0", "51.0"}, "{configData.getBatteryRechargeVoltage}", "V", "setBUCD", 0, false));
            list.add(new AutoComboBoxItem("message.BatteryRedischargeVoltage[:]", new String[]{"FULL", "48.0", "49.0", "50.0", "51.0", "52.0", "53.0", "54.0", "55.0", "56.0", "57.0", "58.0"}, "{configData.getBatteryRedischargeVoltage}", "V", "setBUCD", 1, false));
        } else if (config.getBatteryRatingVoltage() > 20.0) {
            list.add(new AutoComboBoxItem("message.BatteryRechargeVoltage[:]", new String[]{"22.0", "22.5", "23.0", "23.5", "24.0", "24.5", "25.0", "25.5"}, "{configData.getBatteryRechargeVoltage}", "V", "setBUCD", 0, false));
            list.add(new AutoComboBoxItem("message.BatteryRedischargeVoltage[:]", new String[]{"FULL", "24.0", "24.5", "25.0", "25.5", "26.0", "26.5", "27.0", "27.5", "28.0", "28.5", "29.0"}, "{configData.getBatteryRedischargeVoltage}", "V", "setBUCD", 1, false));
        } else {
            list.add(new AutoComboBoxItem("message.BatteryRechargeVoltage[:]", new String[]{"11.0", "11.3", "11.5", "11.8", "12.0", "12.3", "12.5", "12.8"}, "{configData.getBatteryRechargeVoltage}", "V", "setBUCD", 0, false));
            list.add(new AutoComboBoxItem("message.BatteryRedischargeVoltage[:]", new String[]{"FULL", "12.0", "12.3", "12.5", "12.8", "13.0", "13.3", "13.5", "13.8", "14.0", "14.3", "14.5"}, "{configData.getBatteryRedischargeVoltage}", "V", "setBUCD", 1, false));
        }
        comboBoxParameter.setComboBoxParameterList(list);
        return comboBoxParameter;
    }

    @Override
    public SpinnerParameter getSpinnerParameter() {
        SpinnerParameter spinnerParameter = new SpinnerParameter();
        ArrayList<AutoSpinnerItem> list = new ArrayList<AutoSpinnerItem>();
        list.add(new AutoSpinnerItem("message.maxChargingVoltage[:]", "{configData.getMinBatteryBulkVoltage}", "{configData.getMaxBatteryBulkVoltage}", "0.1", "{configData.getBatteryBulkVoltage}", "V", "setMCHGV", 0, false));
        list.add(new AutoSpinnerItem("message.maxFloatingVoltage[:]", "{configData.getMinBatteryFloatVoltage}", "{configData.getMaxBatteryFloatVoltage}", "0.1", "{configData.getBatteryFloatVoltage}", "V", "setMCHGV", 1, false));
        list.add(new AutoSpinnerItem("message.batteryCutoffVoltage[:]", "{configData.getMinBatteryUnderVoltage}", "{configData.getMaxBatteryUnderVoltage}", "0.1", "{configData.getBatteryUnderVoltage}", "V", "setPSDV", 0, false));
        spinnerParameter.setSpinnerParameterList(list);
        return spinnerParameter;
    }

    @Override
    public void initCommandMap() {
        this.map.clear();
        this.map.AddCommand("setMCHGV", 2);
        this.map.AddCommand("setPSDV", 1);
        this.map.AddCommand("setBUCD", 2);
        this.map.AddCommand("setRS", 1);
        this.map.AddCommand("setPCP", 1);
        this.map.AddCommand("setPSP", 1);
        this.map.AddCommand("setPOP", 1);
        this.map.AddCommand("setPGR", 1);
        this.map.AddCommand("setPBT", 1);
        this.map.AddCommand("setPOPM", 1);
        this.map.AddCommand("setF", 1);
        this.map.AddCommand("setV", 1);
        this.map.AddCommand("setMCHGC", 1);
        this.map.AddCommand("setMUCHGC", 1);
    }

    @Override
    public String getSerialNo() {
        return this.serialNo;
    }

    @Override
    public String getModelType() {
        return this.modelType;
    }

    @Override
    public List<ControlRelation> getRelationList() {
        return this.relalist;
    }

    @Override
    public MoreInfo getMoreInfo() {
        return null;
    }

    @Override
    public int getMpptTrackNumber() {
        return 0;
    }

    @Override
    public boolean isSupportModelSetting() {
        return false;
    }

    @Override
    public void setDeviceModel(String deviceModel) {
    }

    @Override
    public void setModelType(String modelType) {
    }

    @Override
    public void setMpptTrackNumber(int mpptTrackNumber) {
    }

    @Override
    public List<String> spinnerValueRelate() {
        return null;
    }

    @Override
    public int getOutputMode() {
        return this.outputMode;
    }

    @Override
    public void setOutputMode(int outputmode) {
        this.outputMode = outputmode;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }
}

