/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.StyleableBooleanProperty;
import com.sun.javafx.css.StyleableDoubleProperty;
import com.sun.javafx.css.StyleableObjectProperty;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.platform.event.KeyCodeMap;
import com.sun.webpane.platform.event.WCFocusEvent;
import com.sun.webpane.platform.event.WCInputMethodEvent;
import com.sun.webpane.platform.event.WCKeyEvent;
import com.sun.webpane.platform.event.WCMouseEvent;
import com.sun.webpane.platform.event.WCMouseWheelEvent;
import com.sun.webpane.platform.event.WCTouchEvent;
import com.sun.webpane.platform.event.WCTouchPoint;
import com.sun.webpane.sg.ImplementationManager;
import com.sun.webpane.sg.InputMethodClientImpl;
import com.sun.webpane.sg.PGWebView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.DataFormat;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.input.TouchPoint;
import javafx.scene.input.TransferMode;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.web.WebEngine;

public final class WebView
extends Parent {
    private static final Map<Object, Integer> idMap = new HashMap<Object, Integer>();
    private static final boolean DEFAULT_CONTEXT_MENU_ENABLED = true;
    private static final FontSmoothingType DEFAULT_FONT_SMOOTHING_TYPE = FontSmoothingType.LCD;
    private static final double DEFAULT_SCALE = 1.0;
    private static final double DEFAULT_FONT_SCALE = 1.0;
    private static final double DEFAULT_MIN_WIDTH = 0.0;
    private static final double DEFAULT_MIN_HEIGHT = 0.0;
    private static final double DEFAULT_PREF_WIDTH = 800.0;
    private static final double DEFAULT_PREF_HEIGHT = 600.0;
    private static final double DEFAULT_MAX_WIDTH = Double.MAX_VALUE;
    private static final double DEFAULT_MAX_HEIGHT = Double.MAX_VALUE;
    private final WebPage page;
    private final WebEngine engine;
    private volatile InputMethodClientImpl imClient;
    private final TKPulseListener stagePulseListener;
    private ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper(this, "width");
    private ReadOnlyDoubleWrapper height = new ReadOnlyDoubleWrapper(this, "height");
    private DoubleProperty scale;
    private DoubleProperty fontScale;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;
    private ObjectProperty<FontSmoothingType> fontSmoothingType;
    private BooleanProperty contextMenuEnabled;
    private static int WK_DND_ACTION_NONE = 0;
    private static int WK_DND_ACTION_COPY = 1;
    private static int WK_DND_ACTION_MOVE = 2;
    private static int WK_DND_ACTION_LINK = 0x40000000;

    public final WebEngine getEngine() {
        return this.engine;
    }

    public final double getWidth() {
        return this.width.get();
    }

    public ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final double getHeight() {
        return this.height.get();
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    @Deprecated
    public void impl_setScale(double d) {
        WebEngine.checkThread();
        this.scaleProperty().set(d);
    }

    @Deprecated
    public double impl_getScale() {
        return this.scale != null ? this.scale.get() : 1.0;
    }

    private DoubleProperty scaleProperty() {
        if (this.scale == null) {
            this.scale = new StyleableDoubleProperty(1.0){

                @Override
                public void invalidated() {
                    if (WebView.this.page != null) {
                        double d = this.get();
                        WebView.this.page.setZoomFactor((float)d, false);
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.SCALE;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "scale";
                }
            };
        }
        return this.scale;
    }

    public final void setFontScale(double d) {
        WebEngine.checkThread();
        this.fontScaleProperty().set(d);
    }

    public final double getFontScale() {
        return this.fontScale != null ? this.fontScale.get() : 1.0;
    }

    public DoubleProperty fontScaleProperty() {
        if (this.fontScale == null) {
            this.fontScale = new StyleableDoubleProperty(1.0){

                @Override
                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setZoomFactor((float)this.get(), true);
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.FONT_SCALE;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "fontScale";
                }
            };
        }
        return this.fontScale;
    }

    public WebView() {
        this.getStyleClass().add("web-view");
        this.engine = new WebEngine();
        this.engine.setView(this);
        this.page = this.engine.getPage();
        this.page.setFontSmoothingType(DEFAULT_FONT_SMOOTHING_TYPE.ordinal());
        this.registerEventHandlers();
        this.stagePulseListener = new TKPulseListener(){

            @Override
            public void pulse() {
                WebView.this.handleStagePulse();
            }
        };
        this.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (WebView.this.page != null) {
                    WCFocusEvent wCFocusEvent = new WCFocusEvent(WebView.this.isFocused() ? 2 : 3, -1);
                    WebView.this.page.dispatchFocusEvent(wCFocusEvent);
                }
            }
        });
        Toolkit.getToolkit().addStageTkPulseListener(this.stagePulseListener);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d, double d2) {
        if (d != this.width.get() || d2 != this.height.get()) {
            this.width.set(d);
            this.height.set(d2);
            this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
            this.impl_geomChanged();
        }
    }

    @Override
    public final double minWidth(double d) {
        return this.getMinWidth();
    }

    @Override
    public final double minHeight(double d) {
        return this.getMinHeight();
    }

    @Override
    public final double prefWidth(double d) {
        return this.getPrefWidth();
    }

    @Override
    public final double prefHeight(double d) {
        return this.getPrefHeight();
    }

    @Override
    public final double maxWidth(double d) {
        return this.getMaxWidth();
    }

    @Override
    public final double maxHeight(double d) {
        return this.getMaxHeight();
    }

    public DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new StyleableDoubleProperty(0.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.MIN_WIDTH;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth != null ? this.minWidth.get() : 0.0;
    }

    public DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new StyleableDoubleProperty(0.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.MIN_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setMinHeight(double d) {
        this.minHeightProperty().set(d);
    }

    public final double getMinHeight() {
        return this.minHeight != null ? this.minHeight.get() : 0.0;
    }

    public void setMinSize(double d, double d2) {
        this.setMinWidth(d);
        this.setMinHeight(d2);
    }

    public DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new StyleableDoubleProperty(800.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PREF_WIDTH;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth != null ? this.prefWidth.get() : 800.0;
    }

    public DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new StyleableDoubleProperty(600.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.PREF_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public final void setPrefHeight(double d) {
        this.prefHeightProperty().set(d);
    }

    public final double getPrefHeight() {
        return this.prefHeight != null ? this.prefHeight.get() : 600.0;
    }

    public void setPrefSize(double d, double d2) {
        this.setPrefWidth(d);
        this.setPrefHeight(d2);
    }

    public DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new StyleableDoubleProperty(Double.MAX_VALUE){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.MAX_WIDTH;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth != null ? this.maxWidth.get() : Double.MAX_VALUE;
    }

    public DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new StyleableDoubleProperty(Double.MAX_VALUE){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.MAX_HEIGHT;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public final void setMaxHeight(double d) {
        this.maxHeightProperty().set(d);
    }

    public final double getMaxHeight() {
        return this.maxHeight != null ? this.maxHeight.get() : Double.MAX_VALUE;
    }

    public void setMaxSize(double d, double d2) {
        this.setMaxWidth(d);
        this.setMaxHeight(d2);
    }

    public final void setFontSmoothingType(FontSmoothingType fontSmoothingType) {
        this.fontSmoothingTypeProperty().set(fontSmoothingType);
    }

    public final FontSmoothingType getFontSmoothingType() {
        return this.fontSmoothingType != null ? (FontSmoothingType)((Object)this.fontSmoothingType.get()) : DEFAULT_FONT_SMOOTHING_TYPE;
    }

    public final ObjectProperty<FontSmoothingType> fontSmoothingTypeProperty() {
        if (this.fontSmoothingType == null) {
            this.fontSmoothingType = new StyleableObjectProperty<FontSmoothingType>(DEFAULT_FONT_SMOOTHING_TYPE){

                @Override
                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setFontSmoothingType(((FontSmoothingType)((Object)this.get())).ordinal());
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.FONT_SMOOTHING_TYPE;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "fontSmoothingType";
                }
            };
        }
        return this.fontSmoothingType;
    }

    public final void setContextMenuEnabled(boolean bl) {
        this.contextMenuEnabledProperty().set(bl);
    }

    public final boolean isContextMenuEnabled() {
        return this.contextMenuEnabled == null ? true : this.contextMenuEnabled.get();
    }

    public final BooleanProperty contextMenuEnabledProperty() {
        if (this.contextMenuEnabled == null) {
            this.contextMenuEnabled = new StyleableBooleanProperty(true){

                @Override
                public void invalidated() {
                    Toolkit.getToolkit().checkFxUserThread();
                    WebView.this.page.setContextMenuEnabled(this.get());
                }

                @Override
                public StyleableProperty getStyleableProperty() {
                    return StyleableProperties.CONTEXT_MENU_ENABLED;
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "contextMenuEnabled";
                }
            };
        }
        return this.contextMenuEnabled;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    public List<StyleableProperty> impl_getStyleableProperties() {
        return WebView.impl_CSS_STYLEABLES();
    }

    private void handleStagePulse() {
        boolean bl;
        if (this.page == null) {
            return;
        }
        boolean bl2 = bl = this.impl_isTreeVisible() && this.getScene() != null && this.getScene().getWindow() != null && this.getScene().getWindow().isShowing();
        if (bl) {
            if (this.page.isDirty()) {
                Scene.impl_setAllowPGAccess(true);
                this.getPGWebView().update();
                if (this.page.isRepaintPending()) {
                    this.impl_markDirty(DirtyBits.WEBVIEW_VIEW);
                }
                Scene.impl_setAllowPGAccess(false);
            }
        } else {
            this.page.clearRenderQueues();
        }
    }

    private void processMouseEvent(MouseEvent mouseEvent) {
        if (this.page == null) {
            return;
        }
        Integer n = idMap.get(mouseEvent.getEventType());
        if (n == null) {
            return;
        }
        WCMouseEvent wCMouseEvent = new WCMouseEvent(n, idMap.get((Object)mouseEvent.getButton()), mouseEvent.getClickCount(), (int)mouseEvent.getX(), (int)mouseEvent.getY(), (int)mouseEvent.getScreenX(), (int)mouseEvent.getScreenY(), System.currentTimeMillis(), mouseEvent.isShiftDown(), mouseEvent.isControlDown(), mouseEvent.isAltDown(), mouseEvent.isMetaDown(), MouseEvent.impl_getPopupTrigger(mouseEvent));
        this.page.dispatchMouseEvent(wCMouseEvent);
        mouseEvent.consume();
    }

    private void processScrollEvent(ScrollEvent scrollEvent) {
        if (this.page == null) {
            return;
        }
        double d = -scrollEvent.getDeltaX() * this.getFontScale() * this.getScaleX();
        double d2 = -scrollEvent.getDeltaY() * this.getFontScale() * this.getScaleY();
        WCMouseWheelEvent wCMouseWheelEvent = new WCMouseWheelEvent((int)scrollEvent.getX(), (int)scrollEvent.getY(), (int)scrollEvent.getScreenX(), (int)scrollEvent.getScreenY(), System.currentTimeMillis(), scrollEvent.isShiftDown(), scrollEvent.isControlDown(), scrollEvent.isAltDown(), scrollEvent.isMetaDown(), (float)d, (float)d2);
        this.page.dispatchMouseWheelEvent(wCMouseWheelEvent);
        scrollEvent.consume();
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        Object object;
        if (this.page == null) {
            return;
        }
        String string = null;
        String string2 = null;
        int n = 0;
        if (keyEvent.getEventType() == KeyEvent.KEY_TYPED) {
            string = keyEvent.getCharacter();
        } else {
            object = KeyCodeMap.lookup(keyEvent.getCode());
            string2 = ((KeyCodeMap.Entry)object).getKeyIdentifier();
            n = ((KeyCodeMap.Entry)object).getWindowsVirtualKeyCode();
        }
        object = new WCKeyEvent(idMap.get(keyEvent.getEventType()), string, string2, n, keyEvent.isShiftDown(), keyEvent.isControlDown(), keyEvent.isAltDown(), keyEvent.isMetaDown());
        if (this.page.dispatchKeyEvent((WCKeyEvent)object)) {
            keyEvent.consume();
        }
    }

    private void processTouchEvent(TouchEvent touchEvent) {
        if (this.page == null) {
            return;
        }
        Integer n = idMap.get(touchEvent.getEventType());
        if (n == null) {
            return;
        }
        ArrayList<WCTouchPoint> arrayList = new ArrayList<WCTouchPoint>(touchEvent.getTouchCount());
        for (TouchPoint touchPoint : touchEvent.getTouchPoints()) {
            arrayList.add(new WCTouchPoint(touchPoint.getId(), idMap.get((Object)touchPoint.getState()), touchPoint.getX(), touchPoint.getY(), touchPoint.getScreenX(), touchPoint.getScreenY()));
        }
        WCTouchEvent wCTouchEvent = new WCTouchEvent(n, arrayList, System.currentTimeMillis(), touchEvent.isShiftDown(), touchEvent.isControlDown(), touchEvent.isAltDown(), touchEvent.isMetaDown());
        this.page.dispatchTouchEvent(wCTouchEvent);
        touchEvent.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputMethodClientImpl getInputMethodClient() {
        if (this.imClient == null) {
            WebView webView = this;
            synchronized (webView) {
                if (this.imClient == null) {
                    this.imClient = new InputMethodClientImpl(this, this.page);
                }
            }
        }
        return this.imClient;
    }

    private void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.page == null) {
            return;
        }
        if (!this.getInputMethodClient().getInputMethodState()) {
            inputMethodEvent.consume();
            return;
        }
        WCInputMethodEvent wCInputMethodEvent = InputMethodClientImpl.convertToWCInputMethodEvent(inputMethodEvent);
        if (this.page.dispatchInputMethodEvent(wCInputMethodEvent)) {
            inputMethodEvent.consume();
            return;
        }
    }

    private static int getWKDndEventType(EventType eventType) {
        int n = 0;
        if (eventType == DragEvent.DRAG_ENTERED_TARGET) {
            n = 0;
        } else if (eventType == DragEvent.DRAG_EXITED_TARGET) {
            n = 3;
        } else if (eventType == DragEvent.DRAG_OVER) {
            n = 1;
        } else if (eventType == DragEvent.DRAG_DROPPED) {
            n = 4;
        }
        return n;
    }

    private static int getWKDndAction(TransferMode ... transferModeArray) {
        int n = WK_DND_ACTION_NONE;
        for (TransferMode transferMode : transferModeArray) {
            if (transferMode == TransferMode.COPY) {
                n |= WK_DND_ACTION_COPY;
                continue;
            }
            if (transferMode == TransferMode.MOVE) {
                n |= WK_DND_ACTION_MOVE;
                continue;
            }
            if (transferMode != TransferMode.LINK) continue;
            n |= WK_DND_ACTION_LINK;
        }
        return n;
    }

    private static TransferMode[] getFXDndAction(int n) {
        LinkedList<TransferMode> linkedList = new LinkedList<TransferMode>();
        if ((n & WK_DND_ACTION_COPY) != 0) {
            linkedList.add(TransferMode.COPY);
        }
        if ((n & WK_DND_ACTION_MOVE) != 0) {
            linkedList.add(TransferMode.MOVE);
        }
        if ((n & WK_DND_ACTION_LINK) != 0) {
            linkedList.add(TransferMode.LINK);
        }
        return linkedList.toArray(new TransferMode[0]);
    }

    private void registerEventHandlers() {
        this.addEventHandler(KeyEvent.ANY, new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                WebView.this.processKeyEvent(keyEvent);
            }
        });
        this.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                WebView.this.processMouseEvent(mouseEvent);
                if (mouseEvent.isDragDetect() && !WebView.this.page.isDragConfirmed()) {
                    mouseEvent.setDragDetect(false);
                }
            }
        });
        this.addEventHandler(ScrollEvent.SCROLL, new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                WebView.this.processScrollEvent(scrollEvent);
            }
        });
        this.addEventHandler(TouchEvent.ANY, new EventHandler<TouchEvent>(){

            @Override
            public void handle(TouchEvent touchEvent) {
                WebView.this.processTouchEvent(touchEvent);
            }
        });
        this.setOnInputMethodTextChanged((EventHandler<? super InputMethodEvent>)new EventHandler<InputMethodEvent>(){

            @Override
            public void handle(InputMethodEvent inputMethodEvent) {
                WebView.this.processInputMethodEvent(inputMethodEvent);
            }
        });
        EventHandler<DragEvent> eventHandler = new EventHandler<DragEvent>(){

            @Override
            public void handle(DragEvent dragEvent) {
                Dragboard dragboard = dragEvent.getDragboard();
                LinkedList<String> linkedList = new LinkedList<String>();
                LinkedList<String> linkedList2 = new LinkedList<String>();
                for (DataFormat dataFormat : dragboard.getContentTypes()) {
                    String string = dragboard.getContent(dataFormat).toString();
                    for (String string2 : dataFormat.getIdentifiers()) {
                        linkedList.add(string2);
                        linkedList2.add(string);
                    }
                }
                if (!linkedList.isEmpty()) {
                    int n = WebView.getWKDndEventType(dragEvent.getEventType());
                    int n2 = WebView.this.page.dispatchDragOperation(n, linkedList.toArray(new String[0]), linkedList2.toArray(new String[0]), (int)dragEvent.getX(), (int)dragEvent.getY(), (int)dragEvent.getScreenX(), (int)dragEvent.getScreenY(), WebView.getWKDndAction(dragboard.getTransferModes().toArray(new TransferMode[0])));
                    if (n != 4 || n2 != WK_DND_ACTION_NONE) {
                        dragEvent.acceptTransferModes(WebView.getFXDndAction(n2));
                    }
                    dragEvent.consume();
                }
            }
        };
        this.setOnDragEntered((EventHandler<? super DragEvent>)eventHandler);
        this.setOnDragExited((EventHandler<? super DragEvent>)eventHandler);
        this.setOnDragOver((EventHandler<? super DragEvent>)eventHandler);
        this.setOnDragDropped((EventHandler<? super DragEvent>)eventHandler);
        this.setOnDragDetected((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (WebView.this.page.isDragConfirmed()) {
                    WebView.this.page.confirmStartDrag();
                    mouseEvent.consume();
                }
            }
        });
        this.setOnDragDone((EventHandler<? super DragEvent>)new EventHandler<DragEvent>(){

            @Override
            public void handle(DragEvent dragEvent) {
                WebView.this.page.dispatchDragOperation(104, null, null, (int)dragEvent.getX(), (int)dragEvent.getY(), (int)dragEvent.getScreenX(), (int)dragEvent.getScreenY(), WebView.getWKDndAction(new TransferMode[]{dragEvent.getAcceptedTransferMode()}));
                dragEvent.consume();
            }
        });
        this.setInputMethodRequests(this.getInputMethodClient());
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(double d, double d2) {
        if (this.contains(d, d2)) {
            return this;
        }
        return null;
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(PickRay pickRay) {
        if (this.impl_intersects(pickRay)) {
            return this;
        }
        return null;
    }

    @Override
    protected ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return ImplementationManager.createView(this);
    }

    PGWebView getPGWebView() {
        return (PGWebView)this.impl_getPGNode();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), 0.0f);
        baseTransform.transform(baseBounds, baseBounds);
        return baseBounds;
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        return true;
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        PGWebView pGWebView = this.getPGWebView();
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            pGWebView.setPage(this.page);
        }
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            pGWebView.resize((float)this.getWidth(), (float)this.getHeight());
        }
        if (this.impl_isDirty(DirtyBits.WEBVIEW_VIEW)) {
            pGWebView.requestRender();
        }
    }

    static /* synthetic */ FontSmoothingType access$1300() {
        return DEFAULT_FONT_SMOOTHING_TYPE;
    }

    static {
        idMap.put((Object)MouseButton.NONE, 0);
        idMap.put((Object)MouseButton.PRIMARY, 1);
        idMap.put((Object)MouseButton.MIDDLE, 2);
        idMap.put((Object)MouseButton.SECONDARY, 4);
        idMap.put(MouseEvent.MOUSE_PRESSED, 0);
        idMap.put(MouseEvent.MOUSE_RELEASED, 1);
        idMap.put(MouseEvent.MOUSE_MOVED, 2);
        idMap.put(MouseEvent.MOUSE_DRAGGED, 3);
        idMap.put(KeyEvent.KEY_PRESSED, 1);
        idMap.put(KeyEvent.KEY_RELEASED, 2);
        idMap.put(KeyEvent.KEY_TYPED, 0);
        idMap.put(TouchEvent.TOUCH_PRESSED, 0);
        idMap.put(TouchEvent.TOUCH_MOVED, 1);
        idMap.put(TouchEvent.TOUCH_RELEASED, 2);
        idMap.put((Object)TouchPoint.State.MOVED, 2);
        idMap.put((Object)TouchPoint.State.PRESSED, 1);
        idMap.put((Object)TouchPoint.State.RELEASED, 0);
        idMap.put((Object)TouchPoint.State.STATIONARY, 3);
    }

    private static class StyleableProperties {
        private static final StyleableProperty<WebView, Boolean> CONTEXT_MENU_ENABLED = new StyleableProperty<WebView, Boolean>("-fx-context-menu-enabled", (StyleConverter)BooleanConverter.getInstance(), Boolean.valueOf(true)){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.contextMenuEnabled == null || !webView.contextMenuEnabled.isBound();
            }

            @Override
            public WritableValue<Boolean> getWritableValue(WebView webView) {
                return webView.contextMenuEnabledProperty();
            }
        };
        private static final StyleableProperty<WebView, FontSmoothingType> FONT_SMOOTHING_TYPE = new StyleableProperty<WebView, FontSmoothingType>("-fx-font-smoothing-type", new EnumConverter(FontSmoothingType.class), WebView.access$1300()){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.fontSmoothingType == null || !webView.fontSmoothingType.isBound();
            }

            @Override
            public WritableValue<FontSmoothingType> getWritableValue(WebView webView) {
                return webView.fontSmoothingTypeProperty();
            }
        };
        private static final StyleableProperty<WebView, Number> SCALE = new StyleableProperty<WebView, Number>("-fx-scale", (StyleConverter)SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.scale == null || !webView.scale.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(WebView webView) {
                return webView.scaleProperty();
            }
        };
        private static final StyleableProperty<WebView, Number> FONT_SCALE = new StyleableProperty<WebView, Number>("-fx-font-scale", (StyleConverter)SizeConverter.getInstance(), (Number)1.0){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.fontScale == null || !webView.fontScale.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(WebView webView) {
                return webView.fontScaleProperty();
            }
        };
        private static final StyleableProperty<WebView, Number> MIN_WIDTH = new StyleableProperty<WebView, Number>("-fx-min-width", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.minWidth == null || !webView.minWidth.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(WebView webView) {
                return webView.minWidthProperty();
            }
        };
        private static final StyleableProperty<WebView, Number> MIN_HEIGHT = new StyleableProperty<WebView, Number>("-fx-min-height", (StyleConverter)SizeConverter.getInstance(), (Number)0.0){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.minHeight == null || !webView.minHeight.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(WebView webView) {
                return webView.minHeightProperty();
            }
        };
        private static final StyleableProperty<WebView, Number> MAX_WIDTH = new StyleableProperty<WebView, Number>("-fx-max-width", (StyleConverter)SizeConverter.getInstance(), (Number)Double.MAX_VALUE){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.maxWidth == null || !webView.maxWidth.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(WebView webView) {
                return webView.maxWidthProperty();
            }
        };
        private static final StyleableProperty<WebView, Number> MAX_HEIGHT = new StyleableProperty<WebView, Number>("-fx-max-height", (StyleConverter)SizeConverter.getInstance(), (Number)Double.MAX_VALUE){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.maxHeight == null || !webView.maxHeight.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(WebView webView) {
                return webView.maxHeightProperty();
            }
        };
        private static final StyleableProperty<WebView, Number> PREF_WIDTH = new StyleableProperty<WebView, Number>("-fx-pref-width", (StyleConverter)SizeConverter.getInstance(), (Number)800.0){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.prefWidth == null || !webView.prefWidth.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(WebView webView) {
                return webView.prefWidthProperty();
            }
        };
        private static final StyleableProperty<WebView, Number> PREF_HEIGHT = new StyleableProperty<WebView, Number>("-fx-pref-height", (StyleConverter)SizeConverter.getInstance(), (Number)600.0){

            @Override
            public boolean isSettable(WebView webView) {
                return webView.prefHeight == null || !webView.prefHeight.isBound();
            }

            @Override
            public WritableValue<Number> getWritableValue(WebView webView) {
                return webView.prefHeightProperty();
            }
        };
        private static final List<StyleableProperty> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Parent.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, CONTEXT_MENU_ENABLED, FONT_SMOOTHING_TYPE, FONT_SCALE, MIN_WIDTH, PREF_WIDTH, MAX_WIDTH, MIN_HEIGHT, PREF_HEIGHT, MAX_HEIGHT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

