/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.control;

import cn.com.voltronic.solar.communicate.IComUSBHandler;
import cn.com.voltronic.solar.control.AbstractControlModule;
import cn.com.voltronic.solar.control.IP1516ControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import org.apache.log4j.Logger;

public class P15ComUSBControlModule
extends AbstractControlModule
implements IP1516ControlModule {
    private static Logger logger = Logger.getLogger(P15ComUSBControlModule.class);

    public P15ComUSBControlModule(Object handler, ConfigData config, Capability capability) {
        super(handler, config, capability);
    }

    @Override
    public IComUSBHandler getHandler() {
        return (IComUSBHandler)super.getHandler();
    }

    @Override
    public boolean setCapability(String x, boolean isEnable) {
        boolean result = true;
        try {
            result = this.excuteCommand(isEnable ? "PE" : "PD", x);
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean setGILTHV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("GLTHV", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOHF(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("GOHF", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOHV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("GOHV", String.format("%05.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOLF(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("GOLF", String.format("%04.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setGOLV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("GOLV", String.format("%05.01f", value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setOPMP(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("OPMP", String.format("%05d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPVIPHV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PVIPHV", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPVIPLV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PVIPLV", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setCurrentTime(String time) {
        boolean result = true;
        try {
            result = this.excuteCommand("DAT", String.valueOf(time));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMPPTHV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("MPPTHV", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setMPPTLV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("MPPTLV", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setLCD(String value) {
        boolean result = true;
        try {
            result = this.excuteCommand("LST", this.getFomatStr(String.valueOf(value), 2));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPF() {
        boolean result = true;
        try {
            result = this.excuteCommand("PF", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPassword(String oldpwd, String newpwd) {
        boolean result = false;
        return result;
    }

    @Override
    public boolean setGridWaittime(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("FT", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean selfTest() {
        boolean result = true;
        try {
            result = this.excuteCommand("ST", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean epoOff() {
        boolean result = true;
        try {
            result = this.excuteCommand("FGD", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean epoOn() {
        boolean result = true;
        try {
            result = this.excuteCommand("FGE", null);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPVN(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PVN", String.format("%02d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPGF(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PGF", this.getFomatStr(String.valueOf(value), 4));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPHV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PHV", this.getFomatStr(String.valueOf(value), 5));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPLV(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PLV", this.getFomatStr(String.valueOf(value), 5));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPSF(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PSF", this.getFomatStr(String.valueOf(value), 4));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean excuteCommand(String command, String parmeter) throws Exception {
        IComUSBHandler _handler = this.getHandler();
        boolean result = false;
        String re = "(NAK";
        if (_handler != null) {
            if (parmeter == null || "".equals(parmeter)) {
                re = _handler.excuteCommand(command, true);
                logger.error((Object)(String.valueOf(command) + " = " + re));
            } else {
                re = _handler.excuteCommand(String.valueOf(command) + parmeter, true);
                logger.error((Object)(String.valueOf(command) + parmeter + " = " + re));
            }
        }
        result = re.trim().equals("(ACK");
        return result;
    }

    @Override
    public boolean setPowerFactor(double value) {
        boolean result = true;
        try {
            String valueStr = "";
            if (value > 0.0) {
                valueStr = "+" + String.format("%03d", (int)value);
            } else {
                value = Math.abs(value);
                valueStr = "-" + String.format("%03d", (int)value);
            }
            result = this.excuteCommand("SOPF", valueStr);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPowerPercent(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PPS", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPowerFactorLine(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PDG", String.valueOf((int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPowerPFCurve(double value) {
        boolean result = true;
        try {
            value = Math.abs(value);
            result = this.excuteCommand("PFL", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setPowerPFPercent(double value) {
        boolean result = true;
        try {
            result = this.excuteCommand("PPD", String.format("%03d", (int)value));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean setFeefInReactivePower(double value) {
        return false;
    }

    @Override
    public boolean setBatteryNumbers(String value) {
        return false;
    }

    @Override
    public boolean setBTNUM(double value) {
        return false;
    }
}

