/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.error.ErrorStringBuilder;
import org.apache.derby.iapi.error.ShutdownException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.BundleFinder;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.iapi.services.io.AccessibleByteArrayOutputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableInstanceGetter;
import org.apache.derby.iapi.services.io.RegisteredFormatIds;
import org.apache.derby.iapi.services.loader.ClassInfo;
import org.apache.derby.iapi.services.loader.InstanceGetter;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.InfoStreams;
import org.apache.derby.iapi.services.stream.PrintWriterGetHeader;
import org.apache.derby.iapi.services.timer.TimerFactory;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.impl.services.monitor.AntiGC;
import org.apache.derby.impl.services.monitor.ProtocolKey;
import org.apache.derby.impl.services.monitor.ServiceBootContext;
import org.apache.derby.impl.services.monitor.StorageFactoryService;
import org.apache.derby.impl.services.monitor.TopService;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;

abstract class BaseMonitor
implements ModuleFactory,
BundleFinder {
    private HashMap serviceProviders = new HashMap();
    Vector[] implementationSets;
    private Vector services = new Vector(0, 1);
    Properties bootProperties;
    Properties applicationProperties;
    boolean inShutdown;
    private InfoStreams systemStreams;
    private ContextService contextService;
    private UUIDFactory uuidFactory;
    private TimerFactory timerFactory;
    boolean reportOn;
    private PrintStream logging;
    ThreadGroup daemonGroup;
    AntiGC dontGC;
    private InstanceGetter[] rc2;
    private Boolean exceptionTrace;
    private static final String SERVICE = "derby.service.";
    private static final HashMap storageFactories = new HashMap();
    private PrintWriter tmpWriter;
    private AccessibleByteArrayOutputStream tmpArray;
    private boolean dumpedTempWriter;
    static /* synthetic */ Class class$org$apache$derby$io$StorageFactory;

    BaseMonitor() {
        this.services.addElement(new TopService(this));
    }

    public InfoStreams getSystemStreams() {
        return this.systemStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        Object object = this;
        synchronized (object) {
            if (this.inShutdown) {
                return;
            }
            this.inShutdown = true;
        }
        this.contextService.notifyAllActiveThreads(null);
        while (true) {
            Object object2 = this;
            synchronized (object2) {
                int n = this.services.size() - 1;
                if (n == 0) {
                    // MONITOREXIT @DISABLED, blocks:[5, 9, 10] lbl14 : MonitorExitStatement: MONITOREXIT : var3_3
                    ((TopService)this.services.elementAt(0)).shutdown();
                    object = this.dontGC;
                    synchronized (object) {
                        this.dontGC.goAway = true;
                        this.dontGC.notifyAll();
                    }
                    ContextService.stop();
                    Monitor.clearMonitor();
                    return;
                }
                object = (TopService)this.services.elementAt(n);
            }
            object2 = this.contextService.newContextManager();
            try {
                ((ContextManager)object2).popContext();
                this.contextService.setCurrentContextManager((ContextManager)object2);
                this.shutdown(((TopService)object).getService());
                continue;
            }
            finally {
                this.contextService.resetCurrentContextManager((ContextManager)object2);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Object object) {
        if (object == null) {
            return;
        }
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return;
        }
        boolean bl = true;
        try {
            bl = topService.shutdown();
        }
        finally {
            BaseMonitor baseMonitor = this;
            synchronized (baseMonitor) {
                if (bl) {
                    boolean bl2 = this.services.removeElement(topService);
                }
            }
        }
    }

    protected final void runWithState(Properties properties, PrintStream printStream) {
        this.bootProperties = properties;
        this.logging = printStream;
        if (!this.initialize(false)) {
            return;
        }
        if (!Monitor.setMonitor(this)) {
            return;
        }
        Object object = MessageService.setFinder(this);
        Object[] objectArray = new Object[]{this, new Monitor(), object};
        this.dontGC = new AntiGC(objectArray);
        Thread thread = this.getDaemonThread(this.dontGC, "antiGC", true);
        thread.start();
        this.applicationProperties = this.readApplicationProperties();
        Properties properties2 = null;
        Vector vector = this.getImplementations(this.bootProperties, false);
        Vector vector2 = null;
        Vector vector3 = null;
        vector2 = this.getImplementations(properties2, false);
        vector3 = this.getImplementations(this.applicationProperties, false);
        Vector vector4 = this.getDefaultImplementations();
        int n = 0;
        if (vector != null) {
            ++n;
        }
        if (vector2 != null) {
            ++n;
        }
        if (vector3 != null) {
            ++n;
        }
        if (vector4 != null) {
            ++n;
        }
        this.implementationSets = new Vector[n];
        n = 0;
        if (vector != null) {
            this.implementationSets[n++] = vector;
        }
        if (vector2 != null) {
            this.implementationSets[n++] = vector2;
        }
        if (vector3 != null) {
            this.implementationSets[n++] = vector3;
        }
        if (vector4 != null) {
            this.implementationSets[n++] = vector4;
        }
        try {
            this.systemStreams = (InfoStreams)Monitor.startSystemModule("org.apache.derby.iapi.services.stream.InfoStreams");
            this.contextService = new ContextService();
            this.uuidFactory = (UUIDFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.uuid.UUIDFactory");
            this.timerFactory = (TimerFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.timer.TimerFactory");
            Monitor.startSystemModule("org.apache.derby.iapi.services.jmx.ManagementService");
        }
        catch (StandardException standardException) {
            this.reportException(standardException);
            this.dumpTempWriter(true);
            return;
        }
        this.dumpTempWriter(false);
        this.determineSupportedServiceProviders();
        boolean bl = Boolean.valueOf(PropertyUtil.getSystemProperty("derby.system.bootAll"));
        this.startServices(this.bootProperties, bl);
        this.startServices(properties2, bl);
        this.startServices(this.applicationProperties, bl);
        if (bl) {
            this.bootPersistentServices();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findService(String string, String string2) {
        ProtocolKey protocolKey;
        if (string2 == null) {
            return null;
        }
        try {
            protocolKey = ProtocolKey.create(string, string2);
        }
        catch (StandardException standardException) {
            return null;
        }
        TopService topService = null;
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            for (int i = 1; i < this.services.size(); ++i) {
                TopService topService2 = (TopService)this.services.elementAt(i);
                if (!topService2.isPotentialService(protocolKey)) continue;
                topService = topService2;
                break;
            }
        }
        if (topService != null && topService.isActiveService(protocolKey)) {
            return topService.getService();
        }
        return null;
    }

    public Locale getLocale(Object object) {
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        return topService.serviceLocale;
    }

    public Locale getLocaleFromString(String string) throws StandardException {
        return BaseMonitor.staticGetLocaleFromString(string);
    }

    public String getServiceName(Object object) {
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        return topService.getServiceType().getUserServiceName(topService.getKey().getIdentifier());
    }

    public Locale setLocale(Object object, String string) throws StandardException {
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        PersistentService persistentService = topService.getServiceType();
        if (persistentService == null) {
            return null;
        }
        String string2 = topService.getKey().getIdentifier();
        Properties properties = persistentService.getServiceProperties(string2, null);
        properties = new UpdateServiceProperties(persistentService, string2, properties, true);
        return this.setLocale(properties, string);
    }

    public Locale setLocale(Properties properties, String string) throws StandardException {
        Locale locale = BaseMonitor.staticGetLocaleFromString(string);
        properties.put("derby.serviceLocale", locale.toString());
        return locale;
    }

    public PersistentService getServiceType(Object object) {
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        return topService.getServiceType();
    }

    public Object startModule(boolean bl, Object object, String string, String string2, Properties properties) throws StandardException {
        ProtocolKey protocolKey = ProtocolKey.create(string, string2);
        TopService topService = this.findTopService(object);
        Object object2 = topService.bootModule(bl, object, protocolKey, properties);
        if (object2 == null) {
            throw Monitor.missingImplementation(string);
        }
        return object2;
    }

    private synchronized TopService findTopService(Object object) {
        if (object == null) {
            return (TopService)this.services.elementAt(0);
        }
        for (int i = 1; i < this.services.size(); ++i) {
            TopService topService = (TopService)this.services.elementAt(i);
            if (!topService.inService(object)) continue;
            return topService;
        }
        return null;
    }

    public Object findModule(Object object, String string, String string2) {
        ProtocolKey protocolKey;
        try {
            protocolKey = ProtocolKey.create(string, string2);
        }
        catch (StandardException standardException) {
            return null;
        }
        TopService topService = this.findTopService(object);
        if (topService == null) {
            return null;
        }
        return topService.findModule(protocolKey, true, null);
    }

    public InstanceGetter classFromIdentifier(int n) throws StandardException {
        String string;
        InstanceGetter[] instanceGetterArray;
        int n2;
        try {
            InstanceGetter instanceGetter;
            n2 = n - 0;
            instanceGetterArray = this.rc2;
            if (instanceGetterArray == null) {
                instanceGetterArray = this.rc2 = new InstanceGetter[RegisteredFormatIds.TwoByte.length];
            }
            if ((instanceGetter = instanceGetterArray[n2]) != null) {
                return instanceGetter;
            }
            string = RegisteredFormatIds.TwoByte[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            string = null;
            instanceGetterArray = null;
            n2 = 0;
        }
        if (string != null) {
            Throwable throwable;
            try {
                Class<?> clazz = Class.forName(string);
                if (FormatableInstanceGetter.class.isAssignableFrom(clazz)) {
                    FormatableInstanceGetter formatableInstanceGetter = (FormatableInstanceGetter)clazz.newInstance();
                    formatableInstanceGetter.setFormatId(n);
                    instanceGetterArray[n2] = formatableInstanceGetter;
                    return instanceGetterArray[n2];
                }
                instanceGetterArray[n2] = new ClassInfo(clazz);
                return instanceGetterArray[n2];
            }
            catch (ClassNotFoundException classNotFoundException) {
                throwable = classNotFoundException;
            }
            catch (IllegalAccessException illegalAccessException) {
                throwable = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                throwable = instantiationException;
            }
            catch (LinkageError linkageError) {
                throwable = linkageError;
            }
            throw StandardException.newException("XBM0V.S", throwable, (Object)FormatIdUtil.formatIdToString(n), (Object)string);
        }
        throw StandardException.newException("XBM0U.S", FormatIdUtil.formatIdToString(n));
    }

    public Object newInstanceFromIdentifier(int n) throws StandardException {
        Throwable throwable;
        InstanceGetter instanceGetter = this.classFromIdentifier(n);
        try {
            Object object = instanceGetter.getNewInstance();
            return object;
        }
        catch (InstantiationException instantiationException) {
            throwable = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            throwable = illegalAccessException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throwable = invocationTargetException;
        }
        catch (LinkageError linkageError) {
            throwable = linkageError;
        }
        throw StandardException.newException("XBM0W.S", throwable, (Object)new Integer(n), (Object)"XX");
    }

    protected Object loadInstance(Class clazz, Properties properties) {
        Object object = null;
        Vector vector = this.getImplementations(properties, false);
        if (vector != null) {
            object = this.loadInstance(vector, clazz, properties);
        }
        for (int i = 0; i < this.implementationSets.length && (object = this.loadInstance(this.implementationSets[i], clazz, properties)) == null; ++i) {
        }
        return object;
    }

    private Object loadInstance(Vector vector, Class clazz, Properties properties) {
        int n = 0;
        while ((n = BaseMonitor.findImplementation(vector, n, clazz)) >= 0) {
            Object object = this.newInstance((Class)vector.elementAt(n));
            if (BaseMonitor.canSupport(object, properties)) {
                return object;
            }
            ++n;
        }
        return null;
    }

    private static int findImplementation(Vector vector, int n, Class clazz) {
        for (int i = n; i < vector.size(); ++i) {
            Class clazz2 = (Class)vector.elementAt(i);
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return i;
        }
        return -1;
    }

    private Object newInstance(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.report(string + " " + classNotFoundException.toString());
        }
        catch (InstantiationException instantiationException) {
            this.report(string + " " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.report(string + " " + illegalAccessException.toString());
        }
        catch (LinkageError linkageError) {
            this.report(string + " " + linkageError.toString());
            this.reportException(linkageError);
        }
        return null;
    }

    private Object newInstance(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            this.report(clazz.getName() + " " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            this.report(clazz.getName() + " " + illegalAccessException.toString());
        }
        catch (LinkageError linkageError) {
            this.report(clazz.getName() + " " + linkageError.toString());
            this.reportException(linkageError);
        }
        return null;
    }

    public Properties getApplicationProperties() {
        return this.applicationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getServiceList(String string) {
        BaseMonitor baseMonitor = this;
        synchronized (baseMonitor) {
            TopService topService;
            int n = 0;
            for (int i = 1; i < this.services.size(); ++i) {
                topService = (TopService)this.services.elementAt(i);
                if (!topService.isActiveService() || !topService.getKey().getFactoryInterface().getName().equals(string)) continue;
                ++n;
            }
            String[] stringArray = new String[n];
            if (n != 0) {
                int n2 = 0;
                for (int i = 1; i < this.services.size(); ++i) {
                    topService = (TopService)this.services.elementAt(i);
                    if (!topService.isActiveService() || !topService.getKey().getFactoryInterface().getName().equals(string)) continue;
                    stringArray[n2++] = topService.getServiceType().getUserServiceName(topService.getKey().getIdentifier());
                    if (n2 == n) break;
                }
            }
            return stringArray;
        }
    }

    void dumpProperties(String string, Properties properties) {
    }

    protected void report(String string) {
        PrintWriter printWriter = this.getTempWriter();
        if (printWriter != null) {
            printWriter.println(string);
        }
        if (this.systemStreams != null) {
            this.systemStreams.stream().printlnWithHeader(string);
        }
    }

    protected void reportException(Throwable throwable) {
        PrintWriterGetHeader printWriterGetHeader = null;
        if (this.systemStreams != null) {
            printWriterGetHeader = this.systemStreams.stream().getHeader();
        }
        ErrorStringBuilder errorStringBuilder = new ErrorStringBuilder(printWriterGetHeader);
        errorStringBuilder.appendln(throwable.getMessage());
        errorStringBuilder.stackTrace(throwable);
        this.report(errorStringBuilder.get().toString());
    }

    private void addDebugFlags(String string, boolean bl) {
    }

    public void startServices(Properties properties, boolean bl) {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(SERVICE)) continue;
            String string2 = string.substring(SERVICE.length());
            String string3 = properties.getProperty(string);
            try {
                if (string3.equals("serviceDirectory")) {
                    if (!bl) continue;
                    this.findProviderAndStartService(string2, properties, true);
                    continue;
                }
                this.bootService(null, string3, string2, null, false);
            }
            catch (StandardException standardException) {
                if (string3.equals("serviceDirectory")) continue;
                this.reportException(standardException);
            }
        }
    }

    public final boolean startPersistentService(String string, Properties properties) throws StandardException {
        return this.findProviderAndStartService(string, properties, false);
    }

    public Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        PersistentService persistentService = this.findProviderForCreate(string2);
        if (persistentService == null) {
            throw StandardException.newException("XBM0K.D", string2);
        }
        return this.bootService(persistentService, string, string2, properties, true);
    }

    public void removePersistentService(String string) throws StandardException {
        String string2;
        PersistentService persistentService = null;
        persistentService = this.findProviderForCreate(string);
        boolean bl = persistentService.removeServiceRoot(string2 = persistentService.getCanonicalServiceName(string));
        if (!bl) {
            throw StandardException.newException("XBM0I.D", string2);
        }
    }

    public Object startNonPersistentService(String string, String string2, Properties properties) throws StandardException {
        return this.bootService(null, string, string2, properties, false);
    }

    private Vector getImplementations(Properties properties, boolean bl) {
        if (properties == null) {
            return null;
        }
        Vector vector = bl ? new Vector(properties.size()) : new Vector(0, 1);
        int n = JVMInfo.JDK_ID;
        int[] nArray = new int[n + 1];
        Enumeration<?> enumeration = properties.propertyNames();
        block6: while (enumeration.hasMoreElements()) {
            Object object;
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.startsWith("derby.module.")) {
                string = string2.substring("derby.module.".length());
            } else {
                if (!string2.startsWith("derby.subSubProtocol.")) continue;
                string = string2.substring("derby.module.".length());
            }
            String string3 = "derby.env.jdk.".concat(string);
            String string4 = properties.getProperty(string3);
            int n2 = 0;
            if (string4 != null && (n2 = Integer.parseInt(string4.trim())) > n) continue;
            string3 = "derby.env.classes.".concat(string);
            String string5 = properties.getProperty(string3);
            if (string5 != null) {
                object = new StringTokenizer(string5, ",");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    try {
                        Class.forName(((StringTokenizer)object).nextToken().trim());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        continue block6;
                    }
                    catch (LinkageError linkageError) {
                        continue block6;
                    }
                }
            }
            object = properties.getProperty(string2);
            try {
                Class<?> clazz = Class.forName((String)object);
                if (this.getPersistentServiceImplementation(clazz)) continue;
                if ((class$org$apache$derby$io$StorageFactory == null ? BaseMonitor.class$("org.apache.derby.io.StorageFactory") : class$org$apache$derby$io$StorageFactory).isAssignableFrom(clazz)) {
                    storageFactories.put(string, object);
                    continue;
                }
                if (n2 != 0) {
                    int n3 = 0;
                    for (int i = n; i > n2; --i) {
                        n3 += nArray[i];
                    }
                    vector.insertElementAt(clazz, n3);
                    int n4 = n2;
                    nArray[n4] = nArray[n4] + 1;
                    continue;
                }
                vector.addElement(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.report("Class " + (String)object + " " + classNotFoundException.toString() + ", module ignored.");
            }
            catch (LinkageError linkageError) {
                this.report("Class " + (String)object + " " + linkageError.toString() + ", module ignored.");
            }
        }
        if (vector.isEmpty()) {
            return null;
        }
        vector.trimToSize();
        return vector;
    }

    private boolean getPersistentServiceImplementation(Class clazz) {
        if (!PersistentService.class.isAssignableFrom(clazz)) {
            return false;
        }
        PersistentService persistentService = (PersistentService)this.newInstance(clazz);
        if (persistentService == null) {
            this.report("Class " + clazz.getName() + " cannot create instance, module ignored.");
        } else {
            this.serviceProviders.put(persistentService.getType(), persistentService);
        }
        return true;
    }

    private Vector getDefaultImplementations() {
        Properties properties = this.getDefaultModuleProperties();
        return this.getImplementations(properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties getDefaultModuleProperties() {
        Properties properties = new Properties();
        boolean bl = true;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Enumeration<URL> enumeration;
            Enumeration<URL> enumeration2 = enumeration = classLoader == null ? ClassLoader.getSystemResources("org/apache/derby/modules.properties") : classLoader.getResources("org/apache/derby/modules.properties");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStream inputStream = null;
                try {
                    inputStream = uRL.openStream();
                    if (bl) {
                        properties.load(inputStream);
                        bl = false;
                        continue;
                    }
                    Properties properties2 = new Properties();
                    properties2.load(inputStream);
                    Enumeration<Object> enumeration3 = properties2.keys();
                    while (enumeration3.hasMoreElements()) {
                        String string = (String)enumeration3.nextElement();
                        if (properties.contains(string)) {
                            this.report("Ignored duplicate property " + string + " in " + uRL.toString());
                            continue;
                        }
                        properties.setProperty(string, properties2.getProperty(string));
                    }
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    protected static Properties removeRuntimeProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("derby.__rt.")) continue;
            properties2.put(string, properties.get(string));
        }
        return properties2;
    }

    abstract InputStream applicationPropertiesStream() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties readApplicationProperties() {
        Properties properties;
        InputStream inputStream = null;
        try {
            inputStream = this.applicationPropertiesStream();
            if (inputStream == null) {
                Properties properties2 = null;
                return properties2;
            }
            Properties properties3 = new Properties();
            org.apache.derby.iapi.util.PropertyUtil.loadWithTrimmedValues(new BufferedInputStream(inputStream), properties3);
            properties = properties3;
        }
        catch (SecurityException securityException) {
            Properties properties4 = null;
            return properties4;
        }
        catch (IOException iOException) {
            this.report(iOException.toString() + " (" + "derby.properties" + ")");
            this.reportException(iOException);
            Properties properties5 = null;
            return properties5;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (IOException iOException) {}
        }
        return properties;
    }

    private void determineSupportedServiceProviders() {
        Iterator iterator = this.serviceProviders.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (BaseMonitor.canSupport(v, null)) continue;
            iterator.remove();
        }
    }

    private void bootPersistentServices() {
        ProviderEnumeration providerEnumeration = new ProviderEnumeration(this.applicationProperties);
        while (providerEnumeration.hasMoreElements()) {
            PersistentService persistentService = (PersistentService)providerEnumeration.nextElement();
            this.bootProviderServices(persistentService);
        }
    }

    protected void bootProviderServices(PersistentService persistentService) {
        Enumeration enumeration = persistentService.getBootTimeServices();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Properties properties;
            String string = (String)enumeration.nextElement();
            try {
                properties = persistentService.getServiceProperties(string, null);
            }
            catch (StandardException standardException) {
                this.report("Failed to load service properties, name: " + string + ", type = " + persistentService.getType());
                this.reportException(standardException);
                continue;
            }
            if (Boolean.valueOf(properties.getProperty("derby.database.noAutoBoot")).booleanValue()) continue;
            try {
                this.startProviderService(persistentService, string, properties);
            }
            catch (StandardException standardException) {
                this.report("Service failed to boot, name: " + string + ", type = " + persistentService.getType());
                this.reportException(standardException);
            }
        }
    }

    private boolean findProviderAndStartService(String string, Properties properties, boolean bl) throws StandardException {
        PersistentService persistentService = null;
        Properties properties2 = null;
        String string2 = null;
        int n = string.indexOf(58);
        if (n != -1 && (persistentService = this.findProviderFromName(string, n)) != null) {
            string2 = persistentService.getCanonicalServiceName(string);
            if (string2 == null) {
                return true;
            }
            properties2 = persistentService.getServiceProperties(string2, properties);
            if (properties2 == null) {
                return true;
            }
            if (bl && Boolean.valueOf(properties2.getProperty("derby.database.noAutoBoot")).booleanValue()) {
                return true;
            }
            this.startProviderService(persistentService, string2, properties2);
            return true;
        }
        StandardException standardException = null;
        ProviderEnumeration providerEnumeration = new ProviderEnumeration(properties);
        while (providerEnumeration.hasMoreElements()) {
            PersistentService persistentService2 = (PersistentService)providerEnumeration.nextElement();
            String string3 = persistentService2.getCanonicalServiceName(string);
            if (string3 == null) continue;
            Properties properties3 = null;
            try {
                properties3 = persistentService2.getServiceProperties(string3, properties);
                if (properties3 == null) {
                    continue;
                }
            }
            catch (StandardException standardException2) {
                standardException = standardException2;
            }
            if (persistentService == null) {
                persistentService = persistentService2;
                string2 = string3;
                properties2 = properties3;
                continue;
            }
            throw StandardException.newException("XBM0T.D", string);
        }
        if (persistentService == null) {
            return n == -1;
        }
        if (standardException != null) {
            throw standardException;
        }
        if (bl && Boolean.valueOf(properties2.getProperty("derby.database.noAutoBoot")).booleanValue()) {
            return true;
        }
        this.startProviderService(persistentService, string2, properties2);
        return true;
    }

    protected PersistentService findProviderForCreate(String string) throws StandardException {
        return this.findProviderFromName(string, string.indexOf(58));
    }

    private PersistentService findProviderFromName(String string, int n) throws StandardException {
        if (n == 0) {
            return null;
        }
        String string2 = n < 2 ? "directory" : string.substring(0, n);
        return this.getServiceProvider(string2);
    }

    public PersistentService getServiceProvider(String string) throws StandardException {
        PersistentService persistentService;
        if (string == null) {
            return null;
        }
        if (this.serviceProviders != null && (persistentService = (PersistentService)this.serviceProviders.get(string)) != null) {
            return persistentService;
        }
        return this.getPersistentService(string);
    }

    private PersistentService getPersistentService(String string) throws StandardException {
        String string2 = this.getStorageFactoryClassName(string);
        return this.getPersistentService(string2, string);
    }

    private PersistentService getPersistentService(String string, String string2) throws StandardException {
        if (string == null) {
            return null;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
        }
        catch (Throwable throwable) {
            throw StandardException.newException("XBM08.D", throwable, (Object)string2, (Object)string);
        }
        return new StorageFactoryService(string2, clazz);
    }

    private String getStorageFactoryClassName(String string) {
        String string2 = "derby.subSubProtocol." + string;
        String string3 = PropertyUtil.getSystemProperty(string2);
        if (string3 != null) {
            return string3;
        }
        return (String)storageFactories.get(string);
    }

    protected void startProviderService(PersistentService persistentService, String string, Properties properties) throws StandardException {
        String string2 = properties.getProperty("derby.serviceProtocol");
        if (string2 == null) {
            throw StandardException.newException("XCY03.S", "derby.serviceProtocol");
        }
        this.bootService(persistentService, string2, string, properties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected Object bootService(PersistentService persistentService, String string, String string2, Properties properties, boolean bl) throws StandardException {
        Object object;
        Object object2;
        ContextManager contextManager;
        if (persistentService != null) {
            string2 = persistentService.getCanonicalServiceName(string2);
        }
        ProtocolKey protocolKey = ProtocolKey.create(string, string2);
        ContextManager contextManager2 = contextManager = this.contextService.getCurrentContextManager();
        TopService topService = null;
        Context context = null;
        try {
            boolean bl2;
            Object object3 = this;
            // MONITORENTER : object3
            if (this.inShutdown) {
                throw StandardException.newException("XJ015.M");
            }
            for (int i = 1; i < this.services.size(); ++i) {
                object2 = (TopService)this.services.elementAt(i);
                if (!((TopService)object2).isPotentialService(protocolKey)) continue;
                Object var15_20 = null;
                // MONITOREXIT : object3
                return var15_20;
            }
            Object object4 = null;
            if (bl) {
                properties = new Properties(properties);
                object4 = BaseMonitor.setLocale(properties);
                properties.put("derby.serviceProtocol", string);
                string2 = persistentService.createServiceRoot(string2, Boolean.valueOf(properties.getProperty("derby.__deleteOnCreate")));
                protocolKey = ProtocolKey.create(string, string2);
            } else if (properties != null && (object2 = properties.getProperty("derby.serviceLocale")) != null) {
                object4 = BaseMonitor.staticGetLocaleFromString((String)object2);
            }
            topService = new TopService(this, protocolKey, persistentService, (Locale)object4);
            this.services.addElement(topService);
            // MONITOREXIT : object3
            if (properties != null) {
                properties.put("derby.__rt.serviceDirectory", string2);
                properties.put("derby.__rt.serviceType", persistentService.getType());
            }
            if (contextManager == null) {
                contextManager2 = this.contextService.newContextManager();
                this.contextService.setCurrentContextManager(contextManager2);
            }
            context = new ServiceBootContext(contextManager2);
            boolean bl3 = properties != null ? properties.getProperty("derby.__rt.inRestore") != null : (bl2 = false);
            if (persistentService != null && properties != null) {
                object4 = object3 = new UpdateServiceProperties(persistentService, string2, properties, !bl && !bl2);
            } else {
                object3 = null;
                object4 = properties;
            }
            object = topService.bootModule(bl, null, protocolKey, (Properties)object4);
            if (bl || bl2) {
                persistentService.saveServiceProperties(string2, ((UpdateServiceProperties)object3).getStorageFactory(), BaseMonitor.removeRuntimeProperties(properties), false);
                ((UpdateServiceProperties)object3).setServiceBooted();
            }
            if (contextManager2 != contextManager) {
                contextManager2.cleanupOnError(StandardException.closeException());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            StandardException standardException = throwable instanceof StandardException && ((StandardException)throwable).getSeverity() == 45000 ? (StandardException)throwable : Monitor.exceptionStartingModule(throwable);
            if (contextManager2 != contextManager) {
                contextManager2.cleanupOnError(standardException);
            }
            if (topService != null) {
                boolean bl4;
                topService.shutdown();
                object2 = this;
                // MONITORENTER : object2
                this.services.removeElement(topService);
                // MONITOREXIT : object2
                boolean bl5 = properties != null ? properties.getProperty("derby.__rt.deleteRootOnError") != null : (bl4 = false);
                if (bl || bl4) {
                    persistentService.removeServiceRoot(string2);
                }
            }
            if (!((throwable2 = standardException.getCause()) instanceof ThreadDeath)) throw standardException;
            throw (ThreadDeath)throwable2;
        }
        finally {
            if (contextManager == contextManager2 && context != null) {
                context.popMe();
            }
            if (contextManager == null) {
                this.contextService.resetCurrentContextManager(contextManager2);
            }
        }
        topService.setTopModule(object);
        Thread.yield();
        return object;
    }

    public UUIDFactory getUUIDFactory() {
        return this.uuidFactory;
    }

    public TimerFactory getTimerFactory() {
        return this.timerFactory;
    }

    private PrintWriter getTempWriter() {
        if (this.tmpWriter == null && !this.dumpedTempWriter) {
            this.tmpArray = new AccessibleByteArrayOutputStream();
            this.tmpWriter = new PrintWriter(this.tmpArray);
        }
        return this.tmpWriter;
    }

    private void dumpTempWriter(boolean bl) {
        if (this.tmpWriter == null) {
            return;
        }
        this.tmpWriter.flush();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.tmpArray.getInternalByteArray())));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (this.systemStreams != null) {
                    this.systemStreams.stream().printlnWithHeader(string);
                }
                if (this.systemStreams != null && !bl) continue;
                this.logging.println(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.systemStreams == null || bl) {
            this.logging.flush();
        }
        this.tmpWriter = null;
        this.tmpArray = null;
        this.dumpedTempWriter = true;
        this.logging = null;
    }

    static boolean canSupport(Object object, Properties properties) {
        return !(object instanceof ModuleSupportable) || ((ModuleSupportable)object).canSupport(properties);
    }

    static void boot(Object object, boolean bl, Properties properties) throws StandardException {
        if (object instanceof ModuleControl) {
            ((ModuleControl)object).boot(bl, properties);
        }
    }

    private static Locale staticGetLocaleFromString(String string) throws StandardException {
        String string2;
        boolean bl;
        int n = string.length();
        boolean bl2 = bl = n == 2 || n == 5 || n > 6;
        if (bl && n != 2) {
            boolean bl3 = bl = string.charAt(2) == '_';
        }
        if (bl && n > 5) {
            boolean bl4 = bl = string.charAt(5) == '_';
        }
        if (!bl) {
            throw StandardException.newException("XBM0X.D", string);
        }
        String string3 = string.substring(0, 2);
        String string4 = string2 = n == 2 ? "" : string.substring(3, 5);
        if (n < 6) {
            return new Locale(string3, string2);
        }
        String string5 = n > 6 ? string.substring(6, n) : null;
        return new Locale(string3, string2, string5);
    }

    private static Locale setLocale(Properties properties) throws StandardException {
        String string = properties.getProperty("territory");
        Locale locale = string == null ? Locale.getDefault() : BaseMonitor.staticGetLocaleFromString(string);
        properties.put("derby.serviceLocale", locale.toString());
        return locale;
    }

    public ResourceBundle getBundle(String string) {
        ContextManager contextManager;
        try {
            contextManager = ContextService.getFactory().getCurrentContextManager();
        }
        catch (ShutdownException shutdownException) {
            contextManager = null;
        }
        if (contextManager != null) {
            return MessageService.getBundleForLocale(contextManager.getMessageLocale(), string);
        }
        return null;
    }

    public Thread getDaemonThread(Runnable runnable, String string, boolean bl) {
        Thread thread = new Thread(this.daemonGroup, runnable, "derby.".concat(string));
        thread.setDaemon(true);
        if (bl) {
            thread.setPriority(1);
        }
        return thread;
    }

    public void setThreadPriority(int n) {
        Thread thread = Thread.currentThread();
        if (thread.getThreadGroup() == this.daemonGroup) {
            thread.setPriority(n);
        }
    }

    abstract boolean initialize(boolean var1);

    static {
        String string = !JVMInfo.J2ME && JVMInfo.JDK_ID >= 4 ? "org.apache.derby.impl.io.DirStorageFactory4" : "org.apache.derby.impl.io.DirStorageFactory";
        storageFactories.put("directory", string);
        storageFactories.put("classpath", "org.apache.derby.impl.io.CPStorageFactory");
        storageFactories.put("jar", "org.apache.derby.impl.io.JarStorageFactory");
        storageFactories.put("http", "org.apache.derby.impl.io.URLStorageFactory");
        storageFactories.put("https", "org.apache.derby.impl.io.URLStorageFactory");
    }

    class ProviderEnumeration
    implements Enumeration {
        private Enumeration serviceProvidersKeys;
        private Properties startParams;
        private Enumeration paramEnumeration;
        private boolean enumeratedDirectoryProvider;
        private PersistentService storageFactoryPersistentService;

        ProviderEnumeration(Properties properties) {
            this.serviceProvidersKeys = BaseMonitor.this.serviceProviders == null ? null : Collections.enumeration(BaseMonitor.this.serviceProviders.keySet());
            this.startParams = properties;
            if (properties != null) {
                this.paramEnumeration = properties.keys();
            }
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.serviceProvidersKeys != null && this.serviceProvidersKeys.hasMoreElements()) {
                return BaseMonitor.this.serviceProviders.get(this.serviceProvidersKeys.nextElement());
            }
            this.getNextStorageFactory();
            PersistentService persistentService = this.storageFactoryPersistentService;
            this.storageFactoryPersistentService = null;
            return persistentService;
        }

        private void getNextStorageFactory() {
            if (this.storageFactoryPersistentService != null) {
                return;
            }
            if (this.paramEnumeration != null) {
                while (this.paramEnumeration.hasMoreElements()) {
                    String string = (String)this.paramEnumeration.nextElement();
                    if (!string.startsWith("derby.subSubProtocol.")) continue;
                    try {
                        String string2 = (String)this.startParams.get(string);
                        if (string2 == null) continue;
                        this.storageFactoryPersistentService = BaseMonitor.this.getPersistentService((String)this.startParams.get(string), string.substring("derby.subSubProtocol.".length()));
                        if (this.storageFactoryPersistentService == null) continue;
                        return;
                    }
                    catch (StandardException standardException) {
                    }
                }
            }
            if (!this.enumeratedDirectoryProvider) {
                try {
                    this.storageFactoryPersistentService = BaseMonitor.this.getPersistentService(BaseMonitor.this.getStorageFactoryClassName("directory"), "directory");
                }
                catch (StandardException standardException) {
                    this.storageFactoryPersistentService = null;
                }
                this.enumeratedDirectoryProvider = true;
            }
        }

        public boolean hasMoreElements() {
            if (this.serviceProvidersKeys != null && this.serviceProvidersKeys.hasMoreElements()) {
                return true;
            }
            this.getNextStorageFactory();
            return this.storageFactoryPersistentService != null;
        }
    }
}

