/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractPoller;
import sun.nio.fs.AbstractWatchKey;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class LinuxWatchService
extends AbstractWatchService {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private final Poller poller;

    LinuxWatchService(UnixFileSystem unixFileSystem) throws IOException {
        int n = -1;
        try {
            n = LinuxWatchService.inotifyInit();
        }
        catch (UnixException unixException) {
            throw new IOException(unixException.errorString());
        }
        int[] nArray = new int[2];
        try {
            LinuxWatchService.configureBlocking(n, false);
            LinuxWatchService.socketpair(nArray);
            LinuxWatchService.configureBlocking(nArray[0], false);
        }
        catch (UnixException unixException) {
            UnixNativeDispatcher.close(n);
            throw new IOException(unixException.errorString());
        }
        this.poller = new Poller(unixFileSystem, this, n, nArray);
        this.poller.start();
    }

    @Override
    WatchKey register(Path path, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        return this.poller.register(path, kindArray, modifierArray);
    }

    @Override
    void implClose() throws IOException {
        this.poller.close();
    }

    private static native int eventSize();

    private static native int[] eventOffsets();

    private static native int inotifyInit() throws UnixException;

    private static native int inotifyAddWatch(int var0, long var1, int var3) throws UnixException;

    private static native void inotifyRmWatch(int var0, int var1) throws UnixException;

    private static native void configureBlocking(int var0, boolean var1) throws UnixException;

    private static native void socketpair(int[] var0) throws UnixException;

    private static native int poll(int var0, int var1) throws UnixException;

    static /* synthetic */ int access$200() {
        return LinuxWatchService.eventSize();
    }

    static /* synthetic */ int[] access$300() {
        return LinuxWatchService.eventOffsets();
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("nio");
                return null;
            }
        });
    }

    private static class LinuxWatchKey
    extends AbstractWatchKey {
        private final int ifd;
        private volatile int wd;

        LinuxWatchKey(UnixPath unixPath, LinuxWatchService linuxWatchService, int n, int n2) {
            super(unixPath, linuxWatchService);
            this.ifd = n;
            this.wd = n2;
        }

        int descriptor() {
            return this.wd;
        }

        void invalidate(boolean bl) {
            if (bl) {
                try {
                    LinuxWatchService.inotifyRmWatch(this.ifd, this.wd);
                }
                catch (UnixException unixException) {
                    // empty catch block
                }
            }
            this.wd = -1;
        }

        @Override
        public boolean isValid() {
            return this.wd != -1;
        }

        @Override
        public void cancel() {
            if (this.isValid()) {
                ((LinuxWatchService)this.watcher()).poller.cancel(this);
            }
        }
    }

    private static class Poller
    extends AbstractPoller {
        private static final int SIZEOF_INOTIFY_EVENT = LinuxWatchService.access$200();
        private static final int[] offsets = LinuxWatchService.access$300();
        private static final int OFFSETOF_WD = offsets[0];
        private static final int OFFSETOF_MASK = offsets[1];
        private static final int OFFSETOF_LEN = offsets[3];
        private static final int OFFSETOF_NAME = offsets[4];
        private static final int IN_MODIFY = 2;
        private static final int IN_ATTRIB = 4;
        private static final int IN_MOVED_FROM = 64;
        private static final int IN_MOVED_TO = 128;
        private static final int IN_CREATE = 256;
        private static final int IN_DELETE = 512;
        private static final int IN_UNMOUNT = 8192;
        private static final int IN_Q_OVERFLOW = 16384;
        private static final int IN_IGNORED = 32768;
        private static final int BUFFER_SIZE = 8192;
        private final UnixFileSystem fs;
        private final LinuxWatchService watcher;
        private final int ifd;
        private final int[] socketpair;
        private final Map<Integer, LinuxWatchKey> wdToKey;
        private final long address;

        Poller(UnixFileSystem unixFileSystem, LinuxWatchService linuxWatchService, int n, int[] nArray) {
            this.fs = unixFileSystem;
            this.watcher = linuxWatchService;
            this.ifd = n;
            this.socketpair = nArray;
            this.wdToKey = new HashMap<Integer, LinuxWatchKey>();
            this.address = unsafe.allocateMemory(8192L);
        }

        @Override
        void wakeup() throws IOException {
            try {
                UnixNativeDispatcher.write(this.socketpair[1], this.address, 1);
            }
            catch (UnixException unixException) {
                throw new IOException(unixException.errorString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Object implRegister(Path path, Set<? extends WatchEvent.Kind<?>> set, WatchEvent.Modifier ... modifierArray) {
            Object object;
            UnixPath unixPath = (UnixPath)path;
            int n = 0;
            for (WatchEvent.Kind<?> kind : set) {
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    n |= 0x180;
                    continue;
                }
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    n |= 0x240;
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                n |= 6;
            }
            if (modifierArray.length > 0) {
                for (WatchEvent.Modifier modifier : modifierArray) {
                    if (modifier == null) {
                        return new NullPointerException();
                    }
                    if (modifier instanceof SensitivityWatchEventModifier) continue;
                    return new UnsupportedOperationException("Modifier not supported");
                }
            }
            Object object2 = null;
            try {
                object2 = UnixFileAttributes.get(unixPath, true);
            }
            catch (UnixException unixException) {
                return unixException.asIOException(unixPath);
            }
            if (!((UnixFileAttributes)object2).isDirectory()) {
                return new NotDirectoryException(unixPath.getPathForExceptionMessage());
            }
            int n2 = -1;
            try {
                object = NativeBuffers.asNativeBuffer(unixPath.getByteArrayForSysCalls());
                try {
                    n2 = LinuxWatchService.inotifyAddWatch(this.ifd, ((NativeBuffer)object).address(), n);
                }
                finally {
                    ((NativeBuffer)object).release();
                }
            }
            catch (UnixException unixException) {
                if (unixException.errno() == 28) {
                    return new IOException("User limit of inotify watches reached");
                }
                return unixException.asIOException(unixPath);
            }
            object = this.wdToKey.get(n2);
            if (object == null) {
                object = new LinuxWatchKey(unixPath, this.watcher, this.ifd, n2);
                this.wdToKey.put(n2, (LinuxWatchKey)object);
            }
            return object;
        }

        @Override
        void implCancelKey(WatchKey watchKey) {
            LinuxWatchKey linuxWatchKey = (LinuxWatchKey)watchKey;
            if (linuxWatchKey.isValid()) {
                this.wdToKey.remove(linuxWatchKey.descriptor());
                linuxWatchKey.invalidate(true);
            }
        }

        @Override
        void implCloseAll() {
            for (Map.Entry<Integer, LinuxWatchKey> entry : this.wdToKey.entrySet()) {
                entry.getValue().invalidate(true);
            }
            this.wdToKey.clear();
            unsafe.freeMemory(this.address);
            UnixNativeDispatcher.close(this.socketpair[0]);
            UnixNativeDispatcher.close(this.socketpair[1]);
            UnixNativeDispatcher.close(this.ifd);
        }

        @Override
        public void run() {
            try {
                block6: while (true) {
                    int n;
                    block13: {
                        int n2 = LinuxWatchService.poll(this.ifd, this.socketpair[0]);
                        try {
                            n = UnixNativeDispatcher.read(this.ifd, this.address, 8192);
                        }
                        catch (UnixException unixException) {
                            if (unixException.errno() != 11) {
                                throw unixException;
                            }
                            n = 0;
                        }
                        if (n2 > 1 || n2 == 1 && n == 0) {
                            try {
                                UnixNativeDispatcher.read(this.socketpair[0], this.address, 8192);
                                boolean bl = this.processRequests();
                                if (!bl) break block13;
                                break;
                            }
                            catch (UnixException unixException) {
                                if (unixException.errno() == 11) break block13;
                                throw unixException;
                            }
                        }
                    }
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n) continue block6;
                        long l = this.address + (long)n3;
                        int n4 = unsafe.getInt(l + (long)OFFSETOF_WD);
                        int n5 = unsafe.getInt(l + (long)OFFSETOF_MASK);
                        int n6 = unsafe.getInt(l + (long)OFFSETOF_LEN);
                        UnixPath unixPath = null;
                        if (n6 > 0) {
                            int n7;
                            for (n7 = n6; n7 > 0; --n7) {
                                long l2 = l + (long)OFFSETOF_NAME + (long)n7 - 1L;
                                if (unsafe.getByte(l2) != 0) break;
                            }
                            if (n7 > 0) {
                                byte[] byArray = new byte[n7];
                                unsafe.copyMemory(null, l + (long)OFFSETOF_NAME, byArray, Unsafe.ARRAY_BYTE_BASE_OFFSET, n7);
                                unixPath = new UnixPath(this.fs, byArray);
                            }
                        }
                        this.processEvent(n4, n5, unixPath);
                        n3 += SIZEOF_INOTIFY_EVENT + n6;
                    }
                    break;
                }
            }
            catch (UnixException unixException) {
                unixException.printStackTrace();
            }
        }

        private WatchEvent.Kind<?> maskToEventKind(int n) {
            if ((n & 2) > 0) {
                return StandardWatchEventKinds.ENTRY_MODIFY;
            }
            if ((n & 4) > 0) {
                return StandardWatchEventKinds.ENTRY_MODIFY;
            }
            if ((n & 0x100) > 0) {
                return StandardWatchEventKinds.ENTRY_CREATE;
            }
            if ((n & 0x80) > 0) {
                return StandardWatchEventKinds.ENTRY_CREATE;
            }
            if ((n & 0x200) > 0) {
                return StandardWatchEventKinds.ENTRY_DELETE;
            }
            if ((n & 0x40) > 0) {
                return StandardWatchEventKinds.ENTRY_DELETE;
            }
            return null;
        }

        private void processEvent(int n, int n2, UnixPath unixPath) {
            if ((n2 & 0x4000) > 0) {
                for (Map.Entry<Integer, LinuxWatchKey> entry : this.wdToKey.entrySet()) {
                    entry.getValue().signalEvent(StandardWatchEventKinds.OVERFLOW, null);
                }
                return;
            }
            LinuxWatchKey linuxWatchKey = this.wdToKey.get(n);
            if (linuxWatchKey == null) {
                return;
            }
            if ((n2 & 0x8000) > 0) {
                this.wdToKey.remove(n);
                linuxWatchKey.invalidate(false);
                linuxWatchKey.signal();
                return;
            }
            if (unixPath == null) {
                return;
            }
            WatchEvent.Kind<?> kind = this.maskToEventKind(n2);
            if (kind != null) {
                linuxWatchKey.signalEvent(kind, unixPath);
            }
        }
    }
}

