/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.system;

import cn.com.voltronic.solar.communicate.ICommunicateDevice;
import cn.com.voltronic.solar.data.bean.LocalComs;
import cn.com.voltronic.solar.exception.EventsHandler;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.view.MainJFrame;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GlobalProcessors {
    public static Logger logger = Logger.getLogger(GlobalProcessors.class);
    private static Map<String, AbstractProcessor> commProcesserMap;
    private static AbstractProcessor currentProcessor;
    private static Object addremove;

    static {
        currentProcessor = null;
        commProcesserMap = new HashMap<String, AbstractProcessor>();
        addremove = 1;
    }

    public static AbstractProcessor getCurrentProcessor() {
        return currentProcessor;
    }

    public static void setCurrentProcesserIfExist(String portName) {
        AbstractProcessor processer = null;
        Collection<AbstractProcessor> processers = GlobalProcessors.getProcessersCopy();
        if (StringUtils.isNotEmpty((String)portName)) {
            processer = commProcesserMap.get(portName);
        } else if (processers.size() > 0) {
            processer = processers.iterator().next();
        } else {
            currentProcessor = null;
        }
        if (processer != null) {
            if (processer.getParalleltype() == 2) {
                if (currentProcessor != null && currentProcessor.isParent(processer)) {
                    currentProcessor = processer;
                } else {
                    for (AbstractProcessor parent : GlobalProcessors.getProcessersCopy()) {
                        if (parent.getParalleltype() != 1 || !parent.isParent(processer)) continue;
                        if (currentProcessor != null) {
                            currentProcessor.setThreadPriority(5);
                        }
                        currentProcessor = processer;
                        parent.setThreadPriority(10);
                        break;
                    }
                    if (currentProcessor == null) {
                        currentProcessor = processer;
                        currentProcessor.setThreadPriority(10);
                    }
                }
            } else {
                if (currentProcessor != null) {
                    currentProcessor.setThreadPriority(5);
                }
                currentProcessor = processer;
                currentProcessor.setThreadPriority(10);
            }
        }
        MainJFrame.getNewInstance().refreshWorkInfo();
    }

    public static boolean isExist(String name) {
        boolean result = false;
        for (String key : commProcesserMap.keySet()) {
            if (!key.startsWith(name)) continue;
            result = true;
            break;
        }
        return result;
    }

    public static AbstractProcessor getCommProcesser(String key) {
        return commProcesserMap.get(key);
    }

    public static AbstractProcessor getProcessorBySerialno(String serialno) {
        AbstractProcessor processor = null;
        for (String key : commProcesserMap.keySet()) {
            if (!key.endsWith(serialno)) continue;
            processor = commProcesserMap.get(key);
            break;
        }
        return processor;
    }

    public static AbstractProcessor getProcessorByDeviceName(String deviceName) {
        AbstractProcessor processor = null;
        for (String key : commProcesserMap.keySet()) {
            if (!key.startsWith(deviceName)) continue;
            processor = commProcesserMap.get(key);
            break;
        }
        return processor;
    }

    public static synchronized void addProcessor(String key, AbstractProcessor processor) {
        commProcesserMap.put(key, processor);
        MainJFrame.getNewInstance().refreshDeviceTree();
        EventsHandler.handleEvent(processor.getProtocol().getProtocolID(), processor.getSerialNo(), new Date(), "3001");
        GlobalProcessors.setCurrentProcesserIfExist(key);
        processor.queryCurrentTime();
        processor.queryFWVersion();
        processor.queryDeviceModel();
        processor.queryMachineInfo();
        processor.queryConfigData();
        processor.queryCapability();
        processor.queryDefaultData();
        MainJFrame.getNewInstance().refreshWorkInfo();
        System.out.println(String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())) + "  add new: " + key);
    }

    public static synchronized void removeProcessor(String key) {
        AbstractProcessor processor = GlobalProcessors.getProcessorByDeviceName(key);
        System.out.println(String.valueOf(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())) + "  remove: " + key);
        if (processor != null) {
            EventsHandler.handleEvent(processor.getProtocol().getProtocolID(), processor.getSerialNo(), new Date(), "3002");
            commProcesserMap.remove(key);
            currentProcessor = null;
            GlobalProcessors.setCurrentProcesserIfExist("");
            MainJFrame.getNewInstance().refreshWorkInfo();
            MainJFrame.getNewInstance().setDefaultValues();
            MainJFrame.getNewInstance().refreshDeviceTree();
        }
    }

    public static Map<String, AbstractProcessor> getProcessorMap() {
        return commProcesserMap;
    }

    public static void closeAllProcessers() {
        Collection<AbstractProcessor> processers = commProcesserMap.values();
        for (AbstractProcessor processer : processers) {
            processer.close();
        }
        commProcesserMap.clear();
        currentProcessor = null;
    }

    public static List<String> getSolarList() {
        ArrayList<String> solarList = new ArrayList<String>();
        for (AbstractProcessor processor : GlobalProcessors.getProcessersCopy()) {
            solarList.add(processor.processorKey());
        }
        return solarList;
    }

    public static AbstractProcessor findProcessor(String id) {
        if (commProcesserMap.containsKey(id)) {
            return commProcesserMap.get(id);
        }
        return null;
    }

    public static AbstractProcessor findProcessorBySerialno(String serialno) {
        AbstractProcessor processor = null;
        Map<String, AbstractProcessor> maps = GlobalProcessors.getProcessorMapCopy();
        for (String key : maps.keySet()) {
            if (!key.endsWith(serialno)) continue;
            processor = maps.get(key);
            break;
        }
        return processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<AbstractProcessor> getProcessersCopy() {
        Object object = addremove;
        synchronized (object) {
            ArrayList<AbstractProcessor> copy = new ArrayList<AbstractProcessor>();
            for (AbstractProcessor process : commProcesserMap.values()) {
                copy.add(process);
            }
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, AbstractProcessor> getProcessorMapCopy() {
        Object object = addremove;
        synchronized (object) {
            HashMap<String, AbstractProcessor> copy = new HashMap<String, AbstractProcessor>();
            copy.putAll(commProcesserMap);
            return copy;
        }
    }

    public static Object getUsedHandlerbyName(String name) {
        Collection<AbstractProcessor> listCopy = GlobalProcessors.getProcessersCopy();
        for (AbstractProcessor processor : listCopy) {
            ICommunicateDevice device;
            if (processor == null || (device = processor.getHandler()) == null || !device.getDeviceName().startsWith(name)) continue;
            return device;
        }
        return null;
    }

    public static List<String> getExcludeComs() {
        String notComs = GlobalVariables.limitCOMConfig.getLimitcoms();
        ArrayList<String> nonComs = new ArrayList<String>();
        String[] strComs = notComs.split(",");
        int coms_i = 0;
        while (coms_i < strComs.length) {
            nonComs.add(strComs[coms_i]);
            ++coms_i;
        }
        return nonComs;
    }

    public static String getSMSCom() {
        String str = GlobalVariables.smsConfig.getComPort();
        if (str != null) {
            return str.trim();
        }
        return "";
    }

    public static ArrayList<LocalComs> getLocalComs() {
        ArrayList<LocalComs> ports = new ArrayList<LocalComs>();
        HashSet<String> set = new HashSet<String>();
        try {
            Enumeration portEn = CommPortIdentifier.getPortIdentifiers();
            while (portEn.hasMoreElements()) {
                LocalComs allCom = new LocalComs();
                CommPortIdentifier portId = (CommPortIdentifier)portEn.nextElement();
                if (portId.getPortType() != 1) continue;
                String comName = portId.getName();
                int size = set.size();
                set.add(comName);
                int newSize = set.size();
                if (size == newSize) continue;
                if (GlobalProcessors.getUsedHandlerbyName(comName) != null) {
                    allCom.setUsed(true);
                } else {
                    allCom.setUsed(false);
                }
                if (GlobalProcessors.getExcludeComs().contains(portId.getName())) {
                    allCom.setSelected(true);
                } else {
                    allCom.setSelected(false);
                }
                allCom.setComName(comName);
                ports.add(allCom);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ports;
    }

    public static int getProcesserSize() {
        return commProcesserMap.size();
    }

    public static boolean commPortUsed(CommPortIdentifier portId) {
        try {
            SerialPort port = (SerialPort)portId.open("Arista", 2400);
            if (port != null) {
                port.close();
            }
        }
        catch (PortInUseException e) {
            return true;
        }
        return false;
    }
}

