/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

public abstract class PropertyAccessorUtils {
    public static String getPropertyName(String string) {
        int n = string.indexOf(91);
        return n != -1 ? string.substring(0, n) : string;
    }

    public static boolean isNestedOrIndexedProperty(String string) {
        if (string == null) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != '[') continue;
            return true;
        }
        return false;
    }

    public static int getFirstNestedPropertySeparatorIndex(String string) {
        return PropertyAccessorUtils.getNestedPropertySeparatorIndex(string, false);
    }

    public static int getLastNestedPropertySeparatorIndex(String string) {
        return PropertyAccessorUtils.getNestedPropertySeparatorIndex(string, true);
    }

    private static int getNestedPropertySeparatorIndex(String string, boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = string.length();
        int n3 = n = bl ? n2 - 1 : 0;
        while (bl ? n >= 0 : n < n2) {
            switch (string.charAt(n)) {
                case '[': 
                case ']': {
                    bl2 = !bl2;
                    break;
                }
                case '.': {
                    if (bl2) break;
                    return n;
                }
            }
            if (bl) {
                --n;
                continue;
            }
            ++n;
        }
        return -1;
    }

    public static boolean matchesProperty(String string, String string2) {
        if (!string.startsWith(string2)) {
            return false;
        }
        if (string.length() == string2.length()) {
            return true;
        }
        if (string.charAt(string2.length()) != '[') {
            return false;
        }
        return string.indexOf(93, string2.length() + 1) == string.length() - 1;
    }

    public static String canonicalPropertyName(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n != -1) {
            int n2;
            int n3 = stringBuffer.toString().indexOf("[", n);
            n = -1;
            if (n3 == -1 || (n2 = stringBuffer.toString().indexOf("]", n3 + "[".length())) == -1) continue;
            String string2 = stringBuffer.substring(n3 + "[".length(), n2);
            if (string2.startsWith("'") && string2.endsWith("'") || string2.startsWith("\"") && string2.endsWith("\"")) {
                stringBuffer.delete(n3 + 1, n3 + 2);
                stringBuffer.delete(n2 - 2, n2 - 1);
                n2 -= 2;
            }
            n = n2 + "]".length();
        }
        return stringBuffer.toString();
    }

    public static String[] canonicalPropertyNames(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = PropertyAccessorUtils.canonicalPropertyName(stringArray[i]);
        }
        return stringArray2;
    }
}

