/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.xml.BeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultBeanDefinitionDocumentReader
implements BeanDefinitionDocumentReader {
    public static final String BEAN_ELEMENT = "bean";
    public static final String ALIAS_ELEMENT = "alias";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ATTRIBUTE = "alias";
    public static final String IMPORT_ELEMENT = "import";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private XmlReaderContext readerContext;

    public void registerBeanDefinitions(Document document, XmlReaderContext xmlReaderContext) {
        this.readerContext = xmlReaderContext;
        this.logger.debug((Object)"Loading bean definitions");
        Element element = document.getDocumentElement();
        BeanDefinitionParserDelegate beanDefinitionParserDelegate = this.createHelper(xmlReaderContext, element);
        this.preProcessXml(element);
        this.parseBeanDefinitions(element, beanDefinitionParserDelegate);
        this.postProcessXml(element);
    }

    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext xmlReaderContext, Element element) {
        BeanDefinitionParserDelegate beanDefinitionParserDelegate = new BeanDefinitionParserDelegate(xmlReaderContext);
        beanDefinitionParserDelegate.initDefaults(element);
        return beanDefinitionParserDelegate;
    }

    protected final XmlReaderContext getReaderContext() {
        return this.readerContext;
    }

    protected Object extractSource(Element element) {
        return this.readerContext.extractSource(element);
    }

    protected void parseBeanDefinitions(Element element, BeanDefinitionParserDelegate beanDefinitionParserDelegate) {
        if (beanDefinitionParserDelegate.isDefaultNamespace(element.getNamespaceURI())) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element2 = (Element)node;
                String string = element2.getNamespaceURI();
                if (beanDefinitionParserDelegate.isDefaultNamespace(string)) {
                    this.parseDefaultElement(element2, beanDefinitionParserDelegate);
                    continue;
                }
                beanDefinitionParserDelegate.parseCustomElement(element2);
            }
        } else {
            beanDefinitionParserDelegate.parseCustomElement(element);
        }
    }

    private void parseDefaultElement(Element element, BeanDefinitionParserDelegate beanDefinitionParserDelegate) {
        if (DomUtils.nodeNameEquals((Node)element, (String)IMPORT_ELEMENT)) {
            this.importBeanDefinitionResource(element);
        } else if (DomUtils.nodeNameEquals((Node)element, (String)"alias")) {
            this.processAliasRegistration(element);
        } else if (DomUtils.nodeNameEquals((Node)element, (String)BEAN_ELEMENT)) {
            this.processBeanDefinition(element, beanDefinitionParserDelegate);
        }
    }

    protected void importBeanDefinitionResource(Element element) {
        String string = element.getAttribute(RESOURCE_ATTRIBUTE);
        if (!StringUtils.hasText((String)string)) {
            this.getReaderContext().error("Resource location must not be empty", element);
            return;
        }
        if (ResourcePatternUtils.isUrl((String)(string = SystemPropertyUtils.resolvePlaceholders((String)string)))) {
            try {
                int n = this.getReaderContext().getReader().loadBeanDefinitions(string);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + n + " bean definitions from URL location [" + string + "]"));
                }
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {
                this.getReaderContext().error("Failed to import bean definitions from URL location [" + string + "]", (Object)element, (Throwable)((Object)beanDefinitionStoreException));
            }
        } else {
            try {
                Resource resource = this.getReaderContext().getResource().createRelative(string);
                int n = this.getReaderContext().getReader().loadBeanDefinitions(resource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + n + " bean definitions from relative location [" + string + "]"));
                }
            }
            catch (IOException iOException) {
                this.getReaderContext().error("Invalid relative resource location [" + string + "] to import bean definitions from", (Object)element, iOException);
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {
                this.getReaderContext().error("Failed to import bean definitions from relative location [" + string + "]", (Object)element, (Throwable)((Object)beanDefinitionStoreException));
            }
        }
        this.getReaderContext().fireImportProcessed(string, this.extractSource(element));
    }

    protected void processAliasRegistration(Element element) {
        String string = element.getAttribute(NAME_ATTRIBUTE);
        String string2 = element.getAttribute("alias");
        boolean bl = true;
        if (!StringUtils.hasText((String)string)) {
            this.getReaderContext().error("Name must not be empty", element);
            bl = false;
        }
        if (!StringUtils.hasText((String)string2)) {
            this.getReaderContext().error("Alias must not be empty", element);
            bl = false;
        }
        if (bl) {
            try {
                this.getReaderContext().getRegistry().registerAlias(string, string2);
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {
                this.getReaderContext().error("Failed to register alias '" + string2 + "' for bean with name '" + string + "'", (Object)element, (Throwable)((Object)beanDefinitionStoreException));
            }
            this.getReaderContext().fireAliasRegistered(string, string2, this.extractSource(element));
        }
    }

    protected void processBeanDefinition(Element element, BeanDefinitionParserDelegate beanDefinitionParserDelegate) {
        BeanDefinitionHolder beanDefinitionHolder = beanDefinitionParserDelegate.parseBeanDefinitionElement(element);
        if (beanDefinitionHolder != null) {
            beanDefinitionHolder = beanDefinitionParserDelegate.decorateBeanDefinitionIfRequired(element, beanDefinitionHolder);
            try {
                BeanDefinitionReaderUtils.registerBeanDefinition(beanDefinitionHolder, this.getReaderContext().getRegistry());
            }
            catch (BeanDefinitionStoreException beanDefinitionStoreException) {
                this.getReaderContext().error("Failed to register bean definition with name '" + beanDefinitionHolder.getBeanName() + "'", (Object)element, (Throwable)((Object)beanDefinitionStoreException));
            }
            this.getReaderContext().fireComponentRegistered(new BeanComponentDefinition(beanDefinitionHolder));
        }
    }

    protected void preProcessXml(Element element) {
    }

    protected void postProcessXml(Element element) {
    }
}

