/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.plugins.communicate.tool;

import cn.com.voltronic.plugins.communicate.tool.States;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class CaptureScreen
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -6725092818706334826L;
    private static CaptureScreen captureScreen = null;
    private AAButton start;
    private AAButton cancel;
    private AAButton saveAll;
    private JPanel c;
    private AALabel jl;
    private BufferedImage get;
    private JTabbedPane jtp;
    private int index;

    public CaptureScreen() {
        this.initWindow();
        this.initOther();
    }

    public static synchronized CaptureScreen getCaptureScreen() {
        if (captureScreen == null) {
            captureScreen = new CaptureScreen();
        }
        return captureScreen;
    }

    private void initOther() {
        this.jtp = new JTabbedPane(1, 1);
    }

    private void initWindow() {
        this.start = new AAButton("message.screen");
        this.saveAll = new AAButton("message.saveall");
        this.cancel = new AAButton("message.exit");
        this.start.addActionListener(this);
        this.saveAll.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel buttonJP = new JPanel();
        this.c = new JPanel(new BorderLayout());
        this.jl = new AALabel("message.screen");
        this.jl.setHorizontalAlignment(0);
        this.jl.setFont(new Font(null, 1, 40));
        this.jl.setForeground(Color.RED);
        this.c.add((Component)this.jl, "Center");
        buttonJP.add(this.start);
        buttonJP.add(this.saveAll);
        buttonJP.add(this.cancel);
        JPanel jp = new JPanel();
        JPanel all = new JPanel();
        all.add(jp);
        all.add(buttonJP);
        this.getContentPane().add((Component)this.c, "Center");
        this.getContentPane().add((Component)all, "South");
        this.setSize(500, 400);
        this.setTitle("PrtSc");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(String.valueOf(System.getProperty("user.dir")) + File.separator + "images" + File.separator + "desk.gif"));
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CaptureScreen.this.dispose();
                CaptureScreen.captureScreen = null;
            }
        });
    }

    private void updates() {
        this.setVisible(true);
        if (this.get != null) {
            if (this.index == 0) {
                this.c.removeAll();
                this.c.add((Component)this.jtp, "Center");
            }
            PicPanel pic = new PicPanel(this.get);
            this.jtp.addTab("Screenshot" + ++this.index, pic);
            this.jtp.setSelectedComponent(pic);
            SwingUtilities.updateComponentTreeUI(this.c);
        }
    }

    private void doStart() {
        try {
            this.setVisible(false);
            Thread.sleep(500L);
            Robot ro = new Robot();
            Toolkit tk = Toolkit.getDefaultToolkit();
            Dimension di = tk.getScreenSize();
            Rectangle rec = new Rectangle(0, 0, di.width, di.height);
            BufferedImage bi = ro.createScreenCapture(rec);
            JFrame jf = new JFrame();
            Temp temp = new Temp(jf, bi, di.width, di.height);
            jf.getContentPane().add((Component)temp, "Center");
            jf.setUndecorated(true);
            jf.setSize(di);
            jf.setVisible(true);
            jf.setAlwaysOnTop(true);
        }
        catch (Exception exe) {
            exe.printStackTrace();
        }
    }

    public void doSaveAll() {
        if (this.jtp.getTabCount() == 0) {
            DisplayMessage.showErrorDialog("message.pnotnull");
            return;
        }
        JFileChooser jfc = new JFileChooser(".");
        String saveFileName = String.valueOf(new Date().getTime());
        jfc.setSelectedFile(new File(saveFileName));
        jfc.addChoosableFileFilter(new GIFfilter());
        jfc.addChoosableFileFilter(new BMPfilter());
        jfc.addChoosableFileFilter(new JPGfilter());
        jfc.addChoosableFileFilter(new PNGfilter());
        int i = jfc.showSaveDialog(this);
        if (i == 0) {
            File file = jfc.getSelectedFile();
            String about = "PNG";
            String ext = file.toString().toLowerCase();
            FileFilter ff = jfc.getFileFilter();
            if (ff instanceof JPGfilter) {
                about = "JPG";
            } else if (ff instanceof PNGfilter) {
                about = "PNG";
            } else if (ff instanceof BMPfilter) {
                about = "BMP";
            } else if (ff instanceof GIFfilter) {
                about = "GIF";
            }
            if (ext.endsWith(about.toLowerCase())) {
                ext = ext.substring(0, ext.lastIndexOf(about.toLowerCase()));
            }
            new SaveAllThread(ext, about).setVisible(true);
        }
    }

    public void doSave(BufferedImage get) {
        try {
            if (get == null) {
                DisplayMessage.showErrorDialog("message.pnotnull");
                return;
            }
            JFileChooser jfc = new JFileChooser(".");
            String saveFileName = String.valueOf(new Date().getTime());
            jfc.setSelectedFile(new File(saveFileName));
            jfc.addChoosableFileFilter(new GIFfilter());
            jfc.addChoosableFileFilter(new BMPfilter());
            jfc.addChoosableFileFilter(new JPGfilter());
            jfc.addChoosableFileFilter(new PNGfilter());
            int i = jfc.showSaveDialog(this);
            if (i == 0) {
                File file = jfc.getSelectedFile();
                String about = "PNG";
                String ext = file.toString().toLowerCase();
                FileFilter ff = jfc.getFileFilter();
                if (ff instanceof JPGfilter) {
                    if (!ext.endsWith(".jpg")) {
                        String ns = String.valueOf(ext) + ".jpg";
                        file = new File(ns);
                        about = "JPG";
                    }
                } else if (ff instanceof PNGfilter) {
                    if (!ext.endsWith(".png")) {
                        String ns = String.valueOf(ext) + ".png";
                        file = new File(ns);
                        about = "PNG";
                    }
                } else if (ff instanceof BMPfilter) {
                    if (!ext.endsWith(".bmp")) {
                        String ns = String.valueOf(ext) + ".bmp";
                        file = new File(ns);
                        about = "BMP";
                    }
                } else if (ff instanceof GIFfilter && !ext.endsWith(".gif")) {
                    String ns = String.valueOf(ext) + ".gif";
                    file = new File(ns);
                    about = "GIF";
                }
                if (!ImageIO.write((RenderedImage)get, about, file)) {
                    DisplayMessage.showErrorDialog("message.savefailure");
                }
            }
        }
        catch (Exception exe) {
            exe.printStackTrace();
        }
    }

    public void doCopy(final BufferedImage image) {
        try {
            if (this.get == null) {
                DisplayMessage.showErrorDialog("message.pnotnull");
                return;
            }
            Transferable trans = new Transferable(){

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{DataFlavor.imageFlavor};
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return DataFlavor.imageFlavor.equals(flavor);
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (this.isDataFlavorSupported(flavor)) {
                        return image;
                    }
                    throw new UnsupportedFlavorException(flavor);
                }
            };
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
            DisplayMessage.showInfoDialog("message.copyok");
        }
        catch (Exception exe) {
            exe.printStackTrace();
            DisplayMessage.showErrorDialog("message.copyerror");
        }
    }

    private void doClose(Component c) {
        this.jtp.remove(c);
        c = null;
        System.gc();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.start) {
            this.doStart();
        } else if (source == this.cancel) {
            this.dispose();
            captureScreen = null;
        } else if (source == this.saveAll) {
            this.doSaveAll();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CaptureScreen();
            }
        });
    }

    private class BMPfilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.toString().toLowerCase().endsWith(".bmp") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.BMP(BMP photo)";
        }
    }

    private class GIFfilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.toString().toLowerCase().endsWith(".gif") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.GIF(GIF photo)";
        }
    }

    private class JPGfilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.toString().toLowerCase().endsWith(".jpg") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.JPG(JPG photo)";
        }
    }

    private class PNGfilter
    extends FileFilter {
        private PNGfilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.toString().toLowerCase().endsWith(".png") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.PNG(PNG photo)";
        }
    }

    private class PicPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -7972773760939180715L;
        AAButton save;
        AAButton copy;
        AAButton close;
        BufferedImage get;

        public PicPanel(BufferedImage get) {
            super(new BorderLayout());
            this.get = get;
            this.initPanel();
        }

        public BufferedImage getImage() {
            return this.get;
        }

        private void initPanel() {
            this.save = new AAButton("message.save");
            this.copy = new AAButton("message.copyto");
            this.close = new AAButton("message.close");
            this.save.setMnemonic('S');
            this.copy.setMnemonic('C');
            this.close.setMnemonic('X');
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.copy);
            buttonPanel.add(this.save);
            buttonPanel.add(this.close);
            JLabel icon = new JLabel(new ImageIcon(this.get));
            this.add((Component)new JScrollPane(icon), "Center");
            this.add((Component)buttonPanel, "South");
            this.save.addActionListener(this);
            this.copy.addActionListener(this);
            this.close.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.save) {
                CaptureScreen.this.doSave(this.get);
            } else if (source == this.copy) {
                CaptureScreen.this.doCopy(this.get);
            } else if (source == this.close) {
                this.get = null;
                CaptureScreen.this.doClose(this);
            }
        }
    }

    private class SaveAllThread
    extends JDialog
    implements Runnable {
        private static final long serialVersionUID = -5038803742026308977L;
        private String name;
        private String ext;
        private JProgressBar jpb;
        private JLabel info;
        private int allTask;
        private int doneTask;

        public SaveAllThread(String name, String ext) {
            super(CaptureScreen.this, "Save", true);
            this.name = name;
            this.ext = ext;
            this.initWindow();
        }

        private void initWindow() {
            this.jpb = new JProgressBar();
            this.allTask = CaptureScreen.this.jtp.getTabCount();
            this.jpb.setMaximum(this.allTask);
            this.jpb.setMinimum(0);
            this.jpb.setValue(0);
            this.jpb.setStringPainted(true);
            this.setProgressBarString();
            this.info = new JLabel("message.saveing");
            this.getContentPane().setBackground(Color.CYAN);
            this.add((Component)this.info, "North");
            this.add((Component)this.jpb, "South");
            this.setUndecorated(true);
            this.setSize(300, 100);
            this.setLocationRelativeTo(CaptureScreen.this);
            new Thread(this).start();
        }

        private void setProgressBarString() {
            this.jpb.setString(this.doneTask + "/" + this.allTask);
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (i < this.allTask) {
                    PicPanel pp = (PicPanel)CaptureScreen.this.jtp.getComponentAt(i);
                    BufferedImage image = pp.getImage();
                    File f = new File(String.valueOf(this.name) + (this.doneTask + 1) + "." + this.ext.toLowerCase());
                    this.info.setText("<html><b>Save:</b><br>" + f.toString() + "</html>");
                    ImageIO.write((RenderedImage)image, this.ext, f);
                    ++this.doneTask;
                    this.jpb.setValue(this.doneTask);
                    this.setProgressBarString();
                    Thread.sleep(500L);
                    ++i;
                }
                this.dispose();
            }
            catch (Exception exe) {
                exe.printStackTrace();
                DisplayMessage.showErrorDialog("message.savefailure");
                this.dispose();
            }
        }
    }

    private class Temp
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    I18NListener {
        private static final long serialVersionUID = 6383574891411878050L;
        private BufferedImage bi;
        private int width;
        private int height;
        private int startX;
        private int startY;
        private int endX;
        private int endY;
        private int tempX;
        private int tempY;
        private JFrame jf;
        private Rectangle select = new Rectangle(0, 0, 0, 0);
        private Cursor cs = new Cursor(1);
        private States current = States.DEFAULT;
        private Rectangle[] rec;
        public static final int START_X = 1;
        public static final int START_Y = 2;
        public static final int END_X = 3;
        public static final int END_Y = 4;
        private int currentX;
        private int currentY;
        private Point p = new Point();
        private boolean showTip = true;

        public Temp(JFrame jf, BufferedImage bi, int width, int height) {
            this.jf = jf;
            this.bi = bi;
            this.width = width;
            this.height = height;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.initRecs();
        }

        private void initRecs() {
            this.rec = new Rectangle[8];
            int i = 0;
            while (i < this.rec.length) {
                this.rec[i] = new Rectangle();
                ++i;
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            g.drawImage(this.bi, 0, 0, this.width, this.height, this);
            g.setColor(Color.RED);
            g.drawLine(this.startX, this.startY, this.endX, this.startY);
            g.drawLine(this.startX, this.endY, this.endX, this.endY);
            g.drawLine(this.startX, this.startY, this.startX, this.endY);
            g.drawLine(this.endX, this.startY, this.endX, this.endY);
            int x = this.startX < this.endX ? this.startX : this.endX;
            int y = this.startY < this.endY ? this.startY : this.endY;
            this.select = new Rectangle(x, y, Math.abs(this.endX - this.startX), Math.abs(this.endY - this.startY));
            int x1 = (this.startX + this.endX) / 2;
            int y1 = (this.startY + this.endY) / 2;
            g.fillRect(x1 - 2, this.startY - 2, 5, 5);
            g.fillRect(x1 - 2, this.endY - 2, 5, 5);
            g.fillRect(this.startX - 2, y1 - 2, 5, 5);
            g.fillRect(this.endX - 2, y1 - 2, 5, 5);
            g.fillRect(this.startX - 2, this.startY - 2, 5, 5);
            g.fillRect(this.startX - 2, this.endY - 2, 5, 5);
            g.fillRect(this.endX - 2, this.startY - 2, 5, 5);
            g.fillRect(this.endX - 2, this.endY - 2, 5, 5);
            this.rec[0] = new Rectangle(x - 5, y - 5, 10, 10);
            this.rec[1] = new Rectangle(x1 - 5, y - 5, 10, 10);
            this.rec[2] = new Rectangle((this.startX > this.endX ? this.startX : this.endX) - 5, y - 5, 10, 10);
            this.rec[3] = new Rectangle((this.startX > this.endX ? this.startX : this.endX) - 5, y1 - 5, 10, 10);
            this.rec[4] = new Rectangle((this.startX > this.endX ? this.startX : this.endX) - 5, (this.startY > this.endY ? this.startY : this.endY) - 5, 10, 10);
            this.rec[5] = new Rectangle(x1 - 5, (this.startY > this.endY ? this.startY : this.endY) - 5, 10, 10);
            this.rec[6] = new Rectangle(x - 5, (this.startY > this.endY ? this.startY : this.endY) - 5, 10, 10);
            this.rec[7] = new Rectangle(x - 5, y1 - 5, 10, 10);
            if (this.showTip) {
                g.setColor(Color.CYAN);
                g.fillRect(this.p.x, this.p.y, 370, 20);
                g.setColor(Color.RED);
                g.drawRect(this.p.x, this.p.y, 370, 20);
                g.setColor(Color.BLACK);
                g.drawString(bd.getString("message.pleasehold"), this.p.x, this.p.y + 15);
            }
        }

        private void initSelect(States state) {
            switch (state) {
                case DEFAULT: {
                    this.currentX = 0;
                    this.currentY = 0;
                    break;
                }
                case EAST: {
                    this.currentX = this.endX > this.startX ? 3 : 1;
                    this.currentY = 0;
                    break;
                }
                case WEST: {
                    this.currentX = this.endX > this.startX ? 1 : 3;
                    this.currentY = 0;
                    break;
                }
                case NORTH: {
                    this.currentX = 0;
                    this.currentY = this.startY > this.endY ? 4 : 2;
                    break;
                }
                case SOUTH: {
                    this.currentX = 0;
                    this.currentY = this.startY > this.endY ? 2 : 4;
                    break;
                }
                case NORTH_EAST: {
                    this.currentY = this.startY > this.endY ? 4 : 2;
                    this.currentX = this.endX > this.startX ? 3 : 1;
                    break;
                }
                case NORTH_WEST: {
                    this.currentY = this.startY > this.endY ? 4 : 2;
                    this.currentX = this.endX > this.startX ? 1 : 3;
                    break;
                }
                case SOUTH_EAST: {
                    this.currentY = this.startY > this.endY ? 2 : 4;
                    this.currentX = this.endX > this.startX ? 3 : 1;
                    break;
                }
                case SOUTH_WEST: {
                    this.currentY = this.startY > this.endY ? 2 : 4;
                    this.currentX = this.endX > this.startX ? 1 : 3;
                    break;
                }
                default: {
                    this.currentX = 0;
                    this.currentY = 0;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent me) {
            this.doMouseMoved(me);
            this.initSelect(this.current);
            if (this.showTip) {
                this.p = me.getPoint();
                this.repaint();
            }
        }

        private void doMouseMoved(MouseEvent me) {
            if (this.select.contains(me.getPoint())) {
                this.setCursor(new Cursor(13));
                this.current = States.MOVE;
            } else {
                States[] st = States.values();
                int i = 0;
                while (i < this.rec.length) {
                    if (this.rec[i].contains(me.getPoint())) {
                        this.current = st[i];
                        this.setCursor(st[i].getCursor());
                        return;
                    }
                    ++i;
                }
                this.setCursor(this.cs);
                this.current = States.DEFAULT;
            }
        }

        @Override
        public void mouseExited(MouseEvent me) {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            int x = me.getX();
            int y = me.getY();
            if (this.current == States.MOVE) {
                this.startX += x - this.tempX;
                this.startY += y - this.tempY;
                this.endX += x - this.tempX;
                this.endY += y - this.tempY;
                this.tempX = x;
                this.tempY = y;
            } else if (this.current == States.EAST || this.current == States.WEST) {
                if (this.currentX == 1) {
                    this.startX += x - this.tempX;
                    this.tempX = x;
                } else {
                    this.endX += x - this.tempX;
                    this.tempX = x;
                }
            } else if (this.current == States.NORTH || this.current == States.SOUTH) {
                if (this.currentY == 2) {
                    this.startY += y - this.tempY;
                    this.tempY = y;
                } else {
                    this.endY += y - this.tempY;
                    this.tempY = y;
                }
            } else if (this.current == States.NORTH_EAST || this.current == States.NORTH_EAST || this.current == States.SOUTH_EAST || this.current == States.SOUTH_WEST) {
                if (this.currentY == 2) {
                    this.startY += y - this.tempY;
                    this.tempY = y;
                } else {
                    this.endY += y - this.tempY;
                    this.tempY = y;
                }
                if (this.currentX == 1) {
                    this.startX += x - this.tempX;
                    this.tempX = x;
                } else {
                    this.endX += x - this.tempX;
                    this.tempX = x;
                }
            } else {
                this.startX = this.tempX;
                this.startY = this.tempY;
                this.endX = me.getX();
                this.endY = me.getY();
            }
            this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent me) {
            this.showTip = false;
            this.tempX = me.getX();
            this.tempY = me.getY();
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                if (this.current == States.MOVE) {
                    this.showTip = true;
                    this.p = me.getPoint();
                    this.startX = 0;
                    this.startY = 0;
                    this.endX = 0;
                    this.endY = 0;
                    this.repaint();
                } else {
                    this.jf.dispose();
                    CaptureScreen.this.updates();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            Point p;
            if (me.getClickCount() == 2 && this.select.contains(p = me.getPoint())) {
                if (this.select.x + this.select.width < this.getWidth() && this.select.y + this.select.height < this.getHeight()) {
                    CaptureScreen.this.get = this.bi.getSubimage(this.select.x, this.select.y, this.select.width, this.select.height);
                    this.jf.dispose();
                    CaptureScreen.this.updates();
                } else {
                    int wid = this.select.width;
                    int het = this.select.height;
                    if (this.select.x + this.select.width >= this.getWidth()) {
                        wid = this.getWidth() - this.select.x;
                    }
                    if (this.select.y + this.select.height >= this.getHeight()) {
                        het = this.getHeight() - this.select.y;
                    }
                    CaptureScreen.this.get = this.bi.getSubimage(this.select.x, this.select.y, wid, het);
                    this.jf.dispose();
                    CaptureScreen.this.updates();
                }
            }
        }

        @Override
        public void changeLang() {
        }
    }
}

