/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.modbusprocessor;

import cn.com.voltronic.solar.beanbag.P16BeanBag;
import cn.com.voltronic.solar.communicate.ModbusHandler;
import cn.com.voltronic.solar.control.P16ModbusControlModule;
import cn.com.voltronic.solar.data.bean.Capability;
import cn.com.voltronic.solar.data.bean.ConfigData;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.WorkInfo;
import cn.com.voltronic.solar.modbusprocessor.AbstractModbusProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.wimpi.modbus.procimg.Register;
import net.wimpi.modbus.util.BitVector;

public abstract class P16ModbusProcessor
extends AbstractModbusProcessor {
    private static final double DOUBLE_TEN = 10.0;

    public P16ModbusProcessor(ModbusHandler handler, IProtocol protocol) {
        super(handler, protocol);
    }

    @Override
    protected void initBeanBag() {
        this._beanbag = new P16BeanBag();
    }

    @Override
    protected void initControlModule() {
        this._control = new P16ModbusControlModule(this.getHandler(), (ConfigData)this._beanbag.getBean("configdata"), (Capability)this._beanbag.getBean("capability"));
    }

    @Override
    public void initProtocol() {
    }

    @Override
    public boolean pollQuery() {
        super.pollQuery();
        boolean result = true;
        ModbusHandler handler = this.getHandler();
        WorkInfo workinfo = (WorkInfo)this.getBeanBag().getBean("workinfo");
        try {
            workinfo.setProdid("P16");
            workinfo.setSerialno(this.getProtocol().getSerialNo());
            Register[] queryQPIGS = handler.readMultipleRegisters(209, 30);
            double gridVoltageR = (double)queryQPIGS[0].getValue() / 10.0;
            workinfo.setGridVoltageR(gridVoltageR);
            double gridPowerR = queryQPIGS[1].getValue();
            workinfo.setGridPowerR(gridPowerR);
            double gridFrequency = (double)queryQPIGS[2].getValue() / 10.0;
            workinfo.setGridFrequency(gridFrequency);
            double gridCurrentR = queryQPIGS[3].getValue();
            workinfo.setGridCurrentR(gridCurrentR);
            double acOutputVoltageR = (double)queryQPIGS[4].getValue() / 10.0;
            workinfo.setAcOutputVoltageR(acOutputVoltageR);
            double acOutputPowerR = (double)queryQPIGS[5].getValue() / 10.0;
            workinfo.setAcOutputPowerR(acOutputPowerR);
            double acOutputFrequencyR = (double)queryQPIGS[6].getValue() / 10.0;
            workinfo.setAcOutputFrequency(acOutputFrequencyR);
            double acOutputCurrentR = (double)queryQPIGS[7].getValue() / 10.0;
            workinfo.setAcOutputCurrentR(acOutputCurrentR);
            workinfo.setOutputLoadPercent(queryQPIGS[8].getValue());
            double pBUSVoltage = (double)queryQPIGS[9].getValue() / 10.0;
            workinfo.setPBUSVoltage(pBUSVoltage);
            double sBUSVoltage = (double)queryQPIGS[10].getValue() / 10.0;
            workinfo.setSBUSVoltage(sBUSVoltage);
            double pBatteryVoltage = (double)queryQPIGS[11].getValue() / 10.0;
            workinfo.setPBatteryVoltage(pBatteryVoltage);
            double nBatteryVoltage = (double)queryQPIGS[12].getValue() / 10.0;
            workinfo.setNBatteryVoltage(nBatteryVoltage);
            int batteryCapacity = queryQPIGS[13].getValue();
            workinfo.setBatteryCapacity(batteryCapacity);
            double chargingCurrent = (double)queryQPIGS[14].getValue() / 10.0;
            workinfo.setChargingCurrent(chargingCurrent);
            int pvInputPower1 = queryQPIGS[15].getValue();
            int pvInputPower2 = queryQPIGS[16].getValue();
            int pvInputPower3 = queryQPIGS[17].getValue();
            workinfo.setPvInputPower1(pvInputPower1);
            workinfo.setPvInputPower2(pvInputPower2);
            workinfo.setPvInputPower3(pvInputPower3);
            double pvInputVoltage1 = (double)queryQPIGS[18].getValue() / 10.0;
            double pvInputVoltage2 = (double)queryQPIGS[19].getValue() / 10.0;
            double pvInputVoltage3 = (double)queryQPIGS[20].getValue() / 10.0;
            workinfo.setPvInputVoltage1(pvInputVoltage1);
            workinfo.setPvInputVoltage2(pvInputVoltage2);
            workinfo.setPvInputVoltage3(pvInputVoltage3);
            double temperature = (double)queryQPIGS[21].getValue() / 10.0;
            workinfo.setMaxTemperature(temperature);
            Register[] queryQMOD = handler.readMultipleRegisters(208, 1);
            String modestr = queryQMOD[0].toString();
            if ("Power On".equals(modestr)) {
                workinfo.setWorkMode("Power On");
            } else if ("Standby".equals(modestr)) {
                workinfo.setWorkMode("Standby");
            } else if ("Fault".equals(modestr)) {
                workinfo.setWorkMode("Fault");
            } else if ("Grid".equals(modestr)) {
                workinfo.setWorkMode("Grid");
            }
            ArrayList<BitVector> list = new ArrayList<BitVector>();
            Register[] reg = handler.readMultipleRegisters(2, 2);
            int item = 0;
            while (item < reg.length) {
                BitVector warnStatus = new BitVector(16);
                warnStatus.setBytes(reg[item].toBytes(), 16);
                warnStatus.toggleAccess(true);
                list.add(warnStatus);
                ++item;
            }
            this.setWarningStatus(list, workinfo);
        }
        catch (Exception e) {
            result = false;
            System.err.println(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean queryMachineInfo() {
        boolean result = true;
        ModbusHandler handler = this.getHandler();
        MachineInfo machineinfo = (MachineInfo)this.getBeanBag().getBean("machineinfo");
        try {
            Register[] queryQMD = handler.readMultipleRegisters(1010, 27);
            int inputPhase = queryQMD[2].getValue();
            int outputPhase = queryQMD[3].getValue();
            machineinfo.setIoPhase(String.valueOf(inputPhase) + "/" + outputPhase);
            double nominalInputVoltage = (double)queryQMD[4].getValue() / 10.0;
            machineinfo.setNominalInputVoltage(nominalInputVoltage);
            double nominalOutputVoltage = (double)queryQMD[5].getValue() / 10.0;
            machineinfo.setNominalOutputVoltage(nominalOutputVoltage);
            int outputPowerFactor = queryQMD[6].getValue();
            machineinfo.setOutputPowerFactor(outputPowerFactor);
            int outputRateVA = queryQMD[7].getValue();
            machineinfo.setOutputRateVA(outputRateVA);
            Register[] queryQPIRI = handler.readMultipleRegisters(1167, 13);
            double gridRatingVoltage = (double)queryQPIRI[0].getValue() / 10.0;
            machineinfo.setGridRatingVoltage(gridRatingVoltage);
            double gridRatingFrequency = (double)queryQPIRI[1].getValue() / 10.0;
            machineinfo.setGridRatingFrequency(gridRatingFrequency);
            double gridRatingCurrent = (double)queryQPIRI[2].getValue() / 10.0;
            machineinfo.setGridRatingCurrent(gridRatingCurrent);
            double acOutputRatingVoltage = (double)queryQPIRI[4].getValue() / 10.0;
            machineinfo.setAcOutputRatingVoltage(acOutputRatingVoltage);
            double acOutputRatingCurrent = (double)queryQPIRI[5].getValue() / 10.0;
            machineinfo.setAcOutputRatingCurrent(acOutputRatingCurrent);
            double perMPPTRatingCurrent = (double)queryQPIRI[8].getValue() / 10.0;
            machineinfo.setPerMPPTRatingCurrent(perMPPTRatingCurrent);
            double batteryRatingVoltage = (double)queryQPIRI[9].getValue() / 10.0;
            machineinfo.setBatteryRatingVoltage(batteryRatingVoltage);
            int mpptTrackNumber = queryQPIRI[10].getValue();
            machineinfo.setMpptTrackNumber(mpptTrackNumber);
            String machinetype = new String(queryQPIRI[11].toBytes()).trim();
            String gridtype = new String(queryQPIRI[12].toBytes()).trim();
            System.out.println("-----------------gridtype:" + gridtype);
        }
        catch (Exception e) {
            result = false;
            System.err.println(e.getMessage());
        }
        return result;
    }

    @Override
    public boolean queryCapability() {
        boolean result = true;
        ModbusHandler handler = this.getHandler();
        Capability capability = (Capability)this.getBeanBag().getBean("capability");
        try {
            BitVector bits = new BitVector(16);
            Register[] reg = handler.readMultipleRegisters(14, 1);
            bits.setBytes(reg[0].toBytes(), 16);
            bits.toggleAccess(true);
            capability.setCapableA(bits.getBit(0));
            capability.setCapableB(bits.getBit(1));
            capability.setCapableD(bits.getBit(2));
            capability.setCapableL(bits.getBit(3));
            capability.setCapableM(bits.getBit(4));
            capability.setCapableR(bits.getBit(5));
            capability.setCapableS(bits.getBit(6));
            capability.setCapableT(bits.getBit(7));
            capability.setCapableC(bits.getBit(8));
            capability.setCapableF(bits.getBit(9));
            capability.setCapableH(bits.getBit(10));
            capability.setCapableI(bits.getBit(11));
            capability.setCapableO(bits.getBit(12));
            capability.setCapableP(bits.getBit(13));
        }
        catch (Exception e) {
            result = false;
            System.err.println(e.getMessage());
        }
        return result;
    }

    public void setWarningStatus(List<BitVector> warnStatus, WorkInfo workinfo) {
        workinfo.clearWarning();
    }

    @Override
    public Calendar queryCurrentTime() {
        return null;
    }

    @Override
    public double queryEnergyDay(Calendar trandate) {
        return 0.0;
    }

    @Override
    public double queryEnergyHour(Calendar trandate, int hour) {
        return 0.0;
    }

    @Override
    public double queryEnergyMonth(int year, int month) {
        return 0.0;
    }

    @Override
    public double queryEnergyYear(int year) {
        return 0.0;
    }

    @Override
    public boolean queryConfigData() {
        return false;
    }

    @Override
    public void queryEnergyBeginDate() {
    }

    @Override
    public void querySelfTestResult() {
    }

    @Override
    public boolean queryDefaultData() {
        return false;
    }

    @Override
    public boolean supportSelfTest() {
        return false;
    }

    @Override
    public float getFWVersion() {
        return 0.0f;
    }

    @Override
    public float queryFWVersion() {
        return 0.0f;
    }
}

