/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.communicate.USBHandler;
import cn.com.voltronic.solar.view.component.AADialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import usb.IUSBComm;
import usb.MacUSBRemote;
import usb.USBCommEx;

public class CommunicationTool
extends AADialog {
    private static final long serialVersionUID = 1L;
    private JTextField command;
    private JComboBox deviceCB;
    private JScrollPane respondsp;
    private JTextArea respondta;
    private JButton send;
    private IUSBComm usbComm;

    public CommunicationTool(Frame parent, boolean modal) {
        super(parent, modal);
        if (SystemUtils.IS_OS_MAC_OSX) {
            MacUSBRemote macusbdriver = new MacUSBRemote();
            this.usbComm = macusbdriver;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        } else if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_SOLARIS) {
            USBCommEx usbdriver = new USBCommEx();
            this.usbComm = usbdriver;
        } else {
            USBCommEx usbdriver = new USBCommEx();
            this.usbComm = usbdriver;
        }
        this.initComponents();
    }

    private void initComponents() {
        this.deviceCB = new JComboBox();
        this.send = new JButton();
        this.command = new JTextField();
        this.respondsp = new JScrollPane();
        this.respondta = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setName("Form");
        this.deviceCB.setName("deviceCB");
        this.send.setText("send");
        this.send.setName("send");
        this.send.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CommunicationTool.this.sendActionPerformed(evt);
            }
        });
        this.command.setText("QPI");
        this.command.setName("command");
        this.respondsp.setName("respondsp");
        this.respondta.setColumns(20);
        this.respondta.setRows(5);
        this.respondta.setName("respondta");
        this.respondsp.setViewportView(this.respondta);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.respondsp, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.deviceCB, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.command, -2, 168, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.send))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.deviceCB, -2, -1, -2).addComponent(this.command, -2, -1, -2).addComponent(this.send)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.respondsp, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
        String usbDevices = this.usbComm.findUSBDevices();
        if (StringUtils.isEmpty((String)usbDevices)) {
            return;
        }
        String[] devices = usbDevices.split("#");
        this.deviceCB.setModel(new DefaultComboBoxModel<String>(devices));
    }

    private void sendActionPerformed(ActionEvent evt) {
        String usbId = this.deviceCB.getSelectedItem().toString();
        String comman = this.command.getText().trim();
        USBHandler handler = new USBHandler(this.usbComm, usbId);
        String respond = handler.excuteSimpleCommand(comman);
        this.respondta.setText(respond);
    }

    public static void main(String[] args) {
        CommunicationTool dialog = new CommunicationTool((Frame)new JFrame(), true);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        dialog.setVisible(true);
        dialog.setLocationRelativeTo(null);
    }
}

