/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.solar.view;

import cn.com.voltronic.solar.console.SolarPowerTray;
import cn.com.voltronic.solar.constants.Constants;
import cn.com.voltronic.solar.dao.BuyInfoDao;
import cn.com.voltronic.solar.data.bean.AutoLabelItem;
import cn.com.voltronic.solar.data.bean.BuyInfo;
import cn.com.voltronic.solar.data.bean.MachineInfo;
import cn.com.voltronic.solar.data.bean.ProductInfo;
import cn.com.voltronic.solar.data.bean.RatingInfo;
import cn.com.voltronic.solar.processor.AbstractProcessor;
import cn.com.voltronic.solar.protocol.IProtocol;
import cn.com.voltronic.solar.protocol.P16;
import cn.com.voltronic.solar.system.GlobalProcessors;
import cn.com.voltronic.solar.system.GlobalVariables;
import cn.com.voltronic.solar.util.DateUtils;
import cn.com.voltronic.solar.util.PageUtils;
import cn.com.voltronic.solar.view.LoginJDialog;
import cn.com.voltronic.solar.view.component.AAButton;
import cn.com.voltronic.solar.view.component.AADialog;
import cn.com.voltronic.solar.view.component.AALabel;
import cn.com.voltronic.solar.view.component.AATitleBorder;
import cn.com.voltronic.solar.view.component.ComponentFactory;
import cn.com.voltronic.solar.view.component.DisplayMessage;
import cn.com.voltronic.solar.view.component.I18NListener;
import cn.com.voltronic.solar.view.component.MyCalendarPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class MonitoredInfoJDialog
extends AADialog {
    private static final long serialVersionUID = 2431041539300038729L;
    private AAButton closeButton;
    private AAButton applyButton;
    private AALabel jLabel73;
    private AALabel jLabel74;
    private AALabel jLabel75;
    private AALabel jLabel76;
    private AALabel jLabel77;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JSpinner jSpinner1;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private IProtocol protocol;
    public MachineInfo machineInfo = new MachineInfo();
    private BuyInfoDao buyInfoDao = new BuyInfoDao();

    public MonitoredInfoJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.protocol = new P16();
        try {
            AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
            this.protocol = processor.getProtocol();
            this.machineInfo = (MachineInfo)processor.getBeanBag().getBean("machineinfo");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.protocol == null) {
            this.protocol = new P16();
        }
        this.initComponents();
        this.setTitle("message.monitorPointInfo");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel73 = new AALabel();
        this.jTextField1 = new JTextField();
        this.jLabel74 = new AALabel();
        this.jLabel75 = new AALabel();
        this.jLabel76 = new AALabel();
        this.jLabel77 = new AALabel();
        this.jTextField2 = new JTextField();
        this.applyButton = new AAButton();
        this.jPanel2 = new JPanel();
        this.closeButton = new AAButton();
        this.setBuyInfo();
        this.setDefaultCloseOperation(2);
        this.getProductInfo();
        this.getRatingInfo();
        this.jPanel5.setBorder(new AATitleBorder("message.buyinfo"));
        this.jLabel73.setText("message.devicebuydate[:]");
        this.jTextField1.setEditable(false);
        this.jTextField1.setBackground(I18NListener.bgColor);
        this.jTextField1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(MonitoredInfoJDialog.this.jTextField1);
                calendarPanel.setBounds(MonitoredInfoJDialog.this.getX() + MonitoredInfoJDialog.this.jLabel74.getX() + 30, MonitoredInfoJDialog.this.jPanel5.getY() + MonitoredInfoJDialog.this.jLabel74.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jLabel74.setIcon(new ImageIcon(Constants.DATE));
        this.jLabel74.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MyCalendarPanel calendarPanel = new MyCalendarPanel(MonitoredInfoJDialog.this.jTextField1);
                calendarPanel.setBounds(MonitoredInfoJDialog.this.getX() + MonitoredInfoJDialog.this.jLabel74.getX() + 30, MonitoredInfoJDialog.this.jPanel5.getY() + MonitoredInfoJDialog.this.jLabel74.getY() + 10, calendarPanel.getWidth(), calendarPanel.getHeight());
                calendarPanel.setVisible(true);
            }
        });
        this.jLabel75.setText("message.warranty[:]");
        this.jLabel76.setText("message.year");
        this.jLabel77.setText("message.pncode");
        this.applyButton.setText("message.apply");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SolarPowerTray.isLogin) {
                    new LoginJDialog(new Frame(), true);
                    return;
                }
                MonitoredInfoJDialog.this.applyAction();
            }
        });
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel73, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel75, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel77, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField1, -2, 102, -2).addComponent(this.jSpinner1, -1, 102, Short.MAX_VALUE).addComponent(this.jTextField2, -1, 102, Short.MAX_VALUE).addComponent(this.applyButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel74).addComponent(this.jLabel76)).addContainerGap(408, Short.MAX_VALUE)));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel73).addComponent(this.jTextField1, -2, -1, -2).addComponent(this.jLabel74)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel75).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel76)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel77).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.applyButton).addContainerGap(13, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.closeButton.setText("message.close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitoredInfoJDialog.this.dispose();
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(561, Short.MAX_VALUE).addComponent(this.closeButton).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.closeButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel2, "Last");
        this.pack();
    }

    private void applyAction() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            try {
                try {
                    this.applyButton.setEnabled(false);
                    String prodid = processor.getProtocol().getProtocolID();
                    String serialno = processor.getProtocol().getSerialNo();
                    String date = this.jTextField1.getText().trim();
                    SimpleDateFormat format = new SimpleDateFormat(GlobalVariables.globalConfig.getDateFormat());
                    Date purchasedate = new Date();
                    try {
                        purchasedate = format.parse(date);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    int warranty = Integer.parseInt(this.jSpinner1.getValue().toString().trim());
                    String pncode = this.jTextField2.getText().trim();
                    BuyInfo buyinfo = new BuyInfo();
                    buyinfo.setSerialno(serialno);
                    buyinfo.setProdid(prodid);
                    buyinfo.setPurchasedate(purchasedate);
                    buyinfo.setWarranty(warranty);
                    buyinfo.setPncode(pncode);
                    boolean result = false;
                    result = this.buyInfoDao.isExistBuyinfo(serialno) ? this.buyInfoDao.updataBuyinfo(buyinfo) : this.buyInfoDao.addBuyinfo(buyinfo);
                    if (result) {
                        DisplayMessage.showInfoDialog("message.OperationSuccess");
                    }
                    DisplayMessage.showErrorDialog("message.operationfailure");
                }
                catch (Exception ex) {
                    DisplayMessage.showErrorDialog("message.operationfailure");
                    this.applyButton.setEnabled(true);
                }
            }
            finally {
                this.applyButton.setEnabled(true);
            }
        } else {
            DisplayMessage.showWarningDialog("message.notConnectMac");
        }
    }

    private void getProductInfo() {
        this.jPanel3.setBorder(new AATitleBorder("message.productinfo"));
        ProductInfo productInfo = this.protocol.getProductInfo();
        List<AutoLabelItem> list = productInfo.getInfos();
        PageUtils.setInfoLayout(list, this.jPanel3, this);
    }

    private void getRatingInfo() {
        this.jPanel4.setBorder(new AATitleBorder("message.ratinginfo"));
        RatingInfo ratingInfo = this.protocol.getRatingInfo();
        List<AutoLabelItem> list = ratingInfo.getInfos();
        PageUtils.setTextLayout(list, this.jPanel4, this);
    }

    private void setBuyInfo() {
        AbstractProcessor processor = GlobalProcessors.getCurrentProcessor();
        if (processor != null) {
            String serialno = GlobalProcessors.getCurrentProcessor().getProtocol().getSerialNo();
            BuyInfo buyInfo = this.buyInfoDao.queryBuyinfo(serialno);
            if (buyInfo != null) {
                this.jTextField1.setText(DateUtils.getFormatDate(buyInfo.getPurchasedate()));
                this.jSpinner1 = ComponentFactory.createNumberSpinner(1, 20, 1, buyInfo.getWarranty());
                this.jTextField2.setText(buyInfo.getPncode());
            } else {
                this.jTextField1.setText(DateUtils.getNowDate());
                this.jSpinner1 = ComponentFactory.createNumberSpinner(1, 20, 1, 1);
                this.jTextField2.setText("");
            }
        } else {
            this.jTextField1.setText(DateUtils.getNowDate());
            this.jSpinner1 = ComponentFactory.createNumberSpinner(1, 20, 1, 1);
            this.jTextField2.setText("");
        }
    }
}

