/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.math.NumberUtils;

public class CompareToBuilder {
    private int comparison = 0;

    public static int reflectionCompare(Object object, Object object2) {
        return CompareToBuilder.reflectionCompare(object, object2, false, null, null);
    }

    public static int reflectionCompare(Object object, Object object2, boolean bl) {
        return CompareToBuilder.reflectionCompare(object, object2, bl, null, null);
    }

    public static int reflectionCompare(Object object, Object object2, Collection collection) {
        return CompareToBuilder.reflectionCompare(object, object2, ReflectionToStringBuilder.toNoNullStringArray(collection));
    }

    public static int reflectionCompare(Object object, Object object2, String[] stringArray) {
        return CompareToBuilder.reflectionCompare(object, object2, false, null, stringArray);
    }

    public static int reflectionCompare(Object object, Object object2, boolean bl, Class clazz) {
        return CompareToBuilder.reflectionCompare(object, object2, false, clazz, null);
    }

    public static int reflectionCompare(Object object, Object object2, boolean bl, Class clazz, String[] stringArray) {
        if (object == object2) {
            return 0;
        }
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        Class<?> clazz2 = object.getClass();
        if (!clazz2.isInstance(object2)) {
            throw new ClassCastException();
        }
        CompareToBuilder compareToBuilder = new CompareToBuilder();
        CompareToBuilder.reflectionAppend(object, object2, clazz2, compareToBuilder, bl, stringArray);
        while (clazz2.getSuperclass() != null && clazz2 != clazz) {
            clazz2 = clazz2.getSuperclass();
            CompareToBuilder.reflectionAppend(object, object2, clazz2, compareToBuilder, bl, stringArray);
        }
        return compareToBuilder.toComparison();
    }

    private static void reflectionAppend(Object object, Object object2, Class clazz, CompareToBuilder compareToBuilder, boolean bl, String[] stringArray) {
        AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
        List<String> list = stringArray != null ? Arrays.asList(stringArray) : Collections.EMPTY_LIST;
        AccessibleObject.setAccessible(accessibleObjectArray, true);
        int n = 0;
        while (n < accessibleObjectArray.length && compareToBuilder.comparison == 0) {
            AccessibleObject accessibleObject = accessibleObjectArray[n];
            if (!(list.contains(((Field)accessibleObject).getName()) || ((Field)accessibleObject).getName().indexOf(36) != -1 || !bl && Modifier.isTransient(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers()))) {
                try {
                    compareToBuilder.append(((Field)accessibleObject).get(object), ((Field)accessibleObject).get(object2));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
            ++n;
        }
    }

    public CompareToBuilder appendSuper(int n) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = n;
        return this;
    }

    public CompareToBuilder append(Object object, Object object2) {
        return this.append(object, object2, null);
    }

    public CompareToBuilder append(Object object, Object object2, Comparator comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (object == object2) {
            return this;
        }
        if (object == null) {
            this.comparison = -1;
            return this;
        }
        if (object2 == null) {
            this.comparison = 1;
            return this;
        }
        if (object.getClass().isArray()) {
            if (object instanceof long[]) {
                this.append((long[])object, (long[])object2);
            } else if (object instanceof int[]) {
                this.append((int[])object, (int[])object2);
            } else if (object instanceof short[]) {
                this.append((short[])object, (short[])object2);
            } else if (object instanceof char[]) {
                this.append((char[])object, (char[])object2);
            } else if (object instanceof byte[]) {
                this.append((byte[])object, (byte[])object2);
            } else if (object instanceof double[]) {
                this.append((double[])object, (double[])object2);
            } else if (object instanceof float[]) {
                this.append((float[])object, (float[])object2);
            } else if (object instanceof boolean[]) {
                this.append((boolean[])object, (boolean[])object2);
            } else {
                this.append((Object[])object, (Object[])object2, comparator);
            }
        } else {
            this.comparison = comparator == null ? ((Comparable)object).compareTo(object2) : comparator.compare(object, object2);
        }
        return this;
    }

    public CompareToBuilder append(long l, long l2) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = l < l2 ? -1 : (l > l2 ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(int n, int n2) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = n < n2 ? -1 : (n > n2 ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(short s, short s2) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = s < s2 ? -1 : (s > s2 ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(char c, char c2) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = c < c2 ? -1 : (c > c2 ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(byte by, byte by2) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = by < by2 ? -1 : (by > by2 ? 1 : 0);
        return this;
    }

    public CompareToBuilder append(double d, double d2) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = NumberUtils.compare(d, d2);
        return this;
    }

    public CompareToBuilder append(float f, float f2) {
        if (this.comparison != 0) {
            return this;
        }
        this.comparison = NumberUtils.compare(f, f2);
        return this;
    }

    public CompareToBuilder append(boolean bl, boolean bl2) {
        if (this.comparison != 0) {
            return this;
        }
        if (bl == bl2) {
            return this;
        }
        this.comparison = !bl ? -1 : 1;
        return this;
    }

    public CompareToBuilder append(Object[] objectArray, Object[] objectArray2) {
        return this.append(objectArray, objectArray2, (Comparator)null);
    }

    public CompareToBuilder append(Object[] objectArray, Object[] objectArray2, Comparator comparator) {
        if (this.comparison != 0) {
            return this;
        }
        if (objectArray == objectArray2) {
            return this;
        }
        if (objectArray == null) {
            this.comparison = -1;
            return this;
        }
        if (objectArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (objectArray.length != objectArray2.length) {
            this.comparison = objectArray.length < objectArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < objectArray.length && this.comparison == 0) {
            this.append(objectArray[n], objectArray2[n], comparator);
            ++n;
        }
        return this;
    }

    public CompareToBuilder append(long[] lArray, long[] lArray2) {
        if (this.comparison != 0) {
            return this;
        }
        if (lArray == lArray2) {
            return this;
        }
        if (lArray == null) {
            this.comparison = -1;
            return this;
        }
        if (lArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (lArray.length != lArray2.length) {
            this.comparison = lArray.length < lArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < lArray.length && this.comparison == 0) {
            this.append(lArray[n], lArray2[n]);
            ++n;
        }
        return this;
    }

    public CompareToBuilder append(int[] nArray, int[] nArray2) {
        if (this.comparison != 0) {
            return this;
        }
        if (nArray == nArray2) {
            return this;
        }
        if (nArray == null) {
            this.comparison = -1;
            return this;
        }
        if (nArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (nArray.length != nArray2.length) {
            this.comparison = nArray.length < nArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < nArray.length && this.comparison == 0) {
            this.append(nArray[n], nArray2[n]);
            ++n;
        }
        return this;
    }

    public CompareToBuilder append(short[] sArray, short[] sArray2) {
        if (this.comparison != 0) {
            return this;
        }
        if (sArray == sArray2) {
            return this;
        }
        if (sArray == null) {
            this.comparison = -1;
            return this;
        }
        if (sArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (sArray.length != sArray2.length) {
            this.comparison = sArray.length < sArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < sArray.length && this.comparison == 0) {
            this.append(sArray[n], sArray2[n]);
            ++n;
        }
        return this;
    }

    public CompareToBuilder append(char[] cArray, char[] cArray2) {
        if (this.comparison != 0) {
            return this;
        }
        if (cArray == cArray2) {
            return this;
        }
        if (cArray == null) {
            this.comparison = -1;
            return this;
        }
        if (cArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (cArray.length != cArray2.length) {
            this.comparison = cArray.length < cArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < cArray.length && this.comparison == 0) {
            this.append(cArray[n], cArray2[n]);
            ++n;
        }
        return this;
    }

    public CompareToBuilder append(byte[] byArray, byte[] byArray2) {
        if (this.comparison != 0) {
            return this;
        }
        if (byArray == byArray2) {
            return this;
        }
        if (byArray == null) {
            this.comparison = -1;
            return this;
        }
        if (byArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (byArray.length != byArray2.length) {
            this.comparison = byArray.length < byArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < byArray.length && this.comparison == 0) {
            this.append(byArray[n], byArray2[n]);
            ++n;
        }
        return this;
    }

    public CompareToBuilder append(double[] dArray, double[] dArray2) {
        if (this.comparison != 0) {
            return this;
        }
        if (dArray == dArray2) {
            return this;
        }
        if (dArray == null) {
            this.comparison = -1;
            return this;
        }
        if (dArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (dArray.length != dArray2.length) {
            this.comparison = dArray.length < dArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < dArray.length && this.comparison == 0) {
            this.append(dArray[n], dArray2[n]);
            ++n;
        }
        return this;
    }

    public CompareToBuilder append(float[] fArray, float[] fArray2) {
        if (this.comparison != 0) {
            return this;
        }
        if (fArray == fArray2) {
            return this;
        }
        if (fArray == null) {
            this.comparison = -1;
            return this;
        }
        if (fArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (fArray.length != fArray2.length) {
            this.comparison = fArray.length < fArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < fArray.length && this.comparison == 0) {
            this.append(fArray[n], fArray2[n]);
            ++n;
        }
        return this;
    }

    public CompareToBuilder append(boolean[] blArray, boolean[] blArray2) {
        if (this.comparison != 0) {
            return this;
        }
        if (blArray == blArray2) {
            return this;
        }
        if (blArray == null) {
            this.comparison = -1;
            return this;
        }
        if (blArray2 == null) {
            this.comparison = 1;
            return this;
        }
        if (blArray.length != blArray2.length) {
            this.comparison = blArray.length < blArray2.length ? -1 : 1;
            return this;
        }
        int n = 0;
        while (n < blArray.length && this.comparison == 0) {
            this.append(blArray[n], blArray2[n]);
            ++n;
        }
        return this;
    }

    public int toComparison() {
        return this.comparison;
    }
}

