/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.lang.Entities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.NestableRuntimeException;

public class StringEscapeUtils {
    public static String escapeJava(String string) {
        return StringEscapeUtils.escapeJavaStyleString(string, false);
    }

    public static void escapeJava(Writer writer, String string) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(writer, string, false);
    }

    public static String escapeJavaScript(String string) {
        return StringEscapeUtils.escapeJavaStyleString(string, true);
    }

    public static void escapeJavaScript(Writer writer, String string) throws IOException {
        StringEscapeUtils.escapeJavaStyleString(writer, string, true);
    }

    private static String escapeJavaStyleString(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length() * 2);
            StringEscapeUtils.escapeJavaStyleString(stringWriter, string, bl);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static void escapeJavaStyleString(Writer writer, String string, boolean bl) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c > '\u0fff') {
                writer.write("\\u" + StringEscapeUtils.hex(c));
            } else if (c > '\u00ff') {
                writer.write("\\u0" + StringEscapeUtils.hex(c));
            } else if (c > '\u007f') {
                writer.write("\\u00" + StringEscapeUtils.hex(c));
            } else if (c < ' ') {
                switch (c) {
                    case '\b': {
                        writer.write(92);
                        writer.write(98);
                        break;
                    }
                    case '\n': {
                        writer.write(92);
                        writer.write(110);
                        break;
                    }
                    case '\t': {
                        writer.write(92);
                        writer.write(116);
                        break;
                    }
                    case '\f': {
                        writer.write(92);
                        writer.write(102);
                        break;
                    }
                    case '\r': {
                        writer.write(92);
                        writer.write(114);
                        break;
                    }
                    default: {
                        if (c > '\u000f') {
                            writer.write("\\u00" + StringEscapeUtils.hex(c));
                            break;
                        }
                        writer.write("\\u000" + StringEscapeUtils.hex(c));
                        break;
                    }
                }
            } else {
                switch (c) {
                    case '\'': {
                        if (bl) {
                            writer.write(92);
                        }
                        writer.write(39);
                        break;
                    }
                    case '\"': {
                        writer.write(92);
                        writer.write(34);
                        break;
                    }
                    case '\\': {
                        writer.write(92);
                        writer.write(92);
                        break;
                    }
                    default: {
                        writer.write(c);
                    }
                }
            }
            ++n2;
        }
    }

    private static String hex(char c) {
        return Integer.toHexString(c).toUpperCase();
    }

    public static String unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter(string.length());
            StringEscapeUtils.unescapeJava(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void unescapeJava(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (string == null) {
            return;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(4);
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (bl2) {
                stringBuffer.append(c);
                if (stringBuffer.length() == 4) {
                    try {
                        int n3 = Integer.parseInt(stringBuffer.toString(), 16);
                        writer.write((char)n3);
                        stringBuffer.setLength(0);
                        bl2 = false;
                        bl = false;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new NestableRuntimeException("Unable to parse unicode value: " + stringBuffer, numberFormatException);
                    }
                }
            } else if (bl) {
                bl = false;
                switch (c) {
                    case '\\': {
                        writer.write(92);
                        break;
                    }
                    case '\'': {
                        writer.write(39);
                        break;
                    }
                    case '\"': {
                        writer.write(34);
                        break;
                    }
                    case 'r': {
                        writer.write(13);
                        break;
                    }
                    case 'f': {
                        writer.write(12);
                        break;
                    }
                    case 't': {
                        writer.write(9);
                        break;
                    }
                    case 'n': {
                        writer.write(10);
                        break;
                    }
                    case 'b': {
                        writer.write(8);
                        break;
                    }
                    case 'u': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        writer.write(c);
                        break;
                    }
                }
            } else if (c == '\\') {
                bl = true;
            } else {
                writer.write(c);
            }
            ++n2;
        }
        if (bl) {
            writer.write(92);
        }
    }

    public static String unescapeJavaScript(String string) {
        return StringEscapeUtils.unescapeJava(string);
    }

    public static void unescapeJavaScript(Writer writer, String string) throws IOException {
        StringEscapeUtils.unescapeJava(writer, string);
    }

    public static String escapeHtml(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter((int)((double)string.length() * 1.5));
            StringEscapeUtils.escapeHtml(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void escapeHtml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.HTML40.escape(writer, string);
    }

    public static String unescapeHtml(String string) {
        if (string == null) {
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter((int)((double)string.length() * 1.5));
            StringEscapeUtils.unescapeHtml(stringWriter, string);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public static void unescapeHtml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.HTML40.unescape(writer, string);
    }

    public static void escapeXml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.XML.escape(writer, string);
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        return Entities.XML.escape(string);
    }

    public static void unescapeXml(Writer writer, String string) throws IOException {
        if (writer == null) {
            throw new IllegalArgumentException("The Writer must not be null.");
        }
        if (string == null) {
            return;
        }
        Entities.XML.unescape(writer, string);
    }

    public static String unescapeXml(String string) {
        if (string == null) {
            return null;
        }
        return Entities.XML.unescape(string);
    }

    public static String escapeSql(String string) {
        if (string == null) {
            return null;
        }
        return StringUtils.replace(string, "'", "''");
    }
}

