/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Tube;

public final class NextAction {
    int kind;
    Tube next;
    Packet packet;
    Throwable throwable;
    static final int INVOKE = 0;
    static final int INVOKE_AND_FORGET = 1;
    static final int RETURN = 2;
    static final int THROW = 3;
    static final int SUSPEND = 4;

    private void set(int n, Tube tube, Packet packet, Throwable throwable) {
        this.kind = n;
        this.next = tube;
        this.packet = packet;
        this.throwable = throwable;
    }

    public void invoke(Tube tube, Packet packet) {
        this.set(0, tube, packet, null);
    }

    public void invokeAndForget(Tube tube, Packet packet) {
        this.set(1, tube, packet, null);
    }

    public void returnWith(Packet packet) {
        this.set(2, null, packet, null);
    }

    public void throwException(Throwable throwable) {
        assert (throwable instanceof RuntimeException || throwable instanceof Error);
        this.set(3, null, null, throwable);
    }

    public void suspend() {
        this.set(4, null, null, null);
    }

    public void suspend(Tube tube) {
        this.set(4, tube, null, null);
    }

    public Tube getNext() {
        return this.next;
    }

    public Packet getPacket() {
        return this.packet;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString()).append(" [");
        stringBuilder.append("kind=").append(this.getKindString()).append(',');
        stringBuilder.append("next=").append(this.next).append(',');
        stringBuilder.append("packet=").append(this.packet).append(',');
        stringBuilder.append("throwable=").append(this.throwable).append(']');
        return stringBuilder.toString();
    }

    public String getKindString() {
        switch (this.kind) {
            case 0: {
                return "INVOKE";
            }
            case 1: {
                return "INVOKE_AND_FORGET";
            }
            case 2: {
                return "RETURN";
            }
            case 3: {
                return "THROW";
            }
            case 4: {
                return "SUSPEND";
            }
        }
        throw new AssertionError(this.kind);
    }
}

