/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.finder.ClassFinder;
import com.sun.beans.finder.ConstructorFinder;
import com.sun.beans.finder.MethodFinder;
import java.beans.ConstructorProperties;
import java.beans.ExceptionListener;
import java.beans.NameGenerator;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.reflect.misc.MethodUtil;

public class Statement {
    private static Object[] emptyArray = new Object[0];
    static ExceptionListener defaultExceptionListener = new ExceptionListener(){

        @Override
        public void exceptionThrown(Exception exception) {
            System.err.println(exception);
            System.err.println("Continuing ...");
        }
    };
    private final AccessControlContext acc = AccessController.getContext();
    private final Object target;
    private final String methodName;
    private final Object[] arguments;
    ClassLoader loader;

    @ConstructorProperties(value={"target", "methodName", "arguments"})
    public Statement(Object object, String string, Object[] objectArray) {
        this.target = object;
        this.methodName = string;
        this.arguments = objectArray == null ? emptyArray : objectArray;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void execute() throws Exception {
        this.invoke();
    }

    Object invoke() throws Exception {
        AccessControlContext accessControlContext = this.acc;
        if (accessControlContext == null && System.getSecurityManager() != null) {
            throw new SecurityException("AccessControlContext is not set");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return Statement.this.invokeInternal();
                }
            }, accessControlContext);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw privilegedActionException.getException();
        }
    }

    private Object invokeInternal() throws Exception {
        Object object = this.getTarget();
        String string = this.getMethodName();
        if (object == null || string == null) {
            throw new NullPointerException((object == null ? "target" : "methodName") + " should not be null");
        }
        Object[] objectArray = this.getArguments();
        if (objectArray == null) {
            objectArray = emptyArray;
        }
        if (object == Class.class && string.equals("forName")) {
            return ClassFinder.resolveClass((String)objectArray[0], this.loader);
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            classArray[i] = objectArray[i] == null ? null : objectArray[i].getClass();
        }
        AccessibleObject accessibleObject = null;
        if (object instanceof Class) {
            if (string.equals("new")) {
                string = "newInstance";
            }
            if (string.equals("newInstance") && ((Class)object).isArray()) {
                Object object2 = Array.newInstance(((Class)object).getComponentType(), objectArray.length);
                for (int i = 0; i < objectArray.length; ++i) {
                    Array.set(object2, i, objectArray[i]);
                }
                return object2;
            }
            if (string.equals("newInstance") && objectArray.length != 0) {
                if (object == Character.class && objectArray.length == 1 && classArray[0] == String.class) {
                    return new Character(((String)objectArray[0]).charAt(0));
                }
                try {
                    accessibleObject = ConstructorFinder.findConstructor((Class)object, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    accessibleObject = null;
                }
            }
            if (accessibleObject == null && object != Class.class) {
                accessibleObject = Statement.getMethod((Class)object, string, classArray);
            }
            if (accessibleObject == null) {
                accessibleObject = Statement.getMethod(Class.class, string, classArray);
            }
        } else {
            if (object.getClass().isArray() && (string.equals("set") || string.equals("get"))) {
                int n = (Integer)objectArray[0];
                if (string.equals("get")) {
                    return Array.get(object, n);
                }
                Array.set(object, n, objectArray[1]);
                return null;
            }
            accessibleObject = Statement.getMethod(object.getClass(), string, classArray);
        }
        if (accessibleObject != null) {
            try {
                if (accessibleObject instanceof Method) {
                    return MethodUtil.invoke(accessibleObject, object, objectArray);
                }
                return ((Constructor)accessibleObject).newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Exception("Statement cannot invoke: " + string + " on " + object.getClass(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw invocationTargetException;
            }
        }
        throw new NoSuchMethodException(this.toString());
    }

    String instanceName(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass() == String.class) {
            return "\"" + (String)object + "\"";
        }
        return NameGenerator.unqualifiedClassName(object.getClass());
    }

    public String toString() {
        Object object = this.getTarget();
        String string = this.getMethodName();
        Object[] objectArray = this.getArguments();
        if (objectArray == null) {
            objectArray = emptyArray;
        }
        StringBuffer stringBuffer = new StringBuffer(this.instanceName(object) + "." + string + "(");
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.instanceName(objectArray[i]));
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(");");
        return stringBuffer.toString();
    }

    static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return MethodFinder.findMethod(clazz, string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }
}

