/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Method;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class MethodOverride
implements BeanMetadataElement {
    private final String methodName;
    private boolean overloaded = true;
    private Object source;

    protected MethodOverride(String string) {
        Assert.notNull((Object)string, (String)"Method name must not be null");
        this.methodName = string;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected void setOverloaded(boolean bl) {
        this.overloaded = bl;
    }

    protected boolean isOverloaded() {
        return this.overloaded;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public Object getSource() {
        return this.source;
    }

    public abstract boolean matches(Method var1);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MethodOverride)) {
            return false;
        }
        MethodOverride methodOverride = (MethodOverride)object;
        return ObjectUtils.nullSafeEquals((Object)this.methodName, (Object)methodOverride.methodName) && this.overloaded == methodOverride.overloaded && ObjectUtils.nullSafeEquals((Object)this.source, (Object)methodOverride.source);
    }

    public int hashCode() {
        int n = ObjectUtils.nullSafeHashCode((Object)this.methodName);
        n = 29 * n + ObjectUtils.nullSafeHashCode((Object)this.source);
        n = 29 * n + (this.overloaded ? 1 : 0);
        return n;
    }
}

