/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import org.springframework.core.CollectionFactory;

public class CustomCollectionEditor
extends PropertyEditorSupport {
    private final Class collectionType;
    private final boolean nullAsEmptyCollection;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$SortedSet;

    public CustomCollectionEditor(Class clazz) {
        this(clazz, false);
    }

    public CustomCollectionEditor(Class clazz, boolean bl) {
        if (clazz == null) {
            throw new IllegalArgumentException("Collection type is required");
        }
        if (!(class$java$util$Collection == null ? (class$java$util$Collection = CustomCollectionEditor.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Collection type [" + clazz.getName() + "] does not implement [java.util.Collection]");
        }
        this.collectionType = clazz;
        this.nullAsEmptyCollection = bl;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public void setValue(Object object) {
        if (object == null && this.nullAsEmptyCollection) {
            super.setValue(this.createCollection(this.collectionType, 0));
        } else if (object == null || this.collectionType.isInstance(object) && !this.alwaysCreateNewCollection()) {
            super.setValue(object);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Collection collection2 = this.createCollection(this.collectionType, collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                collection2.add(this.convertElement(iterator.next()));
            }
            super.setValue(collection2);
        } else if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            Collection collection = this.createCollection(this.collectionType, n);
            for (int i = 0; i < n; ++i) {
                collection.add(this.convertElement(Array.get(object, i)));
            }
            super.setValue(collection);
        } else {
            Collection collection = this.createCollection(this.collectionType, 1);
            collection.add(this.convertElement(object));
            super.setValue(collection);
        }
    }

    protected Collection createCollection(Class clazz, int n) {
        if (!clazz.isInterface()) {
            try {
                return (Collection)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Could not instantiate collection class [" + clazz.getName() + "]: " + exception.getMessage());
            }
        }
        if ((class$java$util$List == null ? (class$java$util$List = CustomCollectionEditor.class$("java.util.List")) : class$java$util$List).equals(clazz)) {
            return new ArrayList(n);
        }
        if ((class$java$util$SortedSet == null ? (class$java$util$SortedSet = CustomCollectionEditor.class$("java.util.SortedSet")) : class$java$util$SortedSet).equals(clazz)) {
            return new TreeSet();
        }
        return CollectionFactory.createLinkedSetIfPossible((int)n);
    }

    protected boolean alwaysCreateNewCollection() {
        return false;
    }

    protected Object convertElement(Object object) {
        return object;
    }

    public String getAsText() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

