/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.springframework.util.StringUtils;

public class CustomDateEditor
extends PropertyEditorSupport {
    private final DateFormat dateFormat;
    private final boolean allowEmpty;
    private final int exactDateLength;

    public CustomDateEditor(DateFormat dateFormat, boolean bl) {
        this.dateFormat = dateFormat;
        this.allowEmpty = bl;
        this.exactDateLength = -1;
    }

    public CustomDateEditor(DateFormat dateFormat, boolean bl, int n) {
        this.dateFormat = dateFormat;
        this.allowEmpty = bl;
        this.exactDateLength = n;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (this.allowEmpty && !StringUtils.hasText((String)string)) {
            this.setValue(null);
        } else {
            if (string != null && this.exactDateLength >= 0 && string.length() != this.exactDateLength) {
                throw new IllegalArgumentException("Could not parse date: it is not exactly" + this.exactDateLength + "characters long");
            }
            try {
                this.setValue(this.dateFormat.parse(string));
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("Could not parse date: " + parseException.getMessage());
            }
        }
    }

    public String getAsText() {
        Date date = (Date)this.getValue();
        return date != null ? this.dateFormat.format(date) : "";
    }
}

