/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.style;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.ReflectiveVisitorHelper;
import org.springframework.core.style.ValueStyler;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class DefaultValueStyler
implements ValueStyler {
    private static final String EMPTY = "[empty]";
    private static final String NULL = "[null]";
    private static final String COLLECTION = "collection";
    private static final String SET = "set";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String ARRAY = "array";
    private final ReflectiveVisitorHelper reflectiveVisitorHelper = new ReflectiveVisitorHelper();

    public String style(Object object) {
        return (String)this.reflectiveVisitorHelper.invokeVisit(this, object);
    }

    String visit(String string) {
        return '\'' + string + '\'';
    }

    String visit(Number number) {
        return String.valueOf(number);
    }

    String visit(Class clazz) {
        return ClassUtils.getShortName(clazz);
    }

    String visit(Method method) {
        return method.getName() + "@" + ClassUtils.getShortName(method.getDeclaringClass());
    }

    String visit(Map map) {
        StringBuffer stringBuffer = new StringBuffer(map.size() * 8 + 16);
        stringBuffer.append("map[");
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(this.style(entry));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',').append(' ');
        }
        if (map.isEmpty()) {
            stringBuffer.append(EMPTY);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    String visit(Map.Entry entry) {
        return this.style(entry.getKey()) + " -> " + this.style(entry.getValue());
    }

    String visit(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer(collection.size() * 8 + 16);
        stringBuffer.append(this.getCollectionTypeString(collection) + "[");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.style(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(',').append(' ');
        }
        if (collection.isEmpty()) {
            stringBuffer.append(EMPTY);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private String getCollectionTypeString(Collection collection) {
        if (collection instanceof List) {
            return LIST;
        }
        if (collection instanceof Set) {
            return SET;
        }
        return COLLECTION;
    }

    String visit(Object object) {
        if (object.getClass().isArray()) {
            return this.styleArray(ObjectUtils.toObjectArray(object));
        }
        return String.valueOf(object);
    }

    String visitNull() {
        return NULL;
    }

    private String styleArray(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer(objectArray.length * 8 + 16);
        stringBuffer.append("array<" + ClassUtils.getShortName(objectArray.getClass().getComponentType()) + ">[");
        for (int i = 0; i < objectArray.length - 1; ++i) {
            stringBuffer.append(this.style(objectArray[i]));
            stringBuffer.append(',').append(' ');
        }
        if (objectArray.length > 0) {
            stringBuffer.append(this.style(objectArray[objectArray.length - 1]));
        } else {
            stringBuffer.append(EMPTY);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

